import type { PostNotificationsMode } from "./PostNotificationsMode";
export type PostActions = {
    /**
     * When the post was read.
     */
    read_at?: string;
    /**
     * When was the last time you read the comments.
     */
    read_comments_at?: string;
    /**
     * When the post was saved.
     */
    saved_at?: string;
    /**
     * When the post was upvoted or downvoted.
     */
    voted_at?: string;
    /**
     * When the post was hidden.
     */
    hidden_at?: string;
    /**
     * The number of comments you read last. Subtract this from total comments to get an unread
     * count.
     */
    read_comments_amount?: number;
    /**
     * True if upvoted, false if downvoted. Upvote is greater than downvote.
     */
    vote_is_upvote?: boolean;
    notifications?: PostNotificationsMode;
};
