import type { CommunityId } from "./CommunityId";
import type { DbUrl } from "./DbUrl";
import type { LanguageId } from "./LanguageId";
import type { PersonId } from "./PersonId";
import type { PostId } from "./PostId";
/**
 * A post.
 */
export type Post = {
    id: PostId;
    name: string;
    /**
     * An optional link / url for the post.
     */
    url?: DbUrl;
    /**
     * An optional post body, in markdown.
     */
    body?: string;
    creator_id: PersonId;
    community_id: CommunityId;
    /**
     * Whether the post is removed.
     */
    removed: boolean;
    /**
     * Whether the post is locked.
     */
    locked: boolean;
    published_at: string;
    updated_at?: string;
    /**
     * Whether the post is deleted.
     */
    deleted: boolean;
    /**
     * Whether the post is NSFW.
     */
    nsfw: boolean;
    /**
     * A title for the link.
     */
    embed_title?: string;
    /**
     * A description for the link.
     */
    embed_description?: string;
    /**
     * A thumbnail picture url.
     */
    thumbnail_url?: DbUrl;
    /**
     * The federated activity id / ap_id.
     */
    ap_id: DbUrl;
    /**
     * Whether the post is local.
     */
    local: boolean;
    /**
     * A video url for the link.
     */
    embed_video_url?: DbUrl;
    language_id: LanguageId;
    /**
     * Whether the post is featured to its community.
     */
    featured_community: boolean;
    /**
     * Whether the post is featured to its site.
     */
    featured_local: boolean;
    url_content_type?: string;
    /**
     * An optional alt_text, usable for image posts.
     */
    alt_text?: string;
    /**
     * Time at which the post will be published. None means publish immediately.
     */
    scheduled_publish_time_at?: string;
    /**
     * The time of the newest comment in the post, if the post has any comments.
     */
    newest_comment_time_at?: string;
    comments: number;
    score: number;
    upvotes: number;
    downvotes: number;
    report_count: number;
    unresolved_report_count: number;
    /**
     * If a local user posts in a remote community, the comment is hidden until it is confirmed
     * accepted by the community (by receiving it back via federation).
     */
    federation_pending: boolean;
    embed_video_width?: number;
    embed_video_height?: number;
};
