import type { PaginationCursor } from "./PaginationCursor";
/**
 * This response contains only a single page of items. To get the next page, take the
 * cursor string from `next_page` and pass it to the same API endpoint via `page_cursor`
 * parameter. For going to the previous page, use `prev_page` instead.
 */
export type PagedResponse<T> = {
    items: Array<T>;
    next_page?: PaginationCursor;
    prev_page?: PaginationCursor;
};
