import type { Community } from "./Community";
import type { CommunityFollowerView } from "./CommunityFollowerView";
import type { CommunityModeratorView } from "./CommunityModeratorView";
import type { Instance } from "./Instance";
import type { LanguageId } from "./LanguageId";
import type { LocalUserView } from "./LocalUserView";
import type { MultiCommunityView } from "./MultiCommunityView";
import type { Person } from "./Person";
/**
 * Your user info.
 */
export type MyUserInfo = {
    local_user_view: LocalUserView;
    follows: Array<CommunityFollowerView>;
    moderates: Array<CommunityModeratorView>;
    multi_community_follows: Array<MultiCommunityView>;
    community_blocks: Array<Community>;
    instance_communities_blocks: Array<Instance>;
    instance_persons_blocks: Array<Instance>;
    person_blocks: Array<Person>;
    keyword_blocks: Array<string>;
    discussion_languages: Array<LanguageId>;
};
