import type { CommunityId } from "./CommunityId";
import type { PaginationCursor } from "./PaginationCursor";
import type { PostId } from "./PostId";
import type { ReportType } from "./ReportType";
/**
 * List reports.
 */
export type ListReports = {
    /**
     * Only shows the unresolved reports
     */
    unresolved_only?: boolean;
    /**
     * Filter the type of report.
     */
    type_?: ReportType;
    /**
     * Filter by the post id. Can return either comment or post reports.
     */
    post_id?: PostId;
    /**
     * if no community is given, it returns reports for all communities moderated by the auth user
     */
    community_id?: CommunityId;
    page_cursor?: PaginationCursor;
    limit?: number;
    /**
     * Only for admins: also show reports with `violates_instance_rules=false`
     */
    show_community_rule_violations?: boolean;
    /**
     * If true, view all your created reports. Works for non-admins/mods also.
     */
    my_reports_only?: boolean;
};
