import type { UntranslatedError } from "./UntranslatedError";
/**
 * Errors used in the API, all of these are translated in lemmy-ui.
 */
export type LemmyErrorType = {
    error: "block_keyword_too_short";
} | {
    error: "block_keyword_too_long";
} | {
    error: "couldnt_update";
} | {
    error: "couldnt_create";
} | {
    error: "report_reason_required";
} | {
    error: "report_too_long";
} | {
    error: "not_a_moderator";
} | {
    error: "not_an_admin";
} | {
    error: "cant_block_yourself";
} | {
    error: "cant_note_yourself";
} | {
    error: "cant_block_admin";
} | {
    error: "passwords_do_not_match";
} | {
    error: "email_not_verified";
} | {
    error: "email_required";
} | {
    error: "cannot_leave_admin";
} | {
    error: "cannot_leave_mod";
} | {
    error: "pictrs_response_error";
    message: string;
} | {
    error: "pictrs_purge_response_error";
    message: string;
} | {
    error: "pictrs_api_key_not_provided";
} | {
    error: "pictrs_invalid_image_upload";
    message: string;
} | {
    error: "no_content_type_header";
} | {
    error: "not_an_image_type";
} | {
    error: "image_upload_disabled";
} | {
    error: "not_a_mod_or_admin";
} | {
    error: "not_top_mod";
} | {
    error: "not_logged_in";
} | {
    error: "not_higher_mod";
} | {
    error: "not_higher_admin";
} | {
    error: "site_ban";
} | {
    error: "deleted";
} | {
    error: "person_is_blocked";
} | {
    error: "community_is_blocked";
} | {
    error: "instance_is_blocked";
} | {
    error: "instance_is_private";
} | {
    error: "invalid_password";
} | {
    error: "site_description_length_overflow";
} | {
    error: "honeypot_failed";
} | {
    error: "registration_application_is_pending";
} | {
    error: "locked";
} | {
    error: "max_comment_depth_reached";
} | {
    error: "no_comment_edit_allowed";
} | {
    error: "only_admins_can_create_communities";
} | {
    error: "already_exists";
} | {
    error: "language_not_allowed";
} | {
    error: "no_post_edit_allowed";
} | {
    error: "nsfw_not_allowed";
} | {
    error: "edit_private_message_not_allowed";
} | {
    error: "application_question_required";
} | {
    error: "invalid_default_post_listing_type";
} | {
    error: "registration_closed";
} | {
    error: "registration_application_answer_required";
} | {
    error: "registration_username_required";
} | {
    error: "email_already_taken";
} | {
    error: "username_already_taken";
} | {
    error: "person_is_banned_from_community";
} | {
    error: "no_id_given";
} | {
    error: "incorrect_login";
} | {
    error: "no_email_setup";
} | {
    error: "local_site_not_setup";
} | {
    error: "invalid_email_address";
    message: string;
} | {
    error: "invalid_name";
} | {
    error: "invalid_code_verifier";
} | {
    error: "invalid_display_name";
} | {
    error: "invalid_matrix_id";
} | {
    error: "invalid_post_title";
} | {
    error: "invalid_body_field";
} | {
    error: "bio_length_overflow";
} | {
    error: "alt_text_length_overflow";
} | {
    error: "couldnt_parse_totp_secret";
} | {
    error: "couldnt_generate_totp";
} | {
    error: "missing_totp_token";
} | {
    error: "missing_totp_secret";
} | {
    error: "incorrect_totp_token";
} | {
    error: "totp_already_enabled";
} | {
    error: "blocked_url";
} | {
    error: "invalid_url";
} | {
    error: "email_send_failed";
} | {
    error: "slurs";
} | {
    error: "registration_denied";
    message: {
        reason?: string;
    };
} | {
    error: "site_name_required";
} | {
    error: "site_name_length_overflow";
} | {
    error: "permissive_regex";
} | {
    error: "invalid_regex";
} | {
    error: "captcha_incorrect";
} | {
    error: "couldnt_create_audio_captcha";
} | {
    error: "couldnt_create_image_captcha";
} | {
    error: "invalid_url_scheme";
} | {
    error: "contradicting_filters";
} | {
    error: "too_many_items";
} | {
    error: "ban_expiration_in_past";
} | {
    error: "invalid_unix_time";
} | {
    error: "invalid_bot_action";
} | {
    error: "tag_not_in_community";
} | {
    error: "cant_block_local_instance";
} | {
    error: "unknown";
    message: string;
} | {
    error: "url_length_overflow";
} | {
    error: "oauth_authorization_invalid";
} | {
    error: "oauth_login_failed";
} | {
    error: "oauth_registration_closed";
} | {
    error: "not_found";
} | {
    error: "post_schedule_time_must_be_in_future";
} | {
    error: "too_many_scheduled_posts";
} | {
    error: "cannot_combine_federation_blocklist_and_allowlist";
} | {
    error: "untranslated_error";
    message: {
        error?: UntranslatedError;
    };
} | {
    error: "couldnt_parse_pagination_token";
} | {
    error: "plugin_error";
    message: string;
} | {
    error: "invalid_fetch_limit";
} | {
    error: "email_notifications_disabled";
} | {
    error: "multi_community_update_wrong_user";
} | {
    error: "cannot_combine_community_id_and_multi_community_id";
} | {
    error: "multi_community_entry_limit_reached";
} | {
    error: "too_many_requests";
};
