import type { CommentSortType } from "./CommentSortType";
import type { FederationMode } from "./FederationMode";
import type { LanguageId } from "./LanguageId";
import type { ListingType } from "./ListingType";
import type { MultiCommunityId } from "./MultiCommunityId";
import type { PostListingMode } from "./PostListingMode";
import type { PostSortType } from "./PostSortType";
import type { RegistrationMode } from "./RegistrationMode";
/**
 * Edits a site.
 */
export type EditSite = {
    name?: string;
    /**
     * A sidebar for the site, in markdown.
     */
    sidebar?: string;
    /**
     * A shorter, one line description of your site.
     */
    description?: string;
    /**
     * Limits community creation to admins only.
     */
    community_creation_admin_only?: boolean;
    /**
     * Whether to require email verification.
     */
    require_email_verification?: boolean;
    /**
     * Your application question form. This is in markdown, and can be many questions.
     */
    application_question?: string;
    /**
     * Whether your instance is public, or private.
     */
    private_instance?: boolean;
    /**
     * The default theme. Usually "browser"
     */
    default_theme?: string;
    /**
     * The default post listing type, usually "local"
     */
    default_post_listing_type?: ListingType;
    /**
     * Default value for listing mode, usually "list"
     */
    default_post_listing_mode?: PostListingMode;
    /**
     * The default post sort, usually "active"
     */
    default_post_sort_type?: PostSortType;
    /**
     * A default time range limit to apply to post sorts, in seconds. 0 means none.
     */
    default_post_time_range_seconds?: number;
    /**
     * A default fetch limit for number of items returned.
     */
    default_items_per_page?: number;
    /**
     * The default comment sort, usually "hot"
     */
    default_comment_sort_type?: CommentSortType;
    /**
     * An optional page of legal information
     */
    legal_information?: string;
    /**
     * Whether to email admins when receiving a new application.
     */
    application_email_admins?: boolean;
    /**
     * A list of allowed discussion languages.
     */
    discussion_languages?: Array<LanguageId>;
    /**
     * A regex string of items to filter.
     */
    slur_filter_regex?: string;
    /**
     * The number of messages allowed in a given time frame.
     */
    rate_limit_message_max_requests?: number;
    rate_limit_message_interval_seconds?: number;
    /**
     * The number of posts allowed in a given time frame.
     */
    rate_limit_post_max_requests?: number;
    rate_limit_post_interval_seconds?: number;
    /**
     * The number of registrations allowed in a given time frame.
     */
    rate_limit_register_max_requests?: number;
    rate_limit_register_interval_seconds?: number;
    /**
     * The number of image uploads allowed in a given time frame.
     */
    rate_limit_image_max_requests?: number;
    rate_limit_image_interval_seconds?: number;
    /**
     * The number of comments allowed in a given time frame.
     */
    rate_limit_comment_max_requests?: number;
    rate_limit_comment_interval_seconds?: number;
    /**
     * The number of searches allowed in a given time frame.
     */
    rate_limit_search_max_requests?: number;
    rate_limit_search_interval_seconds?: number;
    /**
     * The number of settings imports or exports allowed in a given time frame.
     */
    rate_limit_import_user_settings_max_requests?: number;
    rate_limit_import_user_settings_interval_seconds?: number;
    /**
     * Whether to enable federation.
     */
    federation_enabled?: boolean;
    /**
     * Whether to enable captchas for signups.
     */
    captcha_enabled?: boolean;
    /**
     * The captcha difficulty. Can be easy, medium, or hard
     */
    captcha_difficulty?: string;
    /**
     * A list of blocked URLs
     */
    blocked_urls?: Array<string>;
    registration_mode?: RegistrationMode;
    /**
     * Whether to email admins for new reports.
     */
    reports_email_admins?: boolean;
    /**
     * If present, nsfw content is visible by default. Should be displayed by frontends/clients
     * when the site is first opened by a user.
     */
    content_warning?: string;
    /**
     * Whether or not external auth methods can auto-register users.
     */
    oauth_registration?: boolean;
    /**
     * What kind of post upvotes your site allows.
     */
    post_upvotes?: FederationMode;
    /**
     * What kind of post downvotes your site allows.
     */
    post_downvotes?: FederationMode;
    /**
     * What kind of comment upvotes your site allows.
     */
    comment_upvotes?: FederationMode;
    /**
     * What kind of comment downvotes your site allows.
     */
    comment_downvotes?: FederationMode;
    /**
     * Block NSFW content being created
     */
    disallow_nsfw_content?: boolean;
    /**
     * Dont send email notifications to users for new replies, mentions etc
     */
    disable_email_notifications?: boolean;
    /**
     * A multicommunity with suggested communities which is shown on the homepage
     */
    suggested_communities?: MultiCommunityId;
};
