import type { CommentSortType } from "./CommentSortType";
import type { FederationMode } from "./FederationMode";
import type { LanguageId } from "./LanguageId";
import type { ListingType } from "./ListingType";
import type { MultiCommunityId } from "./MultiCommunityId";
import type { PostListingMode } from "./PostListingMode";
import type { PostSortType } from "./PostSortType";
import type { RegistrationMode } from "./RegistrationMode";
/**
 * Creates a site. Should be done after first running lemmy.
 */
export type CreateSite = {
    name: string;
    sidebar?: string;
    description?: string;
    community_creation_admin_only?: boolean;
    require_email_verification?: boolean;
    application_question?: string;
    private_instance?: boolean;
    default_theme?: string;
    default_post_listing_type?: ListingType;
    default_post_listing_mode?: PostListingMode;
    default_post_sort_type?: PostSortType;
    default_post_time_range_seconds?: number;
    default_comment_sort_type?: CommentSortType;
    legal_information?: string;
    application_email_admins?: boolean;
    discussion_languages?: Array<LanguageId>;
    slur_filter_regex?: string;
    rate_limit_message_max_requests?: number;
    rate_limit_message_interval_seconds?: number;
    rate_limit_post_max_requests?: number;
    rate_limit_post_interval_seconds?: number;
    rate_limit_register_max_requests?: number;
    rate_limit_register_interval_seconds?: number;
    rate_limit_image_max_requests?: number;
    rate_limit_image_interval_seconds?: number;
    rate_limit_comment_max_requests?: number;
    rate_limit_comment_interval_seconds?: number;
    rate_limit_search_max_requests?: number;
    rate_limit_search_interval_seconds?: number;
    rate_limit_import_user_settings_max_requests?: number;
    rate_limit_import_user_settings_interval_seconds?: number;
    federation_enabled?: boolean;
    captcha_enabled?: boolean;
    captcha_difficulty?: string;
    registration_mode?: RegistrationMode;
    oauth_registration?: boolean;
    content_warning?: string;
    post_upvotes?: FederationMode;
    post_downvotes?: FederationMode;
    comment_upvotes?: FederationMode;
    comment_downvotes?: FederationMode;
    disallow_nsfw_content?: boolean;
    disable_email_notifications?: boolean;
    suggested_communities?: MultiCommunityId;
};
