import type { CommunityId } from "./CommunityId";
import type { CommunityReportId } from "./CommunityReportId";
import type { PersonId } from "./PersonId";
/**
 * A comment report.
 */
export type CommunityReport = {
    id: CommunityReportId;
    creator_id: PersonId;
    community_id: CommunityId;
    original_community_name: string;
    original_community_title: string;
    original_community_description?: string;
    original_community_sidebar?: string;
    original_community_icon?: string;
    original_community_banner?: string;
    reason: string;
    resolved: boolean;
    resolver_id?: PersonId;
    published_at: string;
    updated_at?: string;
};
