import type { CommunityFollowerState } from "./CommunityFollowerState";
import type { CommunityNotificationsMode } from "./CommunityNotificationsMode";
export type CommunityActions = {
    /**
     * When the community was followed.
     */
    followed_at?: string;
    /**
     * When the community was blocked.
     */
    blocked_at?: string;
    /**
     * When this user became a moderator.
     */
    became_moderator_at?: string;
    /**
     * When this user received a ban.
     */
    received_ban_at?: string;
    /**
     * When their ban expires.
     */
    ban_expires_at?: string;
    /**
     * The state of the community follow.
     */
    follow_state?: CommunityFollowerState;
    notifications?: CommunityNotificationsMode;
};
