import type { Comment } from "./Comment";
import type { CommentActions } from "./CommentActions";
import type { Community } from "./Community";
import type { CommunityActions } from "./CommunityActions";
import type { Person } from "./Person";
import type { PersonActions } from "./PersonActions";
import type { Post } from "./Post";
import type { TagsView } from "./TagsView";
/**
 * A comment view.
 */
export type CommentView = {
    comment: Comment;
    creator: Person;
    post: Post;
    community: Community;
    community_actions?: CommunityActions;
    comment_actions?: CommentActions;
    person_actions?: PersonActions;
    creator_is_admin: boolean;
    post_tags: TagsView;
    can_mod: boolean;
    creator_banned: boolean;
    creator_ban_expires_at?: string;
    creator_is_moderator: boolean;
    creator_banned_from_community: boolean;
    creator_community_ban_expires_at?: string;
};
