import type { Comment } from "./Comment";
import type { CommentActions } from "./CommentActions";
import type { Person } from "./Person";
import type { PersonActions } from "./PersonActions";
/**
 * A slimmer comment view, without the post, or community.
 */
export type CommentSlimView = {
    comment: Comment;
    creator: Person;
    comment_actions?: CommentActions;
    person_actions?: PersonActions;
    creator_is_admin: boolean;
    can_mod: boolean;
    creator_banned: boolean;
    creator_is_moderator: boolean;
    creator_banned_from_community: boolean;
};
