"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  broadcastQueryClient: () => broadcastQueryClient
});
module.exports = __toCommonJS(index_exports);
var import_broadcast_channel = require("broadcast-channel");
function broadcastQueryClient({
  queryClient,
  broadcastChannel = "tanstack-query",
  options
}) {
  let transaction = false;
  const tx = (cb) => {
    transaction = true;
    cb();
    transaction = false;
  };
  const channel = new import_broadcast_channel.BroadcastChannel(broadcastChannel, {
    webWorkerSupport: false,
    ...options
  });
  const queryCache = queryClient.getQueryCache();
  const unsubscribe = queryClient.getQueryCache().subscribe((queryEvent) => {
    if (transaction) {
      return;
    }
    const {
      query: { queryHash, queryKey, state, observers }
    } = queryEvent;
    if (queryEvent.type === "updated" && queryEvent.action.type === "success") {
      channel.postMessage({
        type: "updated",
        queryHash,
        queryKey,
        state
      });
    }
    if (queryEvent.type === "removed" && observers.length > 0) {
      channel.postMessage({
        type: "removed",
        queryHash,
        queryKey
      });
    }
    if (queryEvent.type === "added") {
      channel.postMessage({
        type: "added",
        queryHash,
        queryKey
      });
    }
  });
  channel.onmessage = (action) => {
    if (!action?.type) {
      return;
    }
    tx(() => {
      const { type, queryHash, queryKey, state } = action;
      const query = queryCache.get(queryHash);
      if (type === "updated") {
        if (query) {
          query.setState(state);
          return;
        }
        queryCache.build(
          queryClient,
          {
            queryKey,
            queryHash
          },
          state
        );
      } else if (type === "removed") {
        if (query) {
          queryCache.remove(query);
        }
      } else if (type === "added") {
        if (query) {
          query.setState(state);
          return;
        }
        queryCache.build(
          queryClient,
          {
            queryKey,
            queryHash
          },
          state
        );
      }
    });
  };
  return () => {
    unsubscribe();
    channel.close();
  };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  broadcastQueryClient
});
//# sourceMappingURL=index.cjs.map