import type { FullBox } from '../FullBox.js';
import type { IsoView } from '../IsoView.js';
/**
 * Track run sample
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type TrackRunSample = {
    sampleDuration?: number;
    sampleSize?: number;
    sampleFlags?: number;
    sampleCompositionTimeOffset?: number;
};
/**
 * ISO/IEC 14496-12:2012 - 8.8.8 Track Run Box
 *
 * Note: the 'trun' box has a direct relation to the 'tfhd' box for defaults.
 * These defaults are not set explicitly here, but are left to resolve for the user.
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type TrackRunBox = FullBox & {
    sampleCount: number;
    dataOffset?: number;
    firstSampleFlags?: number;
    samples: TrackRunSample[];
};
/**
 * Parse a TrackRunBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed TrackRunBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function trun(view: IsoView): TrackRunBox;
//# sourceMappingURL=trun.d.ts.map