import type { FullBox } from '../FullBox.js';
import type { IsoView } from '../IsoView.js';
/**
 * Track fragment random access entry
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type TrackFragmentRandomAccessEntry = {
    time: number;
    moofOffset: number;
    trafNumber: number;
    trunNumber: number;
    sampleNumber: number;
};
/**
 * ISO/IEC 14496-12:2012 - 8.8.10 Track Fragment Random Access Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type TrackFragmentRandomAccessBox = FullBox & {
    trackId: number;
    reserved: number;
    numberOfEntry: number;
    lengthSizeOfTrafNum: number;
    lengthSizeOfTrunNum: number;
    lengthSizeOfSampleNum: number;
    entries: TrackFragmentRandomAccessEntry[];
};
/**
 * Parse a TrackFragmentRandomAccessBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed TrackFragmentRandomAccessBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function tfra(view: IsoView): TrackFragmentRandomAccessBox;
//# sourceMappingURL=tfra.d.ts.map