import { UINT } from '../fields/UINT.js';
/**
 * Parse a TrackEncryptionBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed TrackEncryptionBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function tenc(view) {
    return {
        ...view.readFullBox(),
        defaultIsEncrypted: view.readUint(3),
        defaultIvSize: view.readUint(1),
        defaultKid: view.readArray(UINT, 1, 16),
    };
}
;
//# sourceMappingURL=tenc.js.map