import type { FullBox } from '../FullBox.js';
import type { IsoView } from '../IsoView.js';
/**
 * ISO/IEC 23001-7:2011 - 8.2 Track Encryption Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type TrackEncryptionBox = FullBox & {
    defaultIsEncrypted: number;
    defaultIvSize: number;
    defaultKid: number[];
};
/**
 * Parse a TrackEncryptionBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed TrackEncryptionBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function tenc(view: IsoView): TrackEncryptionBox;
//# sourceMappingURL=tenc.d.ts.map