import type { FullBox } from '../FullBox.js';
import type { IsoView } from '../IsoView.js';
/**
 * Sync sample
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type SyncSample = {
    sampleNumber: number;
};
/**
 * ISO/IEC 14496-12:2015 - 8.6.2 Sync Sample Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type SyncSampleBox = FullBox & {
    entryCount: number;
    entries: SyncSample[];
};
/**
 * Parse a SyncSampleBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed SyncSampleBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function stss(view: IsoView): SyncSampleBox;
//# sourceMappingURL=stss.d.ts.map