/**
 * Parse a SoundMediaHeaderBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed SoundMediaHeaderBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function smhd(view) {
    return {
        ...view.readFullBox(),
        balance: view.readUint(2),
        reserved: view.readUint(2),
    };
}
;
//# sourceMappingURL=smhd.js.map