import type { FullBox } from '../FullBox.js';
import type { IsoView } from '../IsoView.js';
/**
 * Entity
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type Entity = {
    /** Entity ID */
    entityId: number;
};
/**
 * ISO/IEC 14496-12:202x - 8.18.4.1 Preselection group box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type PreselectionGroupBox = FullBox & {
    /** Group ID */
    groupId: number;
    /** Number of entities in group */
    numEntitiesInGroup: number;
    /** Entities */
    entities: Entity[];
    preselectionTag?: string;
    selectionPriority?: number;
    interleavingTag?: string;
};
/**
 * Parse a PreselectionGroupBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed PreselectionGroupBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function prsl(view: IsoView): PreselectionGroupBox;
//# sourceMappingURL=prsl.d.ts.map