import type { IsoView } from '../IsoView.js';
import type { SampleEntry } from './avc1.js';
/**
 * ISO/IEC 14496-12:2012 - 8.5.2.2 mp4a box (use AudioSampleEntry definition and naming)
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type AudioSampleEntry = SampleEntry & {
    reserved2: number[];
    channelcount: number;
    samplesize: number;
    preDefined: number;
    reserved3: number;
    samplerate: number;
    esds: Uint8Array;
};
/**
 * Parse an AudioSampleEntry from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed AudioSampleEntry
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function mp4a(view: IsoView): AudioSampleEntry;
//# sourceMappingURL=mp4a.d.ts.map