/**
 * Parse a MovieFragmentHeaderBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed MovieFragmentHeaderBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function mfhd(view) {
    return {
        ...view.readFullBox(),
        sequenceNumber: view.readUint(4),
    };
}
;
//# sourceMappingURL=mfhd.js.map