import type { FullBox } from '../FullBox.js';
import type { IsoView } from '../IsoView.js';
/**
 * ISO/IEC 23009-1:2014 - 5.10.3.3 Event Message Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type EventMessageBox = FullBox & {
    schemeIdUri: string;
    value: string;
    timescale: number;
    presentationTime: number;
    presentationTimeDelta: number;
    eventDuration: number;
    id: number;
    messageData: Uint8Array;
};
/**
 * Parse an EventMessageBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed EventMessageBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function emsg(view: IsoView): EventMessageBox;
//# sourceMappingURL=emsg.d.ts.map