import { filterBoxes } from './filterBoxes.js';
/**
 * Filter boxes by type from an IsoView
 *
 * @param type - The type of boxes to filter
 * @param raw - The raw ISO data
 * @param config - The configuration for the IsoView
 *
 * @returns The filtered boxes
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function filterBoxesByType(type, raw, config = {}) {
    return filterBoxes(raw, config, box => box.type === type);
}
//# sourceMappingURL=filterBoxesByType.js.map