import type { Box } from './Box.js';
import type { FullBox } from './FullBox.js';
import type { IsoViewConfig } from './IsoViewConfig.js';
import type { ISOFieldTypeMap } from './readers/ISOFieldTypeMap.js';
/**
 * Raw ISO BMFF data box.
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type RawBox = {
    type: string;
    size: number;
    largesize?: number;
    usertype?: number[];
    data: IsoView;
};
/**
 * ISO BMFF data view. Similar to DataView, but with additional methods for reading ISO BMFF data.
 * It implements the iterator protocol, so it can be used in a for...of loop.
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare class IsoView {
    private dataView;
    private offset;
    private config;
    private truncated;
    constructor(raw: ArrayBuffer | DataView | Uint8Array, config?: IsoViewConfig);
    get cursor(): number;
    get done(): boolean;
    get bytesRemaining(): number;
    slice: (size: number) => IsoView;
    private read;
    readUint: (size: number) => number;
    readInt: (size: number) => number;
    readString: (size: number) => string;
    readTemplate: (size: number) => number;
    readData: (size: number) => Uint8Array;
    readUtf8: (size?: number) => string;
    readFullBox: () => FullBox;
    readArray: <T extends keyof ISOFieldTypeMap>(type: T, size: number, length: number) => ISOFieldTypeMap[T][];
    readBox: () => RawBox;
    readBoxes: (length: number) => Box[];
    readEntries: <T>(length: number, map: () => T) => T[];
    [Symbol.iterator](): Generator<Box>;
}
//# sourceMappingURL=IsoView.d.ts.map