import type { KeySystem } from '../common/KeySystem.js';
import type { KeySystemAccess } from '../common/KeySystemAccess.js';
import type { KeySystemConfiguration } from '../common/KeySystemConfiguration.js';
/**
 * Fallback method to get key system access using legacy MediaKeys.isTypeSupported().
 *
 * @param ksConfigurations - An array of key system configurations.
 * @returns A KeySystemAccess object if successful, or null if no system is supported.
 *
 * @group DRM
 * @beta
 */
export declare function getLegacyKeySystemAccess(ksConfigurations: {
    ks: KeySystem;
    configs: KeySystemConfiguration[];
}[]): KeySystemAccess | null;
//# sourceMappingURL=getLegacyKeySystemAccess.d.ts.map