import type { KeySystem } from '../common/KeySystem.js';
import type { KeySystemConfiguration } from '../common/KeySystemConfiguration.js';
/**
 * Attempts to get key system access using requestMediaKeySystemAccess from EME.
 *
 * @param ksConfigurations - An array of key system configurations.
 * @returns MediaKeySystemAccess object if successful, or null if no system is supported.
 *
 * @group DRM
 * @beta
 */
export declare function getKeySystemAccess(ksConfigurations: {
    ks: KeySystem;
    configs: KeySystemConfiguration[];
}[]): Promise<MediaKeySystemAccess | null>;
//# sourceMappingURL=getKeySystemAccess.d.ts.map