import { base64decode } from '../../utils/base64decode.js';
/**
 * Decodes a FairPlay DRM license response.
 *
 * @param response - The license response, either a base64 string or ArrayBuffer
 * @returns A Uint8Array containing the decoded license
 *
 * @group DRM
 * @beta
 *
 * @example
 * {@includeCode ../../../test/drm/fairplay/decodeFairPlayLicense.test.ts#example}
 */
export function decodeFairPlayLicense(response) {
    return typeof response === 'string'
        ? base64decode(response)
        : new Uint8Array(response);
}
//# sourceMappingURL=decodeFairPlayLicense.js.map