import { FRAME_RATE_NUMERATOR_30, ZERO } from '../../../utils/constants.js';
import { parseHlsManifest } from '../../../utils/hls/parseHlsManifest.js';
import { formatSegments } from './utils/formatSegments.js';
import { getByterange } from './utils/getByterange.js';
import { getCodec } from './utils/getCodec.js';
import { getDuration } from './utils/getDuration.js';
export function videoPlaylistsToSwitchingSets(playlists, manifestPlaylists) {
    const switchingSetVideos = [];
    const videoTracks = [];
    let videoTrackId = 0;
    playlists.map((playlist) => {
        var _a, _b, _c, _d;
        const parsedHlsManifest = parseHlsManifest((_a = manifestPlaylists.shift()) === null || _a === void 0 ? void 0 : _a.manifest);
        const segments = formatSegments(parsedHlsManifest === null || parsedHlsManifest === void 0 ? void 0 : parsedHlsManifest.segments);
        const { LANGUAGE, CODECS, BANDWIDTH } = playlist.attributes;
        const map = (_c = (_b = parsedHlsManifest === null || parsedHlsManifest === void 0 ? void 0 : parsedHlsManifest.segments) === null || _b === void 0 ? void 0 : _b.at(0)) === null || _c === void 0 ? void 0 : _c.map;
        const byteRange = getByterange(map === null || map === void 0 ? void 0 : map.byterange);
        videoTracks.push({
            id: `video-${videoTrackId++}`,
            type: 'video',
            fileName: playlist.uri,
            codec: getCodec('video', CODECS),
            duration: getDuration(parsedHlsManifest, segments),
            language: LANGUAGE !== null && LANGUAGE !== void 0 ? LANGUAGE : 'und',
            bandwidth: BANDWIDTH,
            segments: segments,
            width: playlist.attributes.RESOLUTION.width,
            height: playlist.attributes.RESOLUTION.height,
            frameRate: {
                frameRateNumerator: (_d = playlist.attributes['FRAME-RATE']) !== null && _d !== void 0 ? _d : FRAME_RATE_NUMERATOR_30,
                frameRateDenominator: ZERO,
            },
            par: '',
            sar: '',
            scanType: '',
            ...(byteRange && { byteRange }),
            ...((map === null || map === void 0 ? void 0 : map.uri) && { urlInitialization: map === null || map === void 0 ? void 0 : map.uri }),
        });
    });
    switchingSetVideos.push({
        id: `video`,
        tracks: videoTracks,
    });
    return switchingSetVideos;
}
//# sourceMappingURL=videoPlaylistsToSwitchingSets.js.map