import { parseHlsManifest } from '../../../utils/hls/parseHlsManifest.js';
import { formatSegments } from './utils/formatSegments.js';
import { getCodec } from './utils/getCodec.js';
import { getDuration } from './utils/getDuration.js';
export function subtitleGroupsToSwitchingSets(mediaGroupsSubtitles, manifestPlaylists) {
    var _a;
    const subtitleSwitchingSets = [];
    const textTracks = [];
    // Add selection set of type subtitles
    for (const subtitleEncodings in mediaGroupsSubtitles) {
        const encodings = mediaGroupsSubtitles[subtitleEncodings];
        for (const subtitle in encodings) {
            const attributes = encodings[subtitle];
            const { language, uri } = attributes;
            const subtitleParsed = parseHlsManifest((_a = manifestPlaylists.shift()) === null || _a === void 0 ? void 0 : _a.manifest);
            const segments = formatSegments(subtitleParsed === null || subtitleParsed === void 0 ? void 0 : subtitleParsed.segments);
            textTracks.push({
                id: subtitle,
                type: 'text',
                fileName: uri,
                codec: getCodec('text'),
                duration: getDuration(subtitleParsed, segments),
                language: language,
                bandwidth: 0,
                segments: segments,
            });
        }
    }
    subtitleSwitchingSets.push({
        id: 'text',
        tracks: textTracks,
    });
    return subtitleSwitchingSets;
}
//# sourceMappingURL=subtitleGroupsToSwitchingSets.js.map