"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readUTF8TerminatedString = readUTF8TerminatedString;
const dataViewToString_js_1 = require("../../../utils/dataViewToString.js");
function readUTF8TerminatedString(dataView, offset) {
    const length = dataView.byteLength - (offset - dataView.byteOffset);
    let data = '';
    if (length > 0) {
        const view = new DataView(dataView.buffer, offset, length);
        let l = 0;
        for (; l < length; l++) {
            if (view.getUint8(l) === 0) {
                break;
            }
        }
        // remap the Dataview with the actual length
        data = (0, dataViewToString_js_1.dataViewToString)(new DataView(dataView.buffer, offset, l));
    }
    return data;
}
;
//# sourceMappingURL=readUTF8TerminatedString.js.map