import type { FullBox } from '../FullBox.js';
import type { IsoView } from '../IsoView.js';
/**
 * ISO/IEC 14496-12:2012 - 8.7.2 Data Reference Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type UrnBox = FullBox & {
    name: string;
    location: string;
};
/**
 * Parse a UrnBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed UrnBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function urn(view: IsoView): UrnBox;
//# sourceMappingURL=urn.d.ts.map