"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.url = url;
/**
 * Parse a UrlBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed UrlBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
function url(view) {
    return {
        ...view.readFullBox(),
        location: view.readString(-1),
    };
}
;
//# sourceMappingURL=url.js.map