"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.stsd = stsd;
/**
 * Parse a SampleDescriptionBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed SampleDescriptionBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
function stsd(view) {
    const { version, flags } = view.readFullBox();
    const entryCount = view.readUint(4);
    return {
        version,
        flags,
        entryCount,
        entries: view.readBoxes(entryCount),
    };
}
;
//# sourceMappingURL=stsd.js.map