"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sdtp = sdtp;
const UINT_js_1 = require("../fields/UINT.js");
//
/**
 * Parse a SampleDependencyTypeBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed SampleDependencyTypeBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
function sdtp(view) {
    return {
        ...view.readFullBox(),
        sampleDependencyTable: view.readArray(UINT_js_1.UINT, 1, view.bytesRemaining),
    };
}
;
//# sourceMappingURL=sdtp.js.map