"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mehd = mehd;
/**
 * Parse a MovieExtendsHeaderBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed MovieExtendsHeaderBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
function mehd(view) {
    const { version, flags } = view.readFullBox();
    return {
        version,
        flags,
        fragmentDuration: view.readUint((version === 1) ? 8 : 4),
    };
}
;
//# sourceMappingURL=mehd.js.map