import type { FullBox } from '../FullBox.js';
import type { IsoView } from '../IsoView.js';
/**
 * ISO/IEC 14496-12:2012 - 8.4.2 Media Header Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type MediaHeaderBox = FullBox & {
    /** A 32-bit integer that specifies the creation time of the media in this track. */
    creationTime: number;
    /** A 32-bit integer that specifies the most recent time the media in this track was modified. */
    modificationTime: number;
    /** A time value that indicates the time-scale for this media; this is the number of time units that pass in one second. */
    timescale: number;
    /** A time value that indicates the duration of this media. */
    duration: number;
    /** A 16-bit integer that specifies the language code for this media. */
    language: string;
    /** A 16-bit value that is reserved for use in other specifications. */
    preDefined: number;
};
/**
 * Parse a MediaHeaderBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed MediaHeaderBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function mdhd(view: IsoView): MediaHeaderBox;
//# sourceMappingURL=mdhd.d.ts.map