"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hdlr = hdlr;
const UINT_js_1 = require("../fields/UINT.js");
/**
 * Parse a HandlerReferenceBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed HandlerReferenceBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
function hdlr(view) {
    return {
        ...view.readFullBox(),
        preDefined: view.readUint(4),
        handlerType: view.readString(4),
        reserved: view.readArray(UINT_js_1.UINT, 4, 3),
        name: view.readString(-1),
    };
}
;
//# sourceMappingURL=hdlr.js.map