"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.elst = elst;
/**
 * Parse a Box from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
function elst(view) {
    const { version, flags } = view.readFullBox();
    const v1 = version === 1;
    const size = v1 ? 8 : 4;
    const entryCount = view.readUint(4);
    const entries = view.readEntries(entryCount, () => ({
        segmentDuration: view.readUint(size),
        mediaTime: view.readInt(size),
        mediaRateInteger: view.readInt(2),
        mediaRateFraction: view.readInt(2),
    }));
    return {
        version,
        flags,
        entryCount,
        entries,
    };
}
;
//# sourceMappingURL=elst.js.map