"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.dref = dref;
/**
 * Parse a DataReferenceBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed DataReferenceBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
function dref(view) {
    const { version, flags } = view.readFullBox();
    const entryCount = view.readUint(4);
    const entries = view.readBoxes(entryCount);
    return {
        version,
        flags,
        entryCount,
        entries,
    };
}
;
//# sourceMappingURL=dref.js.map