"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ardi = ardi;
/**
 * Parse a AudioRenderingIndicationBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed AudioRenderingIndicationBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
function ardi(view) {
    return {
        ...view.readFullBox(),
        audioRenderingIndication: view.readUint(1),
    };
}
;
//# sourceMappingURL=ardi.js.map