"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findBox = findBox;
const createIsoView_js_1 = require("./createIsoView.js");
function find(iterator, recursive, fn) {
    for (const box of iterator) {
        if (fn(box)) {
            return box;
        }
        if (recursive && Array.isArray(box.boxes)) {
            const result = find(box.boxes, recursive, fn);
            if (result) {
                return result;
            }
        }
    }
    return null;
}
/**
 * Find a box from an IsoView that matches a filter function
 *
 * @param raw - The raw ISO data
 * @param config - The configuration for the IsoView
 * @param fn - The filter function
 *
 * @returns The first box that matches the filter function
 *
 * @group ISOBMFF
 *
 * @beta
 */
function findBox(raw, config, fn) {
    return find((0, createIsoView_js_1.createIsoView)(raw, { ...config, recursive: false }), !!config.recursive, fn);
}
//# sourceMappingURL=findBox.js.map