"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createIsoView = createIsoView;
const IsoView_js_1 = require("./IsoView.js");
/**
 * Create an IsoView from a raw ISO data.
 *
 * @param raw - The raw ISO data
 * @param config - The configuration for the IsoView
 *
 * @returns The created IsoView
 *
 * @group ISOBMFF
 *
 * @beta
 */
function createIsoView(raw, config) {
    return raw instanceof IsoView_js_1.IsoView ? raw : new IsoView_js_1.IsoView(raw, config);
}
//# sourceMappingURL=createIsoView.js.map