"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decodeId3ImageFrame = decodeId3ImageFrame;
const utf8ArrayToStr_js_1 = require("../../utils/utf8ArrayToStr.js");
const toArrayBuffer_js_1 = require("./toArrayBuffer.js");
const utf8_js_1 = require("./utf8.js");
function decodeId3ImageFrame(frame) {
    const metadataFrame = {
        key: frame.type,
        description: '',
        data: '',
        mimeType: null,
        pictureType: null,
    };
    const utf8Encoding = 0x03;
    if (frame.size < 2) {
        return undefined;
    }
    if (frame.data[0] !== utf8Encoding) {
        console.log('Ignore frame with unrecognized character ' + 'encoding');
        return undefined;
    }
    const mimeTypeEndIndex = frame.data.subarray(1).indexOf(0);
    if (mimeTypeEndIndex === -1) {
        return undefined;
    }
    const mimeType = (0, utf8ArrayToStr_js_1.utf8ArrayToStr)((0, utf8_js_1.toUint8)(frame.data, 1, mimeTypeEndIndex));
    const pictureType = frame.data[2 + mimeTypeEndIndex];
    const descriptionEndIndex = frame.data
        .subarray(3 + mimeTypeEndIndex)
        .indexOf(0);
    if (descriptionEndIndex === -1) {
        return undefined;
    }
    const description = (0, utf8ArrayToStr_js_1.utf8ArrayToStr)((0, utf8_js_1.toUint8)(frame.data, 3 + mimeTypeEndIndex, descriptionEndIndex));
    let data;
    if (mimeType === '-->') {
        data = (0, utf8ArrayToStr_js_1.utf8ArrayToStr)((0, utf8_js_1.toUint8)(frame.data, 4 + mimeTypeEndIndex + descriptionEndIndex));
    }
    else {
        data = (0, toArrayBuffer_js_1.toArrayBuffer)(frame.data.subarray(4 + mimeTypeEndIndex + descriptionEndIndex));
    }
    metadataFrame.mimeType = mimeType;
    metadataFrame.pictureType = pictureType;
    metadataFrame.description = description;
    metadataFrame.data = data;
    return metadataFrame;
}
//# sourceMappingURL=decodeId3ImageFrame.js.map