"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decodeId3Frame = decodeId3Frame;
const decodeId3ImageFrame_js_1 = require("./decodeId3ImageFrame.js");
const decodeId3PrivFrame_js_1 = require("./decodeId3PrivFrame.js");
const decodeId3TextFrame_js_1 = require("./decodeId3TextFrame.js");
const decodeId3UrlFrame_js_1 = require("./decodeId3UrlFrame.js");
/**
 * Decode an ID3 frame.
 *
 * @param frame - the ID3 frame
 *
 * @returns The decoded ID3 frame
 *
 * @internal
 *
 * @group ID3
 */
function decodeId3Frame(frame) {
    if (frame.type === 'PRIV') {
        return (0, decodeId3PrivFrame_js_1.decodeId3PrivFrame)(frame);
    }
    else if (frame.type[0] === 'W') {
        return (0, decodeId3UrlFrame_js_1.decodeId3UrlFrame)(frame);
    }
    else if (frame.type === 'APIC') {
        return (0, decodeId3ImageFrame_js_1.decodeId3ImageFrame)(frame);
    }
    return (0, decodeId3TextFrame_js_1.decodeId3TextFrame)(frame);
}
//# sourceMappingURL=decodeId3Frame.js.map