"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CapacitorJSONConfig = exports.CAPACITOR_CONFIG_JSON_FILE = void 0;
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const lodash = tslib_1.__importStar(require("lodash"));
exports.CAPACITOR_CONFIG_JSON_FILE = 'capacitor.config.json';
class CapacitorJSONConfig extends cli_framework_1.BaseConfig {
    constructor(p) {
        super(p, { spaces: '\t' });
    }
    provideDefaults(config) {
        return config;
    }
    setServerUrl(url) {
        const serverConfig = this.get('server') || {};
        if (typeof serverConfig.url === 'string') {
            serverConfig.originalUrl = serverConfig.url;
        }
        serverConfig.url = url;
        this.set('server', serverConfig);
    }
    resetServerUrl() {
        const serverConfig = this.get('server') || {};
        delete serverConfig.url;
        if (serverConfig.originalUrl) {
            serverConfig.url = serverConfig.originalUrl;
            delete serverConfig.originalUrl;
        }
        if (lodash.isEmpty(serverConfig)) {
            this.unset('server');
        }
        else {
            this.set('server', serverConfig);
        }
    }
}
exports.CapacitorJSONConfig = CapacitorJSONConfig;
