/*
<media-theme-x-mas>
  <video
    slot="media"
    src="https://stream.mux.com/fXNzVtmtWuyz00xnSrJg4OJH6PyNo6D02UzmgeKGkP5YQ/high.mp4"
  ></video>
</media-theme-x-mas>
*/

import 'media-chrome';
import { globalThis } from 'media-chrome/dist/utils/server-safe-globals.js';
import { MediaThemeElement } from 'media-chrome/dist/media-theme-element.js';
import 'media-chrome/dist/menu/index.js';

const template = globalThis.document?.createElement?.('template');
if (template) {
  template.innerHTML = /*html*/`
    <style>
      :host {
        --media-primary-color: black;
        --media-tertiary-color: var(--media-accent-color, #7596cc);
        --media-text-color: white;
        --media-control-background: transparent;
        --media-control-hover-background: transparent;

        --media-range-track-height: 6px;
        --media-range-bar-color: repeating-linear-gradient(45deg, #e72d33, #e72d33 6px, #ffffff 6px, #ffffff 12px);
        --media-range-track-background: rgba(255, 255, 255, 0.4);
        --media-range-track-border-radius: 9999px;

        --media-range-thumb-background: var(--media-tertiary-color);
        --media-range-thumb-width: 14px;
        --media-range-thumb-height: 14px;
        --media-tooltip-display: none;
      }

      :host([mediastreamtype='live']) media-time-range,
      :host([mediastreamtype='live']) media-time-display {
        opacity: 0;
      }

      media-control-bar {
        position: relative;
        margin: 0.5rem;
        padding: 0.5rem;
        align-items: center;
        display: flex;
        gap: 0.5rem;
      }

      .icon-button {
        position: relative;
        flex: none;
        display: flex;
        align-items: center;
        justify-items: center;
        height: 2rem;
        width: 2rem;
        transition: ease-in-out 0.2s;
        padding: 0;
      }

      .icon-button * {
        transition: ease-in-out 0.2s all;
      }

      .icon-button:hover svg {
        transition: ease-in-out 0.3s;
        transform: scale(1.05);
      }

      .icon-button:hover svg .ornament {
        transform: scale(1.2) translate(-4px, 0px);
      }

      .icon-button svg {
        position: absolute;
        overflow: hidden;
        width: 100%;
        height: 1.25rem;
        margin: 0 !important;
        padding: 0 !important;
      }

      div[slot='centered-chrome'] {
        position: relative;
        width: 100%;
        height: 100%;
        display: flex;
        align-items: start;
        justify-content: center;
        overflow: hidden;
      }

      div[slot='centered-chrome'] > media-play-button {
        flex: none;
        display: flex;
        margin-bottom: 10px;
        align-items: center;
        justify-items: center;
        height: 70%;
        width: 20%;
        margin-top: -1rem;
        border-radius: 9999px;
      }

      div[slot='centered-chrome'] > media-play-button > svg {
        height: 100%;
        filter: drop-shadow(0px 0px 36px #00000069);
      }

      media-time-range {
        --media-secondary-color: transparent;
        height: 100%;
      }

      media-time-range {
        --media-range-track-height: 0.5rem;
        --media-preview-time-background: var(--_secondary-color);
        --media-preview-time-background: transparent;
        --media-preview-thumbnail-border-radius: 0;
      }

      media-time-range::part(thumb) {
        background: no-repeat
          url('data:image/svg+xml,<svg  viewBox="0 0 27 45" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M11.095 40.061C11.1593 41.2534 11.2235 42.4458 11.2877 43.6369C11.2931 43.7333 11.3814 43.8296 11.3493 43.9113C11.079 44.6072 11.5594 44.5911 11.6236 44.6072C12.4333 44.8066 16.4134 44.7156 16.4991 44.1682C16.3358 42.1126 16.1725 40.0556 16.0106 38C15.1019 38.2998 11.724 39.076 11 39.8723" fill="%23123342"/><path d="M4.87324 29.1051C3.9565 31.5515 2.37063 33.7423 0.33374 35.3777C1.04839 36.5808 2.07085 37.6488 3.37033 38.1667C4.66982 38.6846 6.26774 38.5695 7.33302 37.6635C8.12262 38.7662 9.15578 39.7619 10.4499 40.1674C11.744 40.5729 13.3272 40.2544 14.1235 39.157C14.2105 39.0366 14.2988 38.9001 14.4394 38.8519C14.6321 38.7863 14.8328 38.9134 14.9974 39.0339C15.8178 39.6348 16.7359 40.2745 17.7476 40.1755C19.1047 40.043 19.9505 38.6846 20.5848 37.4775C22.4384 38.6886 25.1377 38.3768 26.6674 36.7762C24.1514 33.8989 22.1386 30.5812 20.7481 27.02C18.6992 27.8203 16.412 27.4643 14.2132 27.4001C10.9852 27.3051 7.73853 27.8752 4.73673 29.0636" fill="%23099667"/><path d="M4.55073 29.0156C3.84947 30.8758 2.75073 32.5848 1.35622 34.0021C0.958749 34.4063 0.538525 34.785 0.0968875 35.141C-0.0155293 35.232 -0.0262356 35.4287 0.044694 35.5465C0.646927 36.5529 1.44455 37.4683 2.45496 38.0826C3.46538 38.6968 4.66181 38.9471 5.82747 38.7276C6.47119 38.6058 7.06807 38.3208 7.56993 37.9005L7.04398 37.8323C7.72249 38.7745 8.55223 39.651 9.60012 40.1783C10.5757 40.6681 11.7106 40.8247 12.7638 40.4901C13.263 40.3309 13.7341 40.0659 14.1048 39.6925C14.1958 39.6015 14.2775 39.5025 14.3564 39.3994C14.4046 39.3365 14.5023 39.1719 14.5545 39.1639C14.6147 39.1532 14.7847 39.2897 14.8516 39.3392C14.9827 39.4342 15.1139 39.5306 15.2464 39.6229C15.7549 39.9762 16.309 40.3055 16.9179 40.446C17.5268 40.5865 18.0769 40.5209 18.6162 40.276C19.6909 39.7862 20.348 38.6473 20.8739 37.6463L20.4162 37.7667C21.9686 38.7678 24.035 38.7852 25.6597 37.942C26.12 37.7025 26.5443 37.3853 26.9056 37.0119C27.0368 36.8754 27.0261 36.6773 26.9056 36.5382C24.9745 34.326 23.3457 31.8541 22.0677 29.2097C21.7063 28.4629 21.3744 27.7027 21.072 26.9305C21.0118 26.7753 20.8431 26.6267 20.6598 26.6963C18.6978 27.4511 16.5633 27.1567 14.517 27.0751C12.3664 26.9894 10.2064 27.1888 8.10792 27.6679C6.92888 27.9369 5.7726 28.2969 4.64843 28.7399C4.4798 28.8055 4.36337 28.9634 4.41423 29.1521C4.45839 29.3127 4.65646 29.4519 4.82642 29.3863C6.81379 28.6034 8.90688 28.0788 11.0308 27.8553C12.0974 27.7429 13.172 27.7027 14.244 27.7349C15.316 27.767 16.3371 27.862 17.385 27.8673C18.5533 27.874 19.739 27.7643 20.8378 27.3414L20.4256 27.1072C21.5243 29.9149 22.9898 32.5728 24.7965 34.9871C25.3157 35.6816 25.8604 36.3561 26.4305 37.0106V36.5368C25.3077 37.6985 23.5505 38.1361 21.9967 37.7333C21.5524 37.6182 21.1376 37.4348 20.7521 37.1859C20.6049 37.0909 20.3761 37.1511 20.2944 37.3063C19.8635 38.1267 19.3657 39.0448 18.552 39.548C18.1558 39.7929 17.6915 39.904 17.2284 39.8263C16.6583 39.73 16.1497 39.4289 15.6773 39.109C15.2049 38.7892 14.612 38.1936 14.0566 38.7049C13.8773 38.8708 13.7582 39.097 13.5789 39.2669C13.4156 39.4222 13.2323 39.548 13.0342 39.655C12.2098 40.0953 11.2007 40.094 10.3348 39.7768C9.20532 39.362 8.30733 38.4533 7.6181 37.495C7.48428 37.3104 7.26881 37.2796 7.09216 37.4268C6.34271 38.0544 5.28278 38.2512 4.33393 38.0906C3.31147 37.9166 2.41481 37.3599 1.69615 36.6265C1.2786 36.1996 0.923954 35.7205 0.617484 35.2092L0.565291 35.6147C2.17927 34.3139 3.51891 32.6691 4.4691 30.8263C4.74211 30.2977 4.98166 29.7517 5.19044 29.1949C5.25468 29.0263 5.11951 28.8282 4.95624 28.7827C4.76887 28.7305 4.60828 28.847 4.54404 29.0169L4.55073 29.0156Z" fill="%23099667"/><path d="M8.20285 18.6639C6.47243 21.8571 4.74202 25.0503 3.01294 28.2448C4.56135 29.7664 7.34366 29.7664 8.89207 28.2448C9.05802 28.0815 9.26679 27.8875 9.49029 27.957C9.67765 28.0159 9.75795 28.2314 9.83289 28.4134C10.2611 29.464 11.3813 30.1907 12.5148 30.1545C13.6484 30.1184 14.719 29.3221 15.0803 28.2461C15.1432 28.0601 15.2329 27.8286 15.4283 27.8219C15.5287 27.8179 15.6183 27.8821 15.6973 27.9437C16.2621 28.3907 16.7465 28.942 17.3568 29.3261C17.9657 29.7115 18.766 29.9096 19.4057 29.5764C20.2636 29.1294 20.4429 27.9704 20.3077 27.0122C20.9595 27.5542 21.6527 28.1163 22.4891 28.2595C23.3256 28.4027 24.3266 27.945 24.4658 27.1086C21.5925 24.7157 19.3736 21.548 18.1049 18.0309C14.885 17.7432 11.6302 17.8556 8.43705 18.3628" fill="%2319BC8A"/><path d="M7.9141 18.4952C6.56644 20.9831 5.21744 23.471 3.86978 25.9602C3.48702 26.6655 3.10561 27.3708 2.72286 28.0761C2.65327 28.2059 2.66665 28.3759 2.77505 28.4816C3.86041 29.5348 5.45298 29.9122 6.91975 29.6245C7.64243 29.4826 8.32362 29.1628 8.89106 28.6944C9.02489 28.5833 9.13998 28.4454 9.27916 28.3411C9.40764 28.2447 9.40362 28.2768 9.46786 28.4106C9.54682 28.5766 9.60838 28.7492 9.70206 28.9085C9.80913 29.0932 9.93894 29.2658 10.0821 29.4251C10.6175 30.0233 11.3776 30.398 12.1739 30.477C12.9702 30.5559 13.7598 30.2722 14.3794 29.7824C14.6765 29.5482 14.9321 29.2578 15.1262 28.9339C15.2319 28.7599 15.3162 28.5712 15.3845 28.3799C15.4045 28.3223 15.4206 28.2648 15.4474 28.2099C15.4514 28.2032 15.4862 28.1323 15.4889 28.139C15.541 28.2193 15.2961 28.0587 15.442 28.1724C16.1486 28.7211 16.7375 29.4505 17.5686 29.8212C18.4719 30.2254 19.5479 30.1718 20.1796 29.3341C20.6908 28.6556 20.735 27.7335 20.6252 26.9238L20.0658 27.249C20.8434 27.8954 21.74 28.6275 22.808 28.6194C23.6658 28.6141 24.616 28.1015 24.7833 27.1968C24.8034 27.0857 24.7927 26.9506 24.6977 26.8716C22.4855 25.0248 20.6694 22.7323 19.3766 20.1574C19.0153 19.4374 18.6967 18.6986 18.4237 17.9412C18.3689 17.7899 18.2591 17.7096 18.1012 17.6949C15.5772 17.4714 13.0331 17.4902 10.5117 17.7538C9.78638 17.8301 9.0637 17.9251 8.3437 18.0389C8.1657 18.067 8.06533 18.2905 8.10949 18.4511C8.16169 18.6411 8.34236 18.7134 8.52169 18.6853C10.9842 18.2958 13.4841 18.1473 15.976 18.2343C16.6853 18.2583 17.3946 18.3038 18.1012 18.3654L17.7787 18.1192C18.7918 20.9162 20.3763 23.4924 22.4226 25.6524C22.99 26.2506 23.5922 26.8154 24.2252 27.344L24.1396 27.0188C24.0218 27.6558 23.338 27.9717 22.7223 27.9476C21.8913 27.9155 21.1552 27.2851 20.5396 26.7739C20.2679 26.5477 19.936 26.7672 19.9802 27.0991C20.0618 27.7027 20.019 28.4374 19.6389 28.942C19.1866 29.5442 18.3675 29.4826 17.7559 29.1695C17.3866 28.9808 17.0694 28.7131 16.7629 28.4374C16.6037 28.2942 16.4457 28.147 16.2851 28.0051C16.1152 27.8539 15.9345 27.6746 15.7338 27.5648C15.533 27.4551 15.2988 27.4551 15.1101 27.5822C14.9388 27.6973 14.8505 27.8847 14.7809 28.0707C14.6604 28.3919 14.5172 28.6863 14.2857 28.946C13.8361 29.4505 13.191 29.7931 12.5085 29.8145C11.8259 29.8359 11.1367 29.5428 10.6509 29.053C10.3926 28.7921 10.224 28.4896 10.0808 28.1537C9.90549 27.7455 9.53076 27.4725 9.08377 27.6759C8.75455 27.8258 8.5257 28.1497 8.22994 28.3544C7.97031 28.5351 7.68793 28.685 7.39083 28.7934C5.999 29.2993 4.3248 29.0517 3.24479 28.0038L3.29699 28.4093C4.64465 25.9214 5.99365 23.4335 7.34131 20.9443C7.72406 20.239 8.10548 19.5337 8.48823 18.8285C8.69299 18.4497 8.11619 18.1111 7.91009 18.4912L7.9141 18.4952Z" fill="%2319BC8A"/><path d="M2.78417 28.5285C4.65243 30.5547 7.7827 30.2978 9.28427 27.9959L9.42345 28.3893C9.8236 29.5443 11.0455 30.3767 12.262 30.3245C13.4678 30.2804 14.6093 29.3462 14.9064 28.1792L15.0496 27.6131L15.3882 28.0869C16.0614 29.0224 17.0598 29.8467 18.2348 29.9378C19.3242 30.0234 20.6009 29.2097 20.6437 28.0481L20.6558 27.6426L20.9422 27.9169C22.1734 29.0719 24.4672 28.6289 25.2367 27.1313C24.5556 28.8283 22.077 29.377 20.7026 28.1819L21.001 28.0508C21.0051 29.4667 19.549 30.4972 18.204 30.4236C16.851 30.3526 15.7108 29.4546 14.9479 28.4041L15.4297 28.3117C15.2544 29.021 14.8288 29.65 14.2681 30.097C12.44 31.6013 9.73795 30.7367 9.00189 28.5272L9.38598 28.5941C8.97646 29.0986 8.45319 29.5001 7.87237 29.7745C6.14463 30.623 3.90968 30.0809 2.78149 28.5272L2.78417 28.5285Z" fill="%23123342"/><path d="M7.26876 17.2359C9.5733 13.2183 11.7454 9.1245 13.7782 4.9624C14.6709 9.42695 16.9112 13.4887 19.122 17.4688C17.8493 18.6184 15.6211 18.4564 14.529 17.1329C14.1422 17.8448 13.5935 18.5167 12.8387 18.8084C12.0826 19.1001 11.0976 18.8967 10.6935 18.1941C10.0042 18.7843 8.97374 18.6826 8.09181 18.4725C7.80675 18.4042 7.50831 18.3213 7.30087 18.1152C7.09344 17.9091 7.01716 17.5397 7.21656 17.3242" fill="%232EBF8F"/><path d="M7.55658 17.4047C9.35525 14.269 11.0723 11.0879 12.7063 7.86397C13.1667 6.95661 13.6191 6.04523 14.066 5.13117L13.4544 5.05087C14.1611 8.56524 15.6961 11.8414 17.377 14.9824C17.8534 15.8723 18.3419 16.7543 18.8317 17.6362L18.8839 17.2307C17.7196 18.2652 15.755 18.0752 14.7646 16.8948C14.6268 16.7302 14.3364 16.7864 14.2387 16.963C13.88 17.6161 13.3675 18.3 12.622 18.5275C12.0452 18.7042 11.3092 18.5743 10.9799 18.0243C10.8608 17.8262 10.6186 17.8195 10.454 17.9561C9.97889 18.3508 9.28298 18.3455 8.70617 18.2545C8.39435 18.205 8.05309 18.1528 7.76268 18.0243C7.61948 17.9614 7.31435 17.7219 7.45085 17.5586C7.56728 17.4207 7.58602 17.2213 7.45085 17.0848C7.33175 16.9657 7.09487 16.9456 6.9771 17.0848C6.66126 17.4622 6.71747 18.0029 7.06141 18.3482C7.40535 18.6935 7.8858 18.7778 8.32476 18.8621C9.22409 19.0347 10.189 19.0414 10.9277 18.4285L10.4018 18.3602C10.8689 19.1418 11.8632 19.4121 12.7144 19.1953C13.6699 18.9517 14.3605 18.1287 14.8168 17.299L14.2909 17.3672C15.5234 18.8367 17.9391 18.9638 19.3563 17.7031C19.4687 17.6041 19.4781 17.4221 19.4085 17.2976C17.6968 14.2169 15.9691 11.108 14.8623 7.7462C14.5518 6.8027 14.2936 5.84448 14.0982 4.87021C14.0433 4.59585 13.611 4.53697 13.4866 4.78991C11.8993 8.03795 10.2292 11.2445 8.47599 14.4056C7.98216 15.2955 7.48297 16.1815 6.9771 17.0634C6.76297 17.4381 7.34111 17.7754 7.55524 17.4007L7.55658 17.4047Z" fill="%232EBF8F"/><path d="M6.91821 17.6532C7.68372 18.8938 9.43822 19.2123 10.5222 18.2166L10.7163 18.0427L10.8742 18.2635C11.4831 19.1253 12.7786 19.3595 13.6271 18.7131C14.0031 18.4589 14.24 18.056 14.402 17.6438C14.8409 17.945 15.316 18.2086 15.8339 18.3531C16.8939 18.6797 18.9267 18.7734 19.3496 17.4766C19.2345 18.5017 18.0234 18.8604 17.1401 18.9219C16.1792 18.9888 15.2036 18.7493 14.3752 18.2514L14.7553 18.1337C14.5853 18.5432 14.2962 18.8925 13.9456 19.1521C12.875 19.9912 11.2021 19.6714 10.4794 18.5298L10.8314 18.5766C9.56536 19.6339 7.53383 19.207 6.91821 17.6532Z" fill="%230F3548"/><path d="M9.01115 16.5106C8.93888 16.1613 9.14632 15.8254 9.49293 15.7397C9.56654 16.089 9.35643 16.4236 9.01115 16.5106Z" fill="%23FFE4C7"/><path d="M10.6453 13.6156C10.6801 12.9759 10.9223 12.3709 11.3439 11.8892C11.4027 12.5329 11.1337 13.1927 10.6453 13.6156Z" fill="%23FFE4C7"/><path d="M14.1196 11.1118C14.4729 11.5227 14.6737 12.0165 14.6978 12.5572C14.228 12.2587 13.9858 11.6511 14.1196 11.1118Z" fill="%23FFE4C7"/><path d="M15.8555 15.8359C16.281 15.9564 16.6103 16.2174 16.819 16.6068C16.3587 16.6563 15.909 16.295 15.8555 15.8359Z" fill="%23FFE4C7"/><path d="M12.7704 15.4512C13.0434 15.7028 13.0862 16.1136 12.8667 16.4147C12.591 16.1631 12.5522 15.7523 12.7704 15.4512Z" fill="%23FFE4C7"/><path d="M11.5154 23.2578C11.668 23.6954 11.5516 24.1879 11.2183 24.5091C11.0644 24.0715 11.1835 23.5803 11.5154 23.2578Z" fill="%23FFE4C7"/><path d="M7.45631 26.436C7.54999 26.974 7.05884 27.5375 6.51147 27.5134C6.78583 27.0905 7.07356 26.7653 7.45631 26.436Z" fill="%23FFE4C7"/><path d="M8.92045 21.0444C8.9325 21.549 8.67555 22.0308 8.24595 22.2984C8.23123 21.7939 8.4922 21.3121 8.92045 21.0444Z" fill="%23FFE4C7"/><path d="M17.3047 26.5347C17.745 26.8933 18.0849 27.2895 18.366 27.7833C17.7758 27.7017 17.2913 27.1289 17.3047 26.5347Z" fill="%23FFE4C7"/><path d="M16.8188 20.4624C17.0544 20.7635 17.1695 21.0432 17.2069 21.4246C16.7733 21.3818 16.5378 20.7943 16.8188 20.4624Z" fill="%23FFE4C7"/><path d="M20.5808 25.4736C20.9716 25.4361 21.3343 25.6757 21.448 26.0517C21.0572 26.0905 20.6959 25.8483 20.5808 25.4736Z" fill="%23FFE4C7"/><path d="M14.0996 23.8433C14.4556 24.1511 14.6095 24.6409 14.4877 25.0959C14.1304 24.7894 13.9805 24.2983 14.0996 23.8433Z" fill="%23FFE4C7"/><path d="M12.1201 26.9937C12.3155 27.4701 12.3128 28.0362 12.0077 28.4658C11.811 27.9893 11.8177 27.4246 12.1201 26.9937Z" fill="%23FFE4C7"/><path d="M11.5419 33.2109C11.6369 33.8386 11.5272 34.5091 11.1324 35.019C11.036 34.3913 11.1484 33.7208 11.5419 33.2109Z" fill="%23FFE4C7"/><path d="M5.256 31.7446C5.10745 32.4459 4.50521 33.0428 3.80127 33.1806C4.21614 32.6185 4.69124 32.1541 5.256 31.7446Z" fill="%23FFE4C7"/><path d="M7.57405 35.2173C7.44155 35.8971 6.88215 36.4847 6.20898 36.6479C6.573 36.0778 7.02267 35.6094 7.57405 35.2173Z" fill="%23FFE4C7"/><path d="M15.2291 30.536C15.6788 30.8853 16.0281 31.3778 16.376 31.8168C16.4978 31.9533 16.5888 32.1219 16.7829 32.162C16.5915 32.2852 16.3426 32.1366 16.1793 32.0282C15.6962 31.6602 15.3549 31.1289 15.2278 30.5347L15.2291 30.536Z" fill="%23FFE4C7"/><path d="M16.147 35.6929C16.5097 36.0837 16.883 36.5775 17.227 36.9816C17.3447 37.1275 17.4665 37.2707 17.583 37.4407C17.3809 37.3992 17.2002 37.3082 17.0329 37.1958C16.5444 36.8545 16.1697 36.3005 16.147 35.6929Z" fill="%23FFE4C7"/><path d="M20.582 31.8354C21.0277 32.1138 21.3542 32.5059 21.5389 32.9971C21.0103 32.8793 20.5981 32.3761 20.582 31.8354Z" fill="%23FFE4C7"/><path d="M23.2737 35.8931C23.8063 35.9533 24.2841 36.2772 24.533 36.7509C24.0004 36.692 23.5239 36.3655 23.2737 35.8931Z" fill="%23FFE4C7"/><path d="M14.1757 0.300113L14.6013 1.60896C14.6588 1.7883 14.8261 1.91008 15.0148 1.91008H16.3906C16.8121 1.91008 16.9874 2.44941 16.6462 2.697L15.5327 3.50533C15.3801 3.61641 15.3159 3.8118 15.3748 3.99113L15.8004 5.29998C15.9302 5.70013 15.4725 6.03337 15.1312 5.78578L14.0178 4.97745C13.8652 4.86637 13.6591 4.86637 13.5065 4.97745L12.3931 5.78578C12.0518 6.03337 11.5941 5.70013 11.7239 5.29998L12.1495 3.99113C12.207 3.8118 12.1441 3.61507 11.9916 3.50533L10.8781 2.697C10.5369 2.44941 10.7122 1.91008 11.1337 1.91008H12.5095C12.6982 1.91008 12.8655 1.7883 12.923 1.60896L13.3486 0.300113C13.4784 -0.100038 14.0459 -0.100038 14.1757 0.300113Z" fill="%23F8B000"/><path d="M8.5054 14.6304C8.98435 14.6304 9.37261 14.2422 9.37261 13.7632C9.37261 13.2843 8.98435 12.896 8.5054 12.896C8.02645 12.896 7.63818 13.2843 7.63818 13.7632C7.63818 14.2422 8.02645 14.6304 8.5054 14.6304Z" fill="%23E72D33"/><path d="M19.2051 24.3179C19.2051 23.7184 18.7193 23.2339 18.1211 23.2339C17.5229 23.2339 17.0371 23.7197 17.0371 24.3179C17.0371 24.9161 17.5229 25.4019 18.1211 25.4019C18.7193 25.4019 19.2051 24.9161 19.2051 24.3179Z" fill="%23E72D33"/><path d="M8.7945 33.5723C8.7945 32.9727 8.3087 32.4883 7.71048 32.4883C7.11227 32.4883 6.62646 32.9741 6.62646 33.5723C6.62646 34.1705 7.11227 34.6563 7.71048 34.6563C8.3087 34.6563 8.7945 34.1705 8.7945 33.5723Z" fill="%23E72D33"/><path d="M16.313 11.3765C16.313 10.9375 15.9571 10.5815 15.5181 10.5815C15.0791 10.5815 14.7231 10.9375 14.7231 11.3765C14.7231 11.8155 15.0791 12.1714 15.5181 12.1714C15.9571 12.1714 16.313 11.8155 16.313 11.3765Z" fill="%23E72D33"/><path d="M9.22805 25.5484C9.707 25.5484 10.0953 25.1601 10.0953 24.6812C10.0953 24.2022 9.707 23.814 9.22805 23.814C8.7491 23.814 8.36084 24.2022 8.36084 24.6812C8.36084 25.1601 8.7491 25.5484 9.22805 25.5484Z" fill="%23E72D33"/><path d="M16.7466 35.5973C17.465 35.5973 18.0474 35.0149 18.0474 34.2964C18.0474 33.578 17.465 32.9956 16.7466 32.9956C16.0282 32.9956 15.4458 33.578 15.4458 34.2964C15.4458 35.0149 16.0282 35.5973 16.7466 35.5973Z" fill="%23E72D33"/><path d="M13.2764 14.0518C13.2764 13.6128 12.9204 13.2568 12.4815 13.2568C12.0425 13.2568 11.6865 13.6128 11.6865 14.0518C11.6865 14.4907 12.0425 14.8467 12.4815 14.8467C12.9204 14.8467 13.2764 14.4907 13.2764 14.0518Z" fill="%23F8B000"/><path d="M3.80546 27.2105C4.44406 27.2105 4.96174 26.6928 4.96174 26.0542C4.96174 25.4156 4.44406 24.8979 3.80546 24.8979C3.16686 24.8979 2.64917 25.4156 2.64917 26.0542C2.64917 26.6928 3.16686 27.2105 3.80546 27.2105Z" fill="%23F8B000"/><path d="M11.9756 39.7906C12.6142 39.7906 13.1319 39.2729 13.1319 38.6343C13.1319 37.9957 12.6142 37.478 11.9756 37.478C11.337 37.478 10.8193 37.9957 10.8193 38.6343C10.8193 39.2729 11.337 39.7906 11.9756 39.7906Z" fill="%23F8B000"/><path d="M22.5308 31.6197C23.0896 31.6197 23.5425 31.1667 23.5425 30.6079C23.5425 30.0492 23.0896 29.5962 22.5308 29.5962C21.972 29.5962 21.519 30.0492 21.519 30.6079C21.519 31.1667 21.972 31.6197 22.5308 31.6197Z" fill="%23F8B000"/></svg>');
        width: 2.4rem;
        height: 4rem;
        margin-bottom: 1rem;
        margin-left: -1rem;
      }

      media-controller:not([breakpointsm]) media-time-range::part(thumb) {
        width: 1.4rem;
        height: 3rem;
        margin-bottom: -0.5rem;
      }

      media-time-range::part(preview-box) {
        --media-preview-box-margin: 0 0 20px;
        display: grid;
      }

      media-volume-range {
        height: 100%;
      }

      media-time-display {
        --media-secondary-color: transparent;
        min-width: 92px;
        padding: 0 6px 3px 8px;
      }

      media-time-display,
      media-preview-time-display {
        font-size: 0.75rem;
        font-family: sofia-pro, sans-serif;
      }

      .gradient-bottom {
        position: absolute;
        width: 100%;
        height: 40%;
        bottom: 0;
        pointer-events: none;
        background: linear-gradient(0deg, #000000d8, transparent);
      }

      div[slot='top-chrome'] {
        width: 100%;
        display: flex;
        flex-direction: row-reverse;
        padding: 0.5rem;
        box-sizing: border-box;
        background: linear-gradient(0deg, transparent, #000000d9);
        height: 40%;
      }

      div[slot='top-chrome'] > svg {
        width: 40%;
        position: absolute;
        top: -0.5rem;
      }

      div[slot='top-chrome'] > svg:nth-child(1) {
        right: -0.5rem;
      }
      div[slot='top-chrome'] > svg:nth-child(2) {
        left: -0.5rem;
      }

      media-controller {
        overflow: hidden;
      }

      media-controller[breakpointsm] .media-volume-wrapper {
        position: relative;
      }

      .media-volume-range-wrapper {
        width: 122px;
        height: 2rem;
        overflow: hidden;
        opacity: 0;
        transform: rotate(-90deg);
        position: absolute;
        top: -4.5rem;
        left: -3rem;
      }

      media-volume-range {
        border-radius: 0 9999px 9999px 0;
        --media-range-thumb-width: 1rem;
        --media-range-thumb-height: 1rem;
        --media-range-track-width: 80px;
        --media-range-thumb-background: url('data:image/svg+xml,<svg width="8" height="8" viewBox="0 0 8 8" fill="none" xmlns="http://www.w3.org/2000/svg"><circle cx="4" cy="4" r="4" fill="%23FFE4C7"/><mask id="mask0_38_340" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="8" height="8"><circle cx="4" cy="4" r="4" fill="%23F3E0A5"/></mask><g mask="url(%23mask0_38_340)"><path d="M12 0C12 2.20914 10.2091 4 8 4C5.79086 4 4 2.20914 4 0C4 -2.20914 5.79086 -4 8 -4C10.2091 -4 12 -2.20914 12 0Z" fill="%23E72D33"/><path d="M4 0C4 2.20914 2.20914 4 0 4C-2.20914 4 -4 2.20914 -4 0C-4 -2.20914 -2.20914 -4 0 -4C2.20914 -4 4 -2.20914 4 0Z" fill="%23A82E28"/><path d="M4 8C4 10.2091 2.20914 12 0 12C-2.20914 12 -4 10.2091 -4 8C-4 5.79086 -2.20914 4 0 4C2.20914 4 4 5.79086 4 8Z" fill="%23E72D33"/><path d="M12 8C12 10.2091 10.2091 12 8 12C5.79086 12 4 10.2091 4 8C4 5.79086 5.79086 4 8 4C10.2091 4 12 5.79086 12 8Z" fill="%23BE1A1E"/></g></svg>')
          no-repeat center/cover;
      }

      media-mute-button:hover + .media-volume-range-wrapper,
      media-mute-button:focus + .media-volume-range-wrapper,
      media-mute-button:focus-within + .media-volume-range-wrapper,
      .media-volume-range-wrapper:hover,
      .media-volume-range-wrapper:focus,
      .media-volume-range-wrapper:focus-within {
        opacity: 1;
      }

      media-controller:not([breakpointsm]) media-control-bar {
        position: static;
        background: transparent;
        margin: 0;
        padding: 1rem;
      }

      media-controller:not([breakpointsm]) media-time-display,
      media-controller:not([breakpointsm]) .media-volume-range-wrapper {
        display: none;
      }

      media-controller:not([breakpointsm]) .icon-button {
        display: none;
        width: 1.5rem;
        height: 1.5rem;
        display: block;
      }

      media-controller:not([breakpointsm]) div[slot='top-chrome'] .icon-button {
        display: flex;
        margin: 22px 7px;
      }

      media-controller:not([breakpointsm]) media-fullscreen-button.icon-button {
        display: flex;
      }

      media-controller:not([breakpointsm]) media-airplay-button[mediaairplayunavailable].icon-button {
        display: none;
      }

      media-controller:not([breakpointsm]) media-cast-button[mediacastunavailable].icon-button {
        display: none;
      }

      media-controller:not([breakpointsm]) media-mute-button.icon-button {
        display: flex;
      }

      media-controller:not([breakpointsm]) media-captions-button.icon-button {
        position: absolute;
        top: 22px;
        left: 16px;
      }

      media-controller:not([breakpointsm]) div[slot='centered-chrome'] media-play-button {
        z-index: 1;
        height: 100%;
        width: max-content;
        margin-top: -20%;
        padding: 0;
        top: 0;
        max-width: 25%;
      }

      media-controller:not([breakpointsm]) div[slot='centered-chrome'] media-play-button #wire {
        display: none;
      }
    </style>

    <media-controller
      breakpoints="xs:360 sm:600 md:760 lg:960 xl:1100"
      defaultsubtitles="{{defaultsubtitles}}"
      defaultduration="{{defaultduration}}"
      gesturesdisabled="{{disabled}}"
      hotkeys="{{hotkeys}}"
      nohotkeys="{{nohotkeys}}"
      defaultstreamtype="on-demand"
    >
      <slot name="media" slot="media"></slot>
      <slot name="poster" slot="poster"></slot>
      <media-error-dialog slot="dialog"></media-error-dialog>
      <div class="gradient-bottom"></div>
      <div slot="top-chrome">
        <svg xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid meet" viewBox="0 0 310 169">
          <g id="Capa 6">
            <path
              id="Subtract"
              fill-rule="evenodd"
              clip-rule="evenodd"
              d="M14.4487 22.3701C7.82084 14.8303 3.22023 6.9963 0 0H2.20656C5.33853 6.63628 9.73442 13.9779 15.9509 21.0497L15.951 21.0499C39.3762 47.7134 77.1691 57.508 109.823 58.2301C119.797 58.4507 129.264 57.8237 137.661 56.5818C135.029 52.5298 133.516 48.291 133.58 44.1444C133.66 39.0177 136.153 33.7581 139.731 29.7628C143.302 25.7754 148.096 22.891 152.921 22.7503C158.102 22.5995 163.632 25.6037 167.6 29.4451C169.599 31.3801 171.255 33.5756 172.301 35.7824C173.341 37.9769 173.821 40.2759 173.311 42.3577C172.637 45.1114 170.205 47.5893 166.727 49.7352C163.211 51.9043 158.444 53.8467 152.769 55.4545C149.244 56.453 145.354 57.3267 141.172 58.046C144.27 61.9817 148.508 65.7636 153.517 69.0839C164.417 76.3091 178.826 81.2594 192.715 80.9202C206.534 80.5824 215.128 75.1287 222.864 70.136L223.188 69.9267C230.779 65.025 237.774 60.5087 248.037 62.5695L248.037 62.5696C261.008 65.1794 267.628 75.9561 274.173 86.6711L274.273 86.8344C280.869 97.633 287.466 108.433 300.191 112.599C303.35 113.633 306.57 114.152 309.81 114.25V116.251C306.378 116.153 302.948 115.606 299.569 114.5L299.569 114.5C286.139 110.104 279.198 98.7375 272.715 88.1205L272.466 87.7137C265.827 76.8438 259.621 66.9404 247.643 64.5303C238.18 62.6303 231.809 66.7428 224.068 71.7393L223.948 71.8163C216.171 76.8361 207.175 82.5674 192.764 82.9196C178.403 83.2704 163.598 78.1657 152.412 70.7509C146.905 67.1004 142.243 62.8684 138.934 58.4117C130.171 59.7705 120.24 60.461 109.779 60.2297C76.8655 59.5018 38.4036 49.6364 14.4487 22.3701ZM139.84 56.2418C144.335 55.5036 148.493 54.587 152.224 53.5303C157.795 51.9519 162.372 50.0718 165.677 48.0331C169.019 45.9711 170.885 43.856 171.368 41.8821C171.729 40.4089 171.423 38.5992 170.493 36.639C169.57 34.6911 168.073 32.6859 166.209 30.8822C162.453 27.2462 157.418 24.6203 152.979 24.7495C148.884 24.8689 144.568 27.3594 141.221 31.097C137.881 34.8267 135.65 39.6422 135.58 44.1754C135.52 48.0549 137.037 52.1779 139.84 56.2418Z"
              fill="white"
            />
            <path
              id="Vector (Stroke)"
              fill-rule="evenodd"
              clip-rule="evenodd"
              d="M241.16 74.1517C241.919 70.3946 242.659 66.6469 243.388 62.9082L245.351 63.2913C244.621 67.0323 243.881 70.7844 243.12 74.547C241.289 83.6609 239.419 92.6853 237.498 101.62L235.542 101.2C237.461 92.2744 239.33 83.2588 241.159 74.1528L241.16 74.1517Z"
              fill="white"
            />
            <path
              id="Vector (Stroke)_2"
              fill-rule="evenodd"
              clip-rule="evenodd"
              d="M203.418 90.8279C205.138 86.3874 205.226 82.3542 205.072 79.8411L207.068 79.7183C207.233 82.4051 207.142 86.7517 205.282 91.551L205.282 91.5515C204.471 93.6413 203.494 95.3657 202.582 96.7344L200.918 95.625C201.765 94.3538 202.668 92.7584 203.417 90.8284"
              fill="white"
            />
            <path
              id="Vector (Stroke)_3"
              fill-rule="evenodd"
              clip-rule="evenodd"
              d="M242.72 90.4939C240.469 83.6873 240.716 77.7271 241.147 74.2275L243.132 74.472C242.723 77.7924 242.491 83.432 244.619 89.8653C245.883 93.6765 247.604 96.6704 249.089 98.7971L247.45 99.9425C245.876 97.6892 244.057 94.5232 242.721 90.4946L242.72 90.4939Z"
              fill="white"
            />
            <g id="Group">
              <path
                id="Vector"
                d="M236.805 114.696C239.322 122.379 241.849 130.065 244.366 137.749C244.634 138.566 244.906 139.405 244.782 140.252C244.655 141.191 244.069 141.986 243.444 142.699C241.312 145.088 238.52 146.815 236.456 149.264C234.392 151.713 233.183 155.375 234.877 158.096C236.844 161.263 241.42 161.34 245.058 160.513C255.689 158.082 264.699 151.272 273.358 144.647C273.943 144.204 274.551 143.714 274.807 143.027C275.09 142.244 274.847 141.371 274.594 140.579C270.533 127.606 265.048 115.079 258.29 103.288C250.804 105.299 243.62 108.426 237.045 112.524"
                fill="#DE2D35"
              />
              <path
                id="Vector_2"
                d="M233.261 105.744C231.74 104.736 229.425 105.959 229.067 107.757C228.712 109.546 229.986 111.399 231.675 112.09C230.001 113.391 229.458 115.958 230.47 117.823C231.481 119.689 233.915 120.651 235.933 119.96C236.413 122.573 239.809 123.846 242.261 122.846C244.726 121.84 246.219 119.279 246.84 116.692C250.872 118.103 255.834 115.271 256.667 111.084C257.258 111.698 258.205 111.796 259.059 111.735C262.029 111.548 265.038 109.745 265.935 106.9C266.832 104.055 264.874 100.466 261.904 100.271C261.796 98.5856 261.244 96.9365 260.319 95.5189C260.069 95.1411 259.777 94.7627 259.38 94.5425C258.424 94.017 257.165 94.5805 256.567 95.497C255.963 96.4013 255.854 97.542 255.76 98.6247C254.878 96.9701 252.842 96.0311 251.014 96.4418C249.185 96.8525 247.739 98.5771 247.652 100.448C247.342 98.6675 245.466 97.326 243.683 97.6041C241.9 97.8822 240.523 99.7389 240.779 101.526C239.768 100.313 237.828 100.021 236.504 100.867C235.18 101.713 234.631 103.606 235.306 105.029"
                fill="#FFE4C7"
              />
              <path
                id="Vector_3"
                d="M269.282 127.829C265.321 129.708 262.915 133.743 262.071 137.937C261.226 142.132 261.509 147.374 264.836 150.45C265.816 151.354 267.293 149.897 266.314 148.992C263.467 146.366 263.365 141.721 264.138 138.181C264.911 134.64 266.906 131.251 270.322 129.63C271.53 129.063 270.488 127.272 269.289 127.842L269.282 127.829Z"
                fill="#FFE4C7"
              />
              <g id="Group_2">
                <path
                  id="Vector_4"
                  d="M259.759 116.467C260.835 116.083 261.324 116.69 260.694 117.65C259.609 118.032 259.141 117.42 259.759 116.467Z"
                  fill="#FFE4C7"
                />
                <path
                  id="Vector_5"
                  d="M263.9 126.626C265.047 126.56 265.34 127.281 264.457 128.027C263.311 128.093 263.027 127.375 263.9 126.626Z"
                  fill="#FFE4C7"
                />
                <path
                  id="Vector_6"
                  d="M255.748 124.441C257.112 124.724 257.778 126.062 257.163 127.315C255.797 127.042 255.135 125.685 255.748 124.441Z"
                  fill="#FFE4C7"
                />
                <path
                  id="Vector_7"
                  d="M247.653 123.204C248.834 123.199 249.243 124.106 248.431 124.975C247.247 124.989 246.85 124.075 247.653 123.204Z"
                  fill="#FFE4C7"
                />
                <path
                  id="Vector_8"
                  d="M252.516 134.186C253.964 134.73 254.654 136.291 254.064 137.718C252.613 137.184 251.936 135.615 252.516 134.186Z"
                  fill="#FFE4C7"
                />
                <path
                  id="Vector_9"
                  d="M248.349 144.945C249.737 145.524 250.307 147.064 249.618 148.401C248.228 147.832 247.66 146.282 248.349 144.945Z"
                  fill="#FFE4C7"
                />
                <path
                  id="Vector_10"
                  d="M255.855 148.499C257.487 148.977 258.348 150.864 257.614 152.407C256.211 151.575 255.549 150.104 255.855 148.499Z"
                  fill="#FFE4C7"
                />
                <path
                  id="Vector_11"
                  d="M241.524 154.307C242.67 154.241 242.963 154.962 242.092 155.702C240.946 155.767 240.662 155.049 241.524 154.307Z"
                  fill="#FFE4C7"
                />
              </g>
            </g>
            <path
              id="Vector_12"
              d="M244.37 65.0699C245.458 65.0699 246.34 64.1879 246.34 63.0999C246.34 62.0119 245.458 61.1299 244.37 61.1299C243.282 61.1299 242.4 62.0119 242.4 63.0999C242.4 64.1879 243.282 65.0699 244.37 65.0699Z"
              fill="white"
            />
            <path
              id="Vector_13"
              d="M203.56 95.4898C204.648 95.4898 205.53 94.6078 205.53 93.5198C205.53 92.4318 204.648 91.5498 203.56 91.5498C202.472 91.5498 201.59 92.4318 201.59 93.5198C201.59 94.6078 202.472 95.4898 203.56 95.4898Z"
              fill="white"
            />
            <g id="Group_3">
              <path
                id="Vector_14"
                opacity="0.4"
                d="M198.56 113.51C197.36 110.76 196.58 106.43 198.65 100.44L207.19 101.44C207.19 101.44 208.25 108.25 203.94 114.11C202.51 116.06 199.52 115.73 198.56 113.51Z"
                fill="#2EBF8F"
              >
                <animate
                  attributeName="opacity"
                  values="0.4;1;0.4"
                  begin="0s"
                  dur="1s"
                  repeatCount="indefinite"
                  fill="freeze"
                  calcMode="linear"
                  keyTimes="0;0.5;1"
                />
              </path>
              <path
                id="Vector_15"
                d="M207.19 101.45L198.65 100.45L199.07 96.9C199.35 94.54 201.48 92.86 203.84 93.13C206.2 93.41 207.88 95.54 207.61 97.9L207.19 101.45Z"
                fill="white"
              />
              <path
                id="Vector_16"
                d="M200.09 103.04C201.17 105.61 201.54 108.44 200.27 111.02C198.73 108.78 198.37 105.27 200.09 103.04Z"
                fill="#FFFCF7"
              />
            </g>
            <path
              id="Vector (Stroke)_4"
              fill-rule="evenodd"
              clip-rule="evenodd"
              d="M106.047 68.6183C107.448 65.007 107.526 61.714 107.392 59.6652L109.388 59.5347C109.534 61.7659 109.451 65.3729 107.912 69.3416L107.912 69.3416C107.242 71.0695 106.435 72.5056 105.668 73.64L104.011 72.52C104.704 71.4943 105.438 70.1904 106.047 68.6183Z"
              fill="white"
            />
            <path
              id="Vector_17"
              d="M106.32 72.53C107.214 72.53 107.94 71.8047 107.94 70.91C107.94 70.0153 107.214 69.29 106.32 69.29C105.425 69.29 104.7 70.0153 104.7 70.91C104.7 71.8047 105.425 72.53 106.32 72.53Z"
              fill="white"
            />
            <g id="Group_4">
              <path
                id="Vector_18"
                d="M102.21 87.3496C101.23 85.0896 100.58 81.5196 102.29 76.5996L109.31 77.4196C109.31 77.4196 110.18 83.0296 106.64 87.8396C105.46 89.4396 103.01 89.1696 102.21 87.3496Z"
                fill="#2EBF8F"
              >
                <animate
                  attributeName="opacity"
                  values="1;0.4;1"
                  begin="0s"
                  dur="1s"
                  repeatCount="indefinite"
                  fill="freeze"
                  calcMode="linear"
                  keyTimes="0;0.5;1"
                />
              </path>
              <path
                id="Vector_19"
                d="M109.31 77.4298L102.29 76.6098L102.63 73.6898C102.86 71.7498 104.61 70.3598 106.55 70.5898C108.49 70.8198 109.88 72.5698 109.65 74.5098L109.31 77.4298Z"
                fill="white"
              />
              <path
                id="Vector_20"
                d="M103.47 78.73C104.61 80.8 104.91 83.22 103.62 85.29C102.1 83.51 101.82 80.51 103.47 78.73Z"
                fill="#FFFCF7"
              />
            </g>
            <path
              id="Vector_21"
              d="M36.0997 58.8899C36.9944 58.8899 37.7197 58.1646 37.7197 57.2699C37.7197 56.3752 36.9944 55.6499 36.0997 55.6499C35.205 55.6499 34.4797 56.3752 34.4797 57.2699C34.4797 58.1646 35.205 58.8899 36.0997 58.8899Z"
              fill="white"
            />
            <g id="Group_5">
              <path
                id="Vector_22"
                d="M39.7698 73.82C37.8798 72.23 35.7098 69.34 35.0398 64.17L41.6898 61.77C41.6898 61.77 44.9698 66.39 43.9598 72.28C43.6198 74.24 41.3098 75.09 39.7798 73.82H39.7698Z"
                fill="#F8B000"
              >
                <animate
                  attributeName="opacity"
                  values="1;0.4;1"
                  begin="0s"
                  dur="1s"
                  repeatCount="indefinite"
                  fill="freeze"
                  calcMode="linear"
                  keyTimes="0;0.5;1"
                />
              </path>
              <path
                id="Vector_23"
                d="M41.6798 61.7701L35.0298 64.1701L34.0298 61.4001C33.3698 59.5601 34.3198 57.5401 36.1498 56.8801C37.9898 56.2201 40.0098 57.1701 40.6698 59.0001L41.6698 61.7701H41.6798Z"
                fill="white"
              />
              <path
                id="Vector_24"
                d="M37.0396 65.5503C38.9796 66.8903 40.3296 68.9203 40.1096 71.3603C37.9496 70.4403 36.3596 67.8903 37.0396 65.5503Z"
                fill="#FFFCF7"
              />
            </g>
            <path
              id="Vector (Stroke)_5"
              fill-rule="evenodd"
              clip-rule="evenodd"
              d="M177.647 91.3913C175.788 86.592 175.696 82.2454 175.862 79.5586L177.858 79.6814C177.703 82.1946 177.792 86.228 179.512 90.6687C180.261 92.5987 181.164 94.1941 182.012 95.4653L180.348 96.5747C179.435 95.206 178.459 93.4816 177.648 91.3918L177.647 91.3913Z"
              fill="white"
            />
            <path
              id="Vector_25"
              d="M179.37 95.3301C180.458 95.3301 181.34 94.4481 181.34 93.3601C181.34 92.2721 180.458 91.3901 179.37 91.3901C178.282 91.3901 177.4 92.2721 177.4 93.3601C177.4 94.4481 178.282 95.3301 179.37 95.3301Z"
              fill="white"
            />
            <g id="Group_6">
              <path
                id="Vector_26"
                d="M184.37 113.36C185.57 110.61 186.35 106.28 184.28 100.29L175.74 101.29C175.74 101.29 174.68 108.1 178.99 113.96C180.42 115.91 183.41 115.58 184.37 113.36Z"
                fill="#DE2D35"
              >
                <animate
                  attributeName="opacity"
                  values="1;0.4;1"
                  begin="0s"
                  dur="1s"
                  repeatCount="indefinite"
                  fill="freeze"
                  calcMode="linear"
                  keyTimes="0;0.5;1"
                />
              </path>
              <path
                id="Vector_27"
                d="M175.74 101.29L184.28 100.29L183.86 96.7399C183.58 94.3799 181.45 92.6999 179.09 92.9699C176.73 93.2499 175.05 95.3799 175.32 97.7399L175.74 101.29Z"
                fill="white"
              />
              <path
                id="Vector_28"
                d="M182.84 102.88C184.56 105.11 184.2 108.62 182.66 110.86C181.39 108.28 181.76 105.45 182.84 102.88Z"
                fill="#FFFCF7"
              />
            </g>
            <path
              id="Vector (Stroke)_6"
              fill-rule="evenodd"
              clip-rule="evenodd"
              d="M146.127 76.2214C144.268 71.4221 144.176 67.0755 144.342 64.3887L146.338 64.5115C146.183 67.0247 146.272 71.0581 147.992 75.4988C148.741 77.4288 149.644 79.0242 150.492 80.2954L148.828 81.4048C147.915 80.0361 146.939 78.3117 146.128 76.2219L146.127 76.2214Z"
              fill="white"
            />
            <path
              id="Vector_29"
              d="M147.85 80.1597C148.938 80.1597 149.82 79.2777 149.82 78.1897C149.82 77.1017 148.938 76.2197 147.85 76.2197C146.762 76.2197 145.88 77.1017 145.88 78.1897C145.88 79.2777 146.762 80.1597 147.85 80.1597Z"
              fill="white"
            />
            <g id="Group_7">
              <path
                id="Vector_30"
                opacity="0.4"
                d="M152.84 98.1901C154.04 95.4401 154.82 91.1101 152.75 85.1201L144.21 86.1201C144.21 86.1201 143.15 92.9301 147.46 98.7901C148.89 100.74 151.88 100.41 152.84 98.1901Z"
                fill="#F8B000"
              >
                <animate
                  attributeName="opacity"
                  values="0.4;1;0.4"
                  begin="0s"
                  dur="1s"
                  repeatCount="indefinite"
                  fill="freeze"
                  calcMode="linear"
                  keyTimes="0;0.5;1"
                />
              </path>
              <path
                id="Vector_31"
                d="M144.21 86.12L152.75 85.12L152.33 81.57C152.05 79.21 149.92 77.53 147.56 77.8C145.2 78.08 143.52 80.21 143.79 82.57L144.21 86.12Z"
                fill="white"
              />
              <path
                id="Vector_32"
                d="M151.32 87.71C153.04 89.94 152.68 93.45 151.14 95.69C149.87 93.11 150.24 90.28 151.32 87.71Z"
                fill="#FFFCF7"
              />
            </g>
            <path
              id="Vector (Stroke)_7"
              fill-rule="evenodd"
              clip-rule="evenodd"
              d="M63.4571 61.0107C61.9677 57.1614 61.8961 53.6747 62.0317 51.5269L64.0277 51.6528C63.9033 53.6249 63.9717 56.7979 65.3221 60.2885C65.9122 61.8113 66.6157 63.0656 67.2793 64.0515L65.6201 65.1682C64.8837 64.074 64.1072 62.6884 63.4573 61.0112L63.4571 61.0107Z"
              fill="white"
            />
            <path
              id="Vector_33"
              d="M65.0197 64.0599C65.8813 64.0599 66.5797 63.3615 66.5797 62.4999C66.5797 61.6384 65.8813 60.9399 65.0197 60.9399C64.1582 60.9399 63.4597 61.6384 63.4597 62.4999C63.4597 63.3615 64.1582 64.0599 65.0197 64.0599Z"
              fill="white"
            />
            <g id="Group_8">
              <path
                id="Vector_34"
                opacity="0.4"
                d="M68.9897 78.3898C69.9397 76.1998 70.5597 72.7598 68.9197 68.0098L62.1397 68.7998C62.1397 68.7998 61.2997 74.2098 64.7197 78.8598C65.8597 80.4098 68.2297 80.1498 68.9997 78.3798L68.9897 78.3898Z"
                fill="#DE2D35"
              >
                <animate
                  attributeName="opacity"
                  values="0.4;1;0.4"
                  begin="0s"
                  dur="1s"
                  repeatCount="indefinite"
                  fill="freeze"
                  calcMode="linear"
                  keyTimes="0;0.5;1"
                />
              </path>
              <path
                id="Vector_35"
                d="M62.1398 68.7999L68.9198 68.0099L68.5898 65.1899C68.3698 63.3199 66.6698 61.9799 64.7998 62.1999C62.9298 62.4199 61.5898 64.1199 61.8098 65.9899L62.1398 68.8099V68.7999Z"
                fill="white"
              />
              <path
                id="Vector_36"
                d="M67.7798 70.0698C69.4298 71.8098 69.1498 74.6698 67.6398 76.4098C66.3498 74.4098 66.6398 72.0598 67.7798 70.0698Z"
                fill="#FFFCF7"
              />
            </g>
            <path
              id="Vector (Stroke)_8"
              fill-rule="evenodd"
              clip-rule="evenodd"
              d="M11.0572 25.1308C9.56781 21.2816 9.49623 17.7948 9.63178 15.647L11.6278 15.7729C11.5034 17.745 11.5718 20.9181 12.9222 24.4086C13.5123 25.9314 14.2158 27.1857 14.8794 28.1716L13.2202 29.2883C12.4837 28.1942 11.7073 26.8085 11.0573 25.1313L11.0572 25.1308Z"
              fill="white"
            />
            <path
              id="Vector_37"
              d="M12.6198 28.1898C13.4814 28.1898 14.1798 27.4914 14.1798 26.6298C14.1798 25.7683 13.4814 25.0698 12.6198 25.0698C11.7583 25.0698 11.0598 25.7683 11.0598 26.6298C11.0598 27.4914 11.7583 28.1898 12.6198 28.1898Z"
              fill="white"
            />
            <g id="Group_9">
              <path
                id="Vector_38"
                opacity="0.4"
                d="M16.5898 42.5099C17.5398 40.3199 18.1598 36.8799 16.5198 32.1299L9.73983 32.9199C9.73983 32.9199 8.89983 38.3299 12.3198 42.9799C13.4598 44.5299 15.8298 44.2699 16.5998 42.4999L16.5898 42.5099Z"
                fill="#2EBF8F"
              >
                <animate
                  attributeName="opacity"
                  values="0.4;1;0.4"
                  begin="0s"
                  dur="1s"
                  repeatCount="indefinite"
                  fill="freeze"
                  calcMode="linear"
                  keyTimes="0;0.5;1"
                />
              </path>
              <path
                id="Vector_39"
                d="M9.72986 32.92L16.5099 32.13L16.1799 29.31C15.9599 27.44 14.2599 26.1 12.3899 26.32C10.5199 26.54 9.17986 28.24 9.39986 30.11L9.72986 32.93V32.92Z"
                fill="white"
              />
              <path
                id="Vector_40"
                d="M15.3799 34.1899C17.0299 35.9299 16.7499 38.7899 15.2399 40.5299C13.9499 38.5299 14.2399 36.1799 15.3799 34.1899Z"
                fill="#FFFCF7"
              />
            </g>
            <path
              id="Vector (Stroke)_9"
              d="M35.6211 39C36.6526 40.6259 38.4834 44.5114 37.5551 47.0467C36.3947 50.2158 34.9142 49.5908 34.814 52.255C34.7338 54.3864 35.8344 56.9731 36.3947 58"
              stroke="white"
              stroke-width="2"
              stroke-miterlimit="10"
            />
          </g>
        </svg>
        <svg xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid meet" viewBox="0 0 289 148" fill="none">
          <g id="Capa 9">
            <path
              id="Vector"
              d="M289 0C285 8 276.5 19.1406 274.25 21.71C272.63 23.56 267.13 29.66 254.93 38.3C232.12 54.44 209.72 70.38 191.99 63.52C180.52 59.08 177.4 47.58 164.1 47.29C162.29 47.25 156.84 47.2 152.1 50.61C146.54 54.6 145.79 60.58 144.11 64.45C137.99 78.59 111.76 82.58 96.6999 81.92C65.4999 80.56 60.4499 59.76 41.5999 63.55C16.6499 68.57 26.39 98.36 0 107"
              stroke="white"
              stroke-width="2"
              stroke-miterlimit="10"
            />
            <path
              id="Vector_2"
              d="M45.0801 63.1001C45.8101 66.8401 46.5501 70.5901 47.3101 74.3501C49.1401 83.4601 51.0101 92.4801 52.9301 101.41"
              stroke="white"
              stroke-width="2"
              stroke-miterlimit="10"
            />
            <path
              id="Vector_3"
              d="M83.3801 79.77C83.2201 82.37 83.3101 86.56 85.1001 91.18C85.8801 93.19 86.8201 94.85 87.7001 96.17"
              stroke="white"
              stroke-width="2"
              stroke-miterlimit="10"
            />
            <path
              id="Vector_4"
              d="M47.3099 74.3501C47.7299 77.7601 47.9699 83.5601 45.7799 90.1801C44.4799 94.1001 42.7099 97.1801 41.1799 99.3701"
              stroke="white"
              stroke-width="2"
              stroke-miterlimit="10"
            />
            <path
              id="Vector_5"
              d="M85.8899 95.4898C86.9779 95.4898 87.8599 94.6078 87.8599 93.5198C87.8599 92.4318 86.9779 91.5498 85.8899 91.5498C84.8019 91.5498 83.9199 92.4318 83.9199 93.5198C83.9199 94.6078 84.8019 95.4898 85.8899 95.4898Z"
              fill="white"
            />
            <g id="Group">
              <path
                id="Vector_6"
                d="M90.88 113.51C92.08 110.76 92.86 106.43 90.79 100.44L82.25 101.44C82.25 101.44 81.19 108.25 85.5 114.11C86.93 116.06 89.92 115.73 90.88 113.51Z"
                fill="#2EBF8F"
              >
                <animate
                  attributeName="opacity"
                  values="1;0.3;1"
                  begin="0s"
                  dur="1s"
                  repeatCount="indefinite"
                  fill="freeze"
                  calcMode="linear"
                  keyTimes="0;0.5;1"
                />
              </path>
              <path
                id="Vector_7"
                d="M82.25 101.44L90.79 100.44L90.37 96.8898C90.09 94.5298 87.96 92.8498 85.6 93.1198C83.24 93.3998 81.56 95.5298 81.83 97.8898L82.25 101.44Z"
                fill="white"
              />
              <path
                id="Vector_8"
                d="M89.3601 103.04C91.0801 105.27 90.7201 108.78 89.1801 111.02C87.9101 108.44 88.2801 105.61 89.3601 103.04Z"
                fill="#FFFCF7"
              />
            </g>
            <path
              id="Vector_9"
              d="M253.35 58.8899C254.245 58.8899 254.97 58.1646 254.97 57.2699C254.97 56.3752 254.245 55.6499 253.35 55.6499C252.455 55.6499 251.73 56.3752 251.73 57.2699C251.73 58.1646 252.455 58.8899 253.35 58.8899Z"
              fill="white"
            />
            <g id="Group_2">
              <path
                id="Vector_10"
                opacity="0.3"
                d="M249.67 73.82C251.56 72.23 253.73 69.34 254.4 64.17L247.75 61.77C247.75 61.77 244.47 66.39 245.48 72.28C245.82 74.24 248.13 75.09 249.66 73.82H249.67Z"
                fill="#F8B000"
              >
                <animate
                  attributeName="opacity"
                  values="0.3;1;0.3"
                  begin="0s"
                  dur="1s"
                  repeatCount="indefinite"
                  fill="freeze"
                  calcMode="linear"
                  keyTimes="0;0.5;1"
                />
              </path>
              <path
                id="Vector_11"
                d="M247.76 61.7598L254.41 64.1598L255.41 61.3898C256.07 59.5498 255.12 57.5298 253.29 56.8698C251.45 56.2098 249.43 57.1598 248.77 58.9898L247.77 61.7598H247.76Z"
                fill="white"
              />
              <path
                id="Vector_12"
                d="M252.4 65.5498C253.08 67.8898 251.49 70.4398 249.33 71.3598C249.11 68.9298 250.45 66.8998 252.4 65.5498Z"
                fill="#FFFCF7"
              />
            </g>
            <path
              id="Vector_13"
              d="M112.45 81C112.597 83.378 112.514 87.2104 110.877 91.436C110.164 93.2744 109.305 94.7927 108.5 96"
              stroke="white"
              stroke-width="2"
              stroke-miterlimit="10"
            />
            <path
              id="Vector_14"
              d="M110.07 95.3301C111.158 95.3301 112.04 94.4481 112.04 93.3601C112.04 92.2721 111.158 91.3901 110.07 91.3901C108.982 91.3901 108.1 92.2721 108.1 93.3601C108.1 94.4481 108.982 95.3301 110.07 95.3301Z"
              fill="white"
            />
            <g id="Group_3">
              <path
                id="Vector_15"
                d="M105.08 113.35C103.88 110.6 103.1 106.27 105.17 100.28L113.71 101.28C113.71 101.28 114.77 108.09 110.46 113.95C109.03 115.9 106.04 115.57 105.08 113.35Z"
                fill="#DE2D35"
                fill-opacity="0.3"
              >
                <animate
                  attributeName="fill-opacity"
                  values="0.3;1;0.3"
                  begin="0s"
                  dur="1s"
                  repeatCount="indefinite"
                  fill="freeze"
                  calcMode="linear"
                  keyTimes="0;0.5;1"
                />
              </path>
              <path
                id="Vector_16"
                d="M113.71 101.29L105.17 100.29L105.59 96.7399C105.87 94.3799 108 92.6999 110.36 92.9699C112.72 93.2499 114.4 95.3799 114.13 97.7399L113.71 101.29Z"
                fill="white"
              />
              <path
                id="Vector_17"
                d="M106.61 102.88C107.69 105.45 108.06 108.28 106.79 110.86C105.25 108.62 104.89 105.11 106.61 102.88Z"
                fill="#FFFCF7"
              />
            </g>
            <path
              id="Vector_18"
              d="M144.11 64.4399C144.27 67.0399 144.18 71.2299 142.39 75.8499C141.61 77.8599 140.67 79.5199 139.79 80.8399"
              stroke="white"
              stroke-width="2"
              stroke-miterlimit="10"
            />
            <path
              id="Vector_19"
              d="M141.6 80.1602C142.688 80.1602 143.57 79.2782 143.57 78.1902C143.57 77.1022 142.688 76.2202 141.6 76.2202C140.512 76.2202 139.63 77.1022 139.63 78.1902C139.63 79.2782 140.512 80.1602 141.6 80.1602Z"
              fill="white"
            />
            <g id="Group_4">
              <path
                id="Vector_20"
                d="M136.6 98.1804C135.4 95.4304 134.62 91.1004 136.69 85.1104L145.23 86.1104C145.23 86.1104 146.29 92.9203 141.98 98.7803C140.55 100.73 137.56 100.4 136.6 98.1804Z"
                fill="#F8B000"
              >
                <animate
                  attributeName="opacity"
                  values="1;0.3;1"
                  begin="0s"
                  dur="1s"
                  repeatCount="indefinite"
                  fill="freeze"
                  calcMode="linear"
                  keyTimes="0;0.5;1"
                />
              </path>
              <path
                id="Vector_21"
                d="M145.23 86.1102L136.69 85.1102L137.11 81.5602C137.39 79.2002 139.52 77.5202 141.88 77.7902C144.24 78.0702 145.92 80.2002 145.65 82.5602L145.23 86.1102Z"
                fill="white"
              />
              <path
                id="Vector_22"
                d="M138.13 87.71C139.21 90.28 139.58 93.11 138.31 95.69C136.77 93.45 136.41 89.94 138.13 87.71Z"
                fill="#FFFCF7"
              />
            </g>
            <path
              id="Vector_23"
              d="M278.82 15.71C278.95 17.77 278.88 21.1 277.46 24.77C276.84 26.37 276.1 27.69 275.4 28.73"
              stroke="white"
              stroke-width="2"
              stroke-miterlimit="10"
            />
            <path
              id="Vector_24"
              d="M276.82 28.1801C277.682 28.1801 278.38 27.4816 278.38 26.6201C278.38 25.7585 277.682 25.0601 276.82 25.0601C275.958 25.0601 275.26 25.7585 275.26 26.6201C275.26 27.4816 275.958 28.1801 276.82 28.1801Z"
              fill="white"
            />
            <g id="Group_5">
              <path
                id="Vector_25"
                d="M272.85 42.5099C271.9 40.3199 271.28 36.8799 272.92 32.1299L279.7 32.9199C279.7 32.9199 280.54 38.3299 277.12 42.9799C275.98 44.5299 273.61 44.2699 272.84 42.4999L272.85 42.5099Z"
                fill="#2EBF8F"
              >
                <animate
                  attributeName="opacity"
                  values="1;0.3;1"
                  begin="0s"
                  dur="1s"
                  repeatCount="indefinite"
                  fill="freeze"
                  calcMode="linear"
                  keyTimes="0;0.5;1"
                />
              </path>
              <path
                id="Vector_26"
                d="M279.71 32.92L272.93 32.13L273.26 29.31C273.48 27.44 275.18 26.1 277.05 26.32C278.92 26.54 280.26 28.24 280.04 30.11L279.71 32.93V32.92Z"
                fill="white"
              />
              <path
                id="Vector_27"
                d="M274.07 34.1899C275.22 36.1799 275.5 38.5299 274.21 40.5299C272.69 38.7899 272.42 35.9299 274.07 34.1899Z"
                fill="#FFFCF7"
              />
            </g>
            <path
              id="Vector_28"
              d="M254.93 38.2998C252.6 42.3498 252.72 44.8998 253.35 46.5198C254.03 48.2698 255.26 48.8198 255.65 50.6098C256.16 52.9698 254.73 55.3098 253.35 56.9898"
              stroke="white"
              stroke-width="2"
              stroke-miterlimit="10"
            />
            <g id="Group_6">
              <g id="Group_7">
                <path
                  id="Vector_29"
                  d="M35.6399 145.2C34.4599 144.02 34.1399 142.16 34.9699 140.62C40.5899 130.17 46.4099 119.37 47.8899 107.69C48.0499 106.43 47.6999 105.68 47.5799 105.62C47.0999 105.38 46.0999 105.17 45.6899 105.17C42.1299 106.09 40.3599 109.95 39.5099 113.05C38.9399 115.11 36.7999 116.32 34.7399 115.75C32.6799 115.18 31.4699 113.04 32.0399 110.98C34.0499 103.73 38.2899 98.98 43.9799 97.61C46.3899 97.03 49.4999 97.92 50.9999 98.66C54.3999 100.33 56.1599 104.16 55.5899 108.66C53.9299 121.77 47.4899 133.74 41.8099 144.29C40.7999 146.18 38.4399 146.88 36.5599 145.87C36.2199 145.69 35.9199 145.46 35.6599 145.2H35.6399Z"
                  fill="#FFE4C7"
                />
                <g id="Group_8">
                  <path
                    id="Vector_30"
                    d="M31.9999 111.12C31.5199 113.14 32.7099 115.19 34.7299 115.75C36.4799 116.24 38.2899 115.43 39.1399 113.92C36.9599 112.68 34.5299 111.32 31.9999 111.12Z"
                    fill="#DE2D35"
                  />
                  <path
                    id="Vector_31"
                    d="M40.6499 108.95C39.9699 106.44 38.1199 104.18 35.6499 103.3C34.7899 104.46 34.0199 105.76 33.3799 107.22C35.9099 107.64 38.3599 108.87 40.5799 110.11C40.6799 109.9 40.7799 109.7 40.8799 109.5C40.7899 109.34 40.7099 109.16 40.6499 108.96V108.95Z"
                    fill="#DE2D35"
                  />
                  <path
                    id="Vector_32"
                    d="M45.5799 97.4299C45.0299 97.4299 44.4799 97.4899 43.9699 97.6099C41.9999 98.0799 40.1999 98.9699 38.6099 100.22C40.9099 101.5 42.7499 103.59 43.8499 105.99C44.1099 105.82 44.3799 105.67 44.6599 105.54C45.7699 102.97 46.2399 100.19 45.5899 97.4199L45.5799 97.4299Z"
                    fill="#DE2D35"
                  />
                  <path
                    id="Vector_33"
                    d="M54.8499 102.77C54.0599 100.96 52.7499 99.5199 50.9999 98.6599C50.6699 98.4999 50.2599 98.3299 49.7999 98.1699C50.1999 101.62 49.4099 105.03 47.8699 108.18C50.5999 106.9 53.0499 105.21 54.8499 102.77Z"
                    fill="#DE2D35"
                  />
                  <path
                    id="Vector_34"
                    d="M54.86 112.98C55.15 111.56 55.4 110.12 55.58 108.67C55.62 108.39 55.64 108.12 55.66 107.85C53.18 110.1 50.15 111.69 46.92 112.93C46.71 113.83 46.47 114.72 46.22 115.6C49.16 114.92 52.14 114.22 54.86 112.98Z"
                    fill="#DE2D35"
                  />
                  <path
                    id="Vector_35"
                    d="M47.7498 132.8C48.5098 131.22 49.2598 129.61 49.9598 127.97C46.9498 128.65 43.8198 128.96 40.8798 129.18C40.1298 130.74 39.3498 132.28 38.5598 133.81C41.6398 133.78 44.8098 133.6 47.7398 132.79L47.7498 132.8Z"
                    fill="#DE2D35"
                  />
                  <path
                    id="Vector_36"
                    d="M34.5998 143.28C37.3598 143.25 40.1198 143.12 42.7798 142.48C43.6698 140.82 44.5698 139.12 45.4698 137.39C42.4798 137.82 39.3798 137.86 36.4598 137.86C35.9698 138.78 35.4698 139.7 34.9798 140.62C34.5198 141.47 34.4198 142.41 34.6098 143.28H34.5998Z"
                    fill="#DE2D35"
                  />
                  <path
                    id="Vector_37"
                    d="M51.8298 123.33C52.5198 121.48 53.1498 119.59 53.6998 117.68C50.8098 118.67 47.7798 119.33 44.7798 120.07C44.1798 121.73 43.5098 123.37 42.8098 125C45.7998 124.74 48.9798 124.3 51.8398 123.32L51.8298 123.33Z"
                    fill="#DE2D35"
                  />
                </g>
              </g>
              <g id="Group_9">
                <path
                  id="Vector_38"
                  d="M26.3599 135.47C27.5399 136.65 29.3999 136.97 30.9399 136.14C41.3799 130.51 52.1799 124.69 63.8599 123.2C65.1199 123.04 65.8699 123.39 65.9299 123.51C66.1699 123.99 66.3799 124.99 66.3799 125.4C65.4599 128.96 61.5999 130.73 58.4999 131.59C56.4399 132.16 55.2299 134.3 55.7999 136.36C56.3699 138.42 58.5099 139.63 60.5699 139.06C67.8199 137.04 72.5699 132.8 73.9299 127.11C74.5099 124.7 73.6199 121.59 72.8799 120.09C71.2099 116.69 67.3799 114.93 62.8699 115.51C49.7599 117.18 37.7999 123.63 27.2499 129.31C25.3699 130.33 24.6599 132.68 25.6799 134.56C25.8599 134.9 26.0899 135.2 26.3499 135.46L26.3599 135.47Z"
                  fill="#FFE4C7"
                />
                <g id="Group_10">
                  <path
                    id="Vector_39"
                    d="M60.4398 139.1C58.4198 139.58 56.3698 138.39 55.8098 136.37C55.3198 134.62 56.1198 132.81 57.6398 131.96C58.8798 134.14 60.2398 136.56 60.4398 139.1Z"
                    fill="#DE2D35"
                  />
                  <path
                    id="Vector_40"
                    d="M62.5997 130.44C65.1197 131.12 67.3697 132.97 68.2597 135.44C67.0997 136.3 65.7997 137.07 64.3397 137.72C63.9097 135.19 62.6897 132.74 61.4497 130.52C61.6497 130.42 61.8597 130.32 62.0597 130.22C62.2197 130.31 62.3997 130.39 62.5997 130.45V130.44Z"
                    fill="#DE2D35"
                  />
                  <path
                    id="Vector_41"
                    d="M74.1198 125.5C74.1198 126.05 74.0598 126.6 73.9398 127.11C73.4698 129.08 72.5798 130.88 71.3298 132.47C70.0498 130.17 67.9598 128.33 65.5498 127.24C65.7198 126.98 65.8698 126.71 65.9998 126.43C68.5598 125.32 71.3398 124.85 74.1198 125.49V125.5Z"
                    fill="#DE2D35"
                  />
                  <path
                    id="Vector_42"
                    d="M68.7799 116.24C70.5899 117.03 72.0299 118.34 72.8899 120.09C73.0499 120.42 73.2199 120.83 73.3799 121.29C69.9299 120.89 66.5199 121.69 63.3699 123.22C64.6499 120.49 66.3299 118.04 68.7799 116.23V116.24Z"
                    fill="#DE2D35"
                  />
                  <path
                    id="Vector_43"
                    d="M58.5697 116.24C59.9897 115.95 61.4297 115.7 62.8797 115.51C63.1597 115.47 63.4297 115.45 63.6997 115.43C61.4497 117.91 59.8697 120.94 58.6197 124.17C57.7197 124.38 56.8297 124.62 55.9497 124.87C56.6197 121.93 57.3297 118.94 58.5597 116.23L58.5697 116.24Z"
                    fill="#DE2D35"
                  />
                  <path
                    id="Vector_44"
                    d="M38.7497 123.35C40.3297 122.59 41.9397 121.84 43.5697 121.14C42.8897 124.15 42.5797 127.28 42.3597 130.22C40.7997 130.97 39.2597 131.75 37.7297 132.54C37.7597 129.46 37.9397 126.29 38.7497 123.36V123.35Z"
                    fill="#DE2D35"
                  />
                  <path
                    id="Vector_45"
                    d="M28.2798 136.51C28.3098 133.75 28.4398 130.99 29.0798 128.33C30.7398 127.44 32.4398 126.53 34.1698 125.64C33.7398 128.63 33.6998 131.73 33.6998 134.65C32.7798 135.14 31.8598 135.64 30.9398 136.13C30.0898 136.59 29.1498 136.69 28.2798 136.5V136.51Z"
                    fill="#DE2D35"
                  />
                  <path
                    id="Vector_46"
                    d="M48.2198 119.27C50.0698 118.58 51.9598 117.95 53.8698 117.4C52.8898 120.29 52.2298 123.32 51.4798 126.33C49.8198 126.93 48.1798 127.6 46.5498 128.3C46.8098 125.31 47.2498 122.13 48.2198 119.27Z"
                    fill="#DE2D35"
                  />
                </g>
              </g>
              <g id="Group_11">
                <path
                  id="Vector_47"
                  d="M46.7699 126.56C47.9999 123.53 48.0999 120.16 46.9399 117.15C46.6099 116.17 45.9999 115.2 45.3099 115.37C44.9899 115.41 44.6599 115.73 44.4299 116.14C43.7299 117.5 43.7399 119.17 43.8099 120.69C43.9699 122.81 44.6999 124.9 45.8899 126.75C43.2599 123.91 41.9999 119.32 43.5799 115.66C44.2599 114.25 46.0499 113.86 47.0299 115.23C49.1299 118.61 48.8399 123.26 46.7699 126.57V126.56Z"
                  fill="white"
                />
                <path
                  id="Vector_48"
                  d="M47.3599 126.42C48.7499 124.16 51.3699 121.51 54.3899 122.57C56.5599 123.34 57.3799 126.27 55.4799 127.77C54.6899 128.44 53.7299 128.8 52.7699 128.91C50.8399 129.17 48.8599 128.43 47.6199 127.07C49.1099 128.13 50.9699 128.48 52.6399 128.14C55.3299 127.7 56.9099 124.95 54.0399 123.46C51.4499 122.51 49.1699 124.66 47.3599 126.43V126.42Z"
                  fill="white"
                />
                <path
                  id="Vector_49"
                  d="M42.72 121.2C44.59 124.34 46.75 126.81 49.6 129.1C46.09 128.12 43.21 124.81 42.72 121.2Z"
                  fill="white"
                />
                <path
                  id="Vector_50"
                  d="M46.7698 127.24C46.4998 132.48 46.0298 138.29 49.1898 142.76C51.2998 145.95 55.8998 147.74 59.3698 145.71C59.8998 145.39 60.4098 144.88 60.3598 144.27C60.3098 143.7 59.3598 143.14 58.9498 143.73C59.3398 143.01 60.4798 143.51 60.6198 144.22C60.7698 145.02 60.1998 145.69 59.6498 146.11C55.9698 148.68 50.7198 146.88 48.3698 143.33C45.0598 138.59 45.6998 132.57 46.7698 127.24Z"
                  fill="white"
                />
                <path
                  id="Vector_51"
                  d="M47.0999 127.23C39.9099 128.04 35.3599 120.74 29.0099 119.03C27.8799 118.85 26.8799 119.85 25.9799 120.79C25.0999 121.75 24.3799 122.9 24.2399 124.18C24.0799 125.44 24.5499 126.87 25.7199 127.61C24.4299 127.07 23.7299 125.56 23.7499 124.15C23.8499 121.73 26.4299 117.9 29.0999 118.08C35.8799 119.58 39.8499 127.03 47.0999 127.22V127.23Z"
                  fill="white"
                />
              </g>
            </g>
            <g id="Group_12">
              <g id="Group_13">
                <path
                  id="Vector_52"
                  d="M183.4 106.45C183.4 106.45 206.09 109.4 216.85 102.73C216.85 102.73 197.46 98.6698 183.4 106.45Z"
                  fill="#123342"
                />
                <g id="Group_14">
                  <path
                    id="Vector_53"
                    d="M185.95 101.54C195.45 99.1802 205.19 97.7502 214.97 97.2802C211.84 85.8002 207.04 74.7802 200.78 64.6602C198.25 70.6602 194.12 75.8102 190.66 81.3302C187.2 86.8502 184.33 93.1202 184.78 99.6102"
                    fill="#DE2D35"
                  />
                  <path
                    id="Vector_54"
                    d="M186.55 103.72C195.87 101.42 205.37 100.02 214.97 99.5501C216.42 99.4801 217.55 98.1701 217.14 96.7001C213.94 85.0401 209.07 73.8401 202.72 63.5401C201.92 62.2501 199.53 61.9101 198.83 63.5401C193.63 75.6301 181.69 85.4301 182.52 99.6301C182.69 102.51 187.19 102.53 187.02 99.6301C186.25 86.5301 197.89 77.0301 202.71 65.8201H198.82C204.98 75.8101 209.67 86.5901 212.78 97.9001L214.95 95.0501C204.97 95.5401 195.04 96.9901 185.34 99.3901C182.53 100.08 183.72 104.43 186.54 103.73L186.55 103.72Z"
                    fill="#DE2D35"
                  />
                </g>
                <g id="Group_15">
                  <path
                    id="Vector_55"
                    d="M200.18 65.09C197.73 63.83 195.62 61.9 194.16 59.56C193.84 59.05 193.62 58.23 194.16 57.96C194.5 57.79 194.9 58 195.22 58.21C196.98 59.39 198.46 60.98 199.51 62.83C199.2 61.2 199.61 59.44 200.61 58.11C200.9 57.72 201.34 57.34 201.81 57.44C202.6 57.61 202.54 58.75 202.29 59.52C201.84 60.88 201.38 62.25 200.93 63.61C202.23 63.17 203.53 62.73 204.83 62.29C205.48 62.07 206.41 61.97 206.66 62.61C206.89 63.21 206.23 63.76 205.65 64.03C204.33 64.66 202.93 65.1 201.49 65.34"
                    fill="#FFE4C7"
                  />
                  <path
                    id="Vector_56"
                    d="M200.75 64.1099C198.53 62.9499 196.59 61.2699 195.24 59.1599C195.12 58.9799 195.07 58.7699 194.97 58.5999C194.93 58.5499 194.93 58.5199 194.96 58.5199C195.21 58.4699 195.03 58.6399 194.41 59.0199C194.45 59.0799 194.6 59.1399 194.66 59.1699C195.18 59.5099 195.66 59.9099 196.12 60.3299C197.08 61.2299 197.89 62.2399 198.54 63.3799C199.19 64.5199 200.81 63.7199 200.6 62.5099C200.45 61.6599 200.56 60.7699 200.85 59.9599C200.98 59.6099 201.15 59.2899 201.35 58.9799C201.41 58.8899 201.69 58.6199 201.71 58.5399L201.76 58.5099C201.58 58.5499 201.43 58.4899 201.33 58.3499C201.26 58.3999 201.49 57.8599 201.33 58.4499C201.3 58.5699 201.32 58.7099 201.3 58.8399C201.22 59.2699 201.04 59.6899 200.9 60.1099C200.55 61.1699 200.2 62.2299 199.84 63.2899C199.58 64.0799 200.43 64.9399 201.23 64.6799C202.15 64.3699 203.06 64.0599 203.98 63.7499C204.41 63.6099 204.84 63.4399 205.27 63.3199C205.37 63.2899 205.49 63.2599 205.59 63.2399C205.69 63.2399 205.79 63.2399 205.9 63.2399C205.87 63.2699 205.83 63.2599 205.8 63.2099C205.6 63.1299 205.54 62.9399 205.63 62.6599C205.61 62.6999 205.58 62.7399 205.53 62.7699C205.42 62.7999 205.27 62.9499 205.15 63.0099C204.77 63.2099 204.36 63.3699 203.96 63.5099C203.06 63.8399 202.13 64.0799 201.18 64.2499C200.58 64.3599 200.24 65.0899 200.39 65.6399C200.56 66.2699 201.17 66.5299 201.78 66.4299C203.17 66.1799 204.5 65.7599 205.79 65.1899C206.97 64.6699 208.25 63.6099 207.68 62.1699C207.21 60.9799 205.83 60.8499 204.74 61.1299C203.35 61.4899 201.98 62.0499 200.62 62.5099L202.01 63.8999C202.49 62.4399 203.14 60.9499 203.47 59.4499C203.73 58.2499 203.51 56.6899 202.11 56.3499C200.57 55.9699 199.47 57.5399 198.94 58.7499C198.32 60.1499 198.17 61.6299 198.43 63.1399L200.49 62.2699C199.59 60.7099 198.42 59.2899 197.02 58.1599C196.32 57.5899 195.49 56.8399 194.53 56.7899C193.57 56.7399 192.73 57.5499 192.72 58.5399C192.72 59.3999 193.16 60.1399 193.64 60.8199C194.16 61.5599 194.73 62.2599 195.36 62.9099C196.59 64.1799 198.05 65.2599 199.62 66.0799C200.9 66.7499 202.04 64.8099 200.76 64.1399L200.75 64.1099Z"
                    fill="#FFE4C7"
                  />
                </g>
                <path
                  id="Vector_57"
                  d="M183.4 106.45C183.4 106.45 179.19 96.5 182.79 94.93C182.79 94.93 210.28 90.22 215.43 93.67C215.43 93.67 218.75 97.36 216.85 102.73C216.85 102.73 194.36 101.08 183.4 106.45Z"
                  fill="#FFE4C7"
                  stroke="#FFE4C7"
                  stroke-width="2"
                  stroke-miterlimit="10"
                />
                <g id="Group_16">
                  <path
                    id="Vector_58"
                    d="M186.05 96.1196C187.28 97.9696 187.66 100.11 187.11 102.27C185.3 100.84 184.83 98.0696 186.05 96.1196Z"
                    fill="#123342"
                  />
                  <path
                    id="Vector_59"
                    d="M192.62 98.1499C193.85 98.7299 193.95 100.12 192.82 100.86C191.59 100.29 191.49 98.8899 192.62 98.1499Z"
                    fill="#123342"
                  />
                  <path
                    id="Vector_60"
                    d="M200.07 95.4297C201.31 96.9797 201.36 99.1797 200.16 100.77C198.91 99.2197 198.88 97.0197 200.07 95.4297Z"
                    fill="#123342"
                  />
                  <path
                    id="Vector_61"
                    d="M206.23 94.3198C208.39 95.4798 209.23 98.5498 207.95 100.65C206.73 98.6798 206.18 96.6398 206.23 94.3198Z"
                    fill="#123342"
                  />
                  <path
                    id="Vector_62"
                    d="M211.07 94.2598C212.94 94.7898 213.87 96.9698 213.49 98.7698C213.35 99.3698 213.09 99.9598 212.59 100.4C212.35 99.7798 212.22 99.2698 212.07 98.7798C211.69 97.3098 211.28 95.8098 211.06 94.2598H211.07Z"
                    fill="#123342"
                  />
                </g>
              </g>
              <g id="Group_17">
                <path
                  id="Vector_63"
                  d="M189.31 90.1997C188.33 89.0097 188.66 87.3597 190.04 86.6597C191.03 87.8497 190.68 89.4997 189.31 90.1997Z"
                  fill="#FFE4C7"
                />
                <path
                  id="Vector_64"
                  d="M193.06 81.7397C192.5 80.3897 193.32 79.0497 194.79 78.9697C195.36 80.3197 194.52 81.6497 193.06 81.7397Z"
                  fill="#FFE4C7"
                />
                <path
                  id="Vector_65"
                  d="M197.96 73.7597C197.25 72.6897 197.87 71.7197 199.14 71.9297C199.86 72.9997 199.23 73.9697 197.96 73.7597Z"
                  fill="#FFE4C7"
                />
                <path
                  id="Vector_66"
                  d="M199 89.8296C197.79 88.6796 198.03 86.6896 199.48 85.8696C200.4 87.1796 200.2 88.7796 199 89.8296Z"
                  fill="#FFE4C7"
                />
                <path
                  id="Vector_67"
                  d="M200.98 79.3297C199.94 78.6297 200.15 77.7697 201.41 77.6597C202.46 78.3597 202.23 79.2097 200.98 79.3297Z"
                  fill="#FFE4C7"
                />
                <path
                  id="Vector_68"
                  d="M204.04 73.5498C205.91 73.5598 207.14 75.8698 206.1 77.4298C204.72 76.4598 204.08 75.2298 204.04 73.5498Z"
                  fill="#FFE4C7"
                />
                <path
                  id="Vector_69"
                  d="M208.23 86.3398C209.88 86.9498 210.67 88.8598 209.91 90.4498C208.37 89.6598 207.7 87.9798 208.23 86.3398Z"
                  fill="#FFE4C7"
                />
              </g>
            </g>
          </g>
        </svg>
      </div>
      <div slot="centered-chrome">
        <media-play-button>
          <svg slot="play" width="90" height="259" viewBox="0 0 90 259" fill="none" xmlns="http://www.w3.org/2000/svg">
            <g id="Group">
              <g id="Capa 2">
                <g id="Capa 1">
                  <path
                    id="wire"
                    fill-rule="evenodd"
                    clip-rule="evenodd"
                    d="M78.5023 11.8951C79.7101 7.83089 80.5625 3.84468 81.1439 0L83.1657 0C82.5708 4.0221 81.6867 8.20063 80.4195 12.4645C76.7802 24.7187 71.5704 33.0015 66.0397 40.2502C64.2498 42.596 62.4438 44.8141 60.6532 47.0133C60.1079 47.683 59.5641 48.351 59.0226 49.0203C48.4244 86.5587 52.7705 112.03 58.6414 128.301L58.6414 128.301C60.5983 133.728 63.0063 138.918 65.4168 143.979C65.7175 144.611 66.0184 145.24 66.3184 145.868L66.321 145.874C68.4186 150.263 70.4771 154.571 72.1638 158.817C76.025 168.536 78.0243 178.134 74.1119 188.125C72.6871 191.771 70.4087 194.687 68.2691 197.426C67.7208 198.128 67.1817 198.818 66.6683 199.506C64.1212 202.918 62.0735 206.406 61.9605 211.383L60.9607 211.36L61.9604 211.383C61.7792 219.328 66.2795 225.964 70.0544 230.293L68.5471 231.607C64.6819 227.175 59.7622 220.052 59.961 211.337C60.088 205.744 62.4252 201.847 65.0656 198.309C65.6324 197.55 66.2074 196.813 66.7774 196.082L66.7779 196.081C68.8938 193.368 70.9416 190.743 72.2493 187.396L72.2496 187.395C75.8871 178.106 74.0964 169.099 70.3051 159.555C68.6454 155.378 66.6188 151.136 64.5181 146.74L64.518 146.74C64.217 146.109 63.9144 145.476 63.6112 144.839C61.1989 139.774 58.7532 134.507 56.7601 128.979C50.9905 112.989 46.737 88.4842 55.8815 52.9813C53.7837 55.702 51.7497 58.5377 49.835 61.6799C39.7154 78.2966 31.585 105.885 43.3415 153.249L41.4004 153.731C29.5368 105.935 37.6864 77.783 48.1268 60.6397C51.5386 55.0405 55.3869 50.3122 59.2052 45.6208C60.9753 43.446 62.7389 41.2791 64.4496 39.037C69.8814 31.9181 74.9516 23.8509 78.5023 11.8951Z"
                    fill="white"
                  >
                    <animate
                      attributeName="d"
                      values="M78.5023 11.8951C79.7101 7.83089 80.5625 3.84468 81.1439 0L83.1657 0C82.5708 4.0221 81.6867 8.20063 80.4195 12.4645C76.7802 24.7187 71.5704 33.0015 66.0397 40.2502C64.2498 42.596 62.4438 44.8141 60.6532 47.0133C60.1079 47.683 59.5641 48.351 59.0226 49.0203C48.4244 86.5587 52.7705 112.03 58.6414 128.301L58.6414 128.301C60.5983 133.728 63.0063 138.918 65.4168 143.979C65.7175 144.611 66.0184 145.24 66.3184 145.868L66.321 145.874C68.4186 150.263 70.4771 154.571 72.1638 158.817C76.025 168.536 78.0243 178.134 74.1119 188.125C72.6871 191.771 70.4087 194.687 68.2691 197.426C67.7208 198.128 67.1817 198.818 66.6683 199.506C64.1212 202.918 62.0735 206.406 61.9605 211.383L60.9607 211.36L61.9604 211.383C61.7792 219.328 66.2795 225.964 70.0544 230.293L68.5471 231.607C64.6819 227.175 59.7622 220.052 59.961 211.337C60.088 205.744 62.4252 201.847 65.0656 198.309C65.6324 197.55 66.2074 196.813 66.7774 196.082L66.7779 196.081C68.8938 193.368 70.9416 190.743 72.2493 187.396L72.2496 187.395C75.8871 178.106 74.0964 169.099 70.3051 159.555C68.6454 155.378 66.6188 151.136 64.5181 146.74L64.518 146.74C64.217 146.109 63.9144 145.476 63.6112 144.839C61.1989 139.774 58.7532 134.507 56.7601 128.979C50.9905 112.989 46.737 88.4842 55.8815 52.9813C53.7837 55.702 51.7497 58.5377 49.835 61.6799C39.7154 78.2966 31.585 105.885 43.3415 153.249L41.4004 153.731C29.5368 105.935 37.6864 77.783 48.1268 60.6397C51.5386 55.0405 55.3869 50.3122 59.2052 45.6208C60.9753 43.446 62.7389 41.2791 64.4496 39.037C69.8814 31.9181 74.9516 23.8509 78.5023 11.8951Z;M80.5023 11.8951C81.7101 7.83089 82.5625 3.84468 83.1439 0L85.1657 0C84.5708 4.0221 83.6867 8.20063 82.4195 12.4645C78.7802 24.7187 73.5704 33.0015 68.0397 40.2502C66.2498 42.596 64.4438 44.8141 62.6532 47.0133C62.1079 47.683 61.5641 48.351 61.0226 49.0203C50.4244 86.5587 54.7705 112.03 60.6414 128.301L60.6414 128.301C62.5983 133.728 65.0063 138.918 67.4168 143.979C67.7175 144.611 68.0184 145.24 68.3184 145.868L68.321 145.874C70.4186 150.263 72.4771 154.571 74.1638 158.817C78.025 168.536 80.0243 178.134 76.1119 188.125C74.6871 191.771 72.4087 194.687 70.2691 197.426C69.7208 198.128 69.1817 198.818 68.6683 199.506C66.1212 202.918 64.0735 206.406 63.9605 211.383L62.9607 211.36L63.9604 211.383C63.7792 219.328 68.2795 225.964 72.0544 230.293L70.5471 231.607C66.6819 227.175 61.7622 220.052 61.961 211.337C62.088 205.744 64.4252 201.847 67.0656 198.309C67.6324 197.55 68.2074 196.813 68.7774 196.082L68.7779 196.081C70.8938 193.368 72.9416 190.743 74.2493 187.396L74.2496 187.395C77.8871 178.106 76.0964 169.099 72.3051 159.555C70.6454 155.378 68.6188 151.136 66.5181 146.74L66.518 146.74C66.217 146.109 65.9144 145.476 65.6112 144.839C63.1989 139.774 60.7532 134.507 58.7601 128.979C52.9905 112.989 48.737 88.4842 57.8815 52.9813C55.7837 55.702 53.7497 58.5377 51.835 61.6799C41.7154 78.2966 33.585 105.885 45.3415 153.249L43.4004 153.731C31.5368 105.935 39.6864 77.783 50.1268 60.6397C53.5386 55.0405 57.3869 50.3122 61.2052 45.6208C62.9753 43.446 64.7389 41.2791 66.4496 39.037C71.8814 31.9181 76.9516 23.8509 80.5023 11.8951Z;M78.5023 11.8951C79.7101 7.83089 80.5625 3.84468 81.1439 0L83.1657 0C82.5708 4.0221 81.6867 8.20063 80.4195 12.4645C76.7802 24.7187 71.5704 33.0015 66.0397 40.2502C64.2498 42.596 62.4438 44.8141 60.6532 47.0133C60.1079 47.683 59.5641 48.351 59.0226 49.0203C48.4244 86.5587 52.7705 112.03 58.6414 128.301L58.6414 128.301C60.5983 133.728 63.0063 138.918 65.4168 143.979C65.7175 144.611 66.0184 145.24 66.3184 145.868L66.321 145.874C68.4186 150.263 70.4771 154.571 72.1638 158.817C76.025 168.536 78.0243 178.134 74.1119 188.125C72.6871 191.771 70.4087 194.687 68.2691 197.426C67.7208 198.128 67.1817 198.818 66.6683 199.506C64.1212 202.918 62.0735 206.406 61.9605 211.383L60.9607 211.36L61.9604 211.383C61.7792 219.328 66.2795 225.964 70.0544 230.293L68.5471 231.607C64.6819 227.175 59.7622 220.052 59.961 211.337C60.088 205.744 62.4252 201.847 65.0656 198.309C65.6324 197.55 66.2074 196.813 66.7774 196.082L66.7779 196.081C68.8938 193.368 70.9416 190.743 72.2493 187.396L72.2496 187.395C75.8871 178.106 74.0964 169.099 70.3051 159.555C68.6454 155.378 66.6188 151.136 64.5181 146.74L64.518 146.74C64.217 146.109 63.9144 145.476 63.6112 144.839C61.1989 139.774 58.7532 134.507 56.7601 128.979C50.9905 112.989 46.737 88.4842 55.8815 52.9813C53.7837 55.702 51.7497 58.5377 49.835 61.6799C39.7154 78.2966 31.585 105.885 43.3415 153.249L41.4004 153.731C29.5368 105.935 37.6864 77.783 48.1268 60.6397C51.5386 55.0405 55.3869 50.3122 59.2052 45.6208C60.9753 43.446 62.7389 41.2791 64.4496 39.037C69.8814 31.9181 74.9516 23.8509 78.5023 11.8951Z"
                      begin="0s"
                      dur="1.6s"
                      repeatCount="indefinite"
                      fill="freeze"
                      calcMode="linear"
                      keyTimes="0;0.5;1"
                    />
                  </path>
                  <g id="Group_2">
                    <g id="Group_3">
                      <g id="Group_4">
                        <path
                          id="Vector"
                          d="M67.2034 222.486C79.5753 210.114 79.5752 190.056 67.2034 177.684C54.8316 165.312 34.773 165.312 22.4011 177.684C10.0293 190.056 10.0293 210.114 22.4011 222.486C34.7729 234.858 54.8316 234.858 67.2034 222.486Z"
                          fill="#2EBF8F"
                        >
                          <animate
                            attributeName="d"
                            values="M67.2034 222.486C79.5753 210.114 79.5752 190.056 67.2034 177.684C54.8316 165.312 34.773 165.312 22.4011 177.684C10.0293 190.056 10.0293 210.114 22.4011 222.486C34.7729 234.858 54.8316 234.858 67.2034 222.486Z;M68.3373 223.271C81.1432 211.349 81.8598 191.303 69.9378 178.497C58.0159 165.691 37.97 164.975 25.1641 176.897C12.3583 188.819 11.6417 208.865 23.5636 221.67C35.4856 234.476 55.5315 235.193 68.3373 223.271Z;M67.2034 222.486C79.5753 210.114 79.5752 190.056 67.2034 177.684C54.8316 165.312 34.773 165.312 22.4011 177.684C10.0293 190.056 10.0293 210.114 22.4011 222.486C34.7729 234.858 54.8316 234.858 67.2034 222.486Z"
                            begin="0s"
                            dur="1.6s"
                            repeatCount="indefinite"
                            fill="freeze"
                            calcMode="linear"
                            keyTimes="0;0.5;1"
                          />
                        </path>
                        <g id="Group_5">
                          <path
                            id="Vector_2"
                            d="M24.3608 175.88C16.9908 182.11 12.5508 191.61 13.1708 201.98C13.5608 208.58 15.9508 214.58 19.7108 219.45C15.7208 205.18 17.8308 189.76 24.3608 175.88Z"
                            fill="#FFE4C7"
                          >
                            <animate
                              attributeName="d"
                              values="M24.3608 175.88C16.9908 182.11 12.5508 191.61 13.1708 201.98C13.5608 208.58 15.9508 214.58 19.7108 219.45C15.7208 205.18 17.8308 189.76 24.3608 175.88Z;M27.1873 175.164C19.5995 181.127 14.8229 190.462 15.0721 200.848C15.2261 207.457 17.4002 213.539 20.9838 218.54C17.5061 204.137 20.1656 188.802 27.1873 175.164Z;M24.3608 175.88C16.9908 182.11 12.5508 191.61 13.1708 201.98C13.5608 208.58 15.9508 214.58 19.7108 219.45C15.7208 205.18 17.8308 189.76 24.3608 175.88Z"
                              begin="0s"
                              dur="1.6s"
                              repeatCount="indefinite"
                              fill="freeze"
                              calcMode="linear"
                              keyTimes="0;0.5;1"
                            />
                          </path>
                          <path
                            id="Vector_3"
                            d="M51.5907 231.01C52.1507 230.09 52.6707 229.17 53.1507 228.24C62.7307 209.72 57.5107 188.17 51.9507 173.78C51.2207 172.56 50.4907 171.34 49.7707 170.11C46.5807 170.24 43.4007 170.38 40.2107 170.51C37.5607 173.88 29.4107 185.13 29.3507 201.64C29.2907 216.91 36.2007 227.61 38.7707 231.23C40.2907 231.59 42.2307 231.9 44.4707 231.92C47.3707 231.95 49.8107 231.49 51.5807 231.01L51.5907 231.01Z"
                            fill="#2EBF8F"
                          >
                            <animate
                              attributeName="d"
                              values="M51.5907 231.01C52.1507 230.09 52.6707 229.17 53.1507 228.24C62.7307 209.72 57.5107 188.17 51.9507 173.78C51.2207 172.56 50.4907 171.34 49.7707 170.11C46.5807 170.24 43.4007 170.38 40.2107 170.51C37.5607 173.88 29.4107 185.13 29.3507 201.64C29.2907 216.91 36.2007 227.61 38.7707 231.23C40.2907 231.59 42.2307 231.9 44.4707 231.92C47.3707 231.95 49.8107 231.49 51.5807 231.01L51.5907 231.01Z;M52.4305 231.232C53.023 230.332 53.5756 229.432 54.0885 228.519C64.324 210.353 59.8771 188.631 54.8347 174.051C54.1488 172.806 53.4628 171.561 52.7872 170.306C49.5946 170.322 46.4117 170.348 43.2191 170.364C40.4504 173.637 31.9037 184.589 31.2539 201.086C30.6484 216.344 37.1718 227.284 39.6108 230.994C41.117 231.408 43.0447 231.787 45.2825 231.887C48.1796 232.02 50.6345 231.648 52.4205 231.231L52.4305 231.232Z;M51.5907 231.01C52.1507 230.09 52.6707 229.17 53.1507 228.24C62.7307 209.72 57.5107 188.17 51.9507 173.78C51.2207 172.56 50.4907 171.34 49.7707 170.11C46.5807 170.24 43.4007 170.38 40.2107 170.51C37.5607 173.88 29.4107 185.13 29.3507 201.64C29.2907 216.91 36.2007 227.61 38.7707 231.23C40.2907 231.59 42.2307 231.9 44.4707 231.92C47.3707 231.95 49.8107 231.49 51.5807 231.01L51.5907 231.01Z"
                              begin="0s"
                              dur="1.6s"
                              repeatCount="indefinite"
                              fill="freeze"
                              calcMode="linear"
                              keyTimes="0;0.5;1"
                            />
                          </path>
                          <path
                            id="Vector_4"
                            d="M65.9407 176.5C71.3607 191.37 71.5907 207.28 67.3007 222.38C73.4107 216.2 76.9807 207.55 76.4207 198.2C75.9007 189.52 71.9407 181.88 65.9407 176.5Z"
                            fill="#FFE4C7"
                          >
                            <animate
                              attributeName="d"
                              values="M65.9407 176.5C71.3607 191.37 71.5907 207.28 67.3007 222.38C73.4107 216.2 76.9807 207.55 76.4207 198.2C75.9007 189.52 71.9407 181.88 65.9407 176.5Z;M68.7185 177.269C73.6038 192.323 73.2653 208.231 68.4386 223.168C74.7655 217.211 78.6422 208.694 78.4166 199.33C78.207 190.637 74.5225 182.86 68.7185 177.269Z;M65.9407 176.5C71.3607 191.37 71.5907 207.28 67.3007 222.38C73.4107 216.2 76.9807 207.55 76.4207 198.2C75.9007 189.52 71.9407 181.88 65.9407 176.5Z"
                              begin="0s"
                              dur="1.6s"
                              repeatCount="indefinite"
                              fill="freeze"
                              calcMode="linear"
                              keyTimes="0;0.5;1"
                            />
                          </path>
                        </g>
                        <g id="Group_6">
                          <path
                            id="Vector_5"
                            d="M38.243 159.225L47.7062 158.659C50.8605 158.471 53.5687 160.873 53.7572 164.028L54.0966 169.708L33.2239 170.955L32.8844 165.275C32.6959 162.121 35.0987 159.413 38.253 159.224L38.243 159.225Z"
                            fill="#F8B000"
                            stroke="#F8B000"
                            stroke-width="0.7"
                            stroke-miterlimit="10"
                          >
                            <animate
                              attributeName="d"
                              values="M38.243 159.225L47.7062 158.659C50.8605 158.471 53.5687 160.873 53.7572 164.028L54.0966 169.708L33.2239 170.955L32.8844 165.275C32.6959 162.121 35.0987 159.413 38.253 159.224L38.243 159.225Z;M41.6554 159.016L51.1327 158.789C54.2918 158.713 56.9123 161.211 56.9881 164.37L57.1244 170.059L36.2204 170.56L36.0841 164.871C36.0084 161.712 38.5063 159.092 41.6654 159.016L41.6554 159.016Z;M38.243 159.225L47.7062 158.659C50.8605 158.471 53.5687 160.873 53.7572 164.028L54.0966 169.708L33.2239 170.955L32.8844 165.275C32.6959 162.121 35.0987 159.413 38.253 159.224L38.243 159.225Z"
                              begin="0s"
                              dur="1.6s"
                              repeatCount="indefinite"
                              fill="freeze"
                              calcMode="linear"
                              keyTimes="0;0.5;1"
                            />
                          </path>
                          <path
                            id="Vector_6"
                            d="M40.6808 160.09C40.1808 158.87 39.5808 157.5 40.0108 156.18C39.9408 156.39 40.0608 156.08 40.1008 156.03C40.1308 155.98 40.2608 155.8 40.1508 155.94C40.2308 155.84 40.3208 155.74 40.4208 155.65C40.4608 155.61 40.7008 155.4 40.6008 155.48C40.8008 155.33 41.0108 155.19 41.2308 155.07C41.3408 155.01 41.4608 154.95 41.5708 154.9C41.7508 154.82 41.6408 154.86 41.8308 154.79C42.0708 154.71 42.3108 154.63 42.5608 154.58C42.6808 154.55 42.8008 154.53 42.9308 154.51C42.7608 154.54 43.0908 154.5 43.1608 154.5C43.2708 154.5 43.3908 154.5 43.5008 154.5C43.5908 154.5 43.8308 154.55 43.6308 154.5C43.9808 154.58 44.0008 154.58 44.2508 154.72C44.2708 154.73 44.4408 154.86 44.3508 154.79C44.2708 154.73 44.4008 154.84 44.4008 154.84C44.4908 154.92 44.5708 155.01 44.6508 155.1C44.7608 155.23 44.5808 154.99 44.6708 155.14C44.7008 155.18 44.7308 155.23 44.7608 155.27C44.8408 155.39 44.9108 155.52 44.9708 155.65C45.1108 155.92 45.1108 155.94 45.2208 156.23C45.3308 156.52 45.4308 156.83 45.5308 157.12C45.9808 158.51 45.8708 159.99 45.2908 161.33C45.0708 161.85 45.1308 162.46 45.6708 162.77C46.1108 163.03 46.8808 162.92 47.1108 162.39C47.8308 160.72 48.1508 158.89 47.7108 157.09C47.5308 156.34 47.2408 155.59 46.9308 154.89C46.6708 154.3 46.3108 153.72 45.8208 153.29C44.6808 152.31 43.1608 152.24 41.7608 152.62C40.4408 152.98 39.1108 153.73 38.3408 154.89C37.1908 156.64 37.9408 158.9 38.6608 160.65C38.8808 161.18 39.3608 161.55 39.9508 161.38C40.4508 161.24 40.9008 160.62 40.6808 160.09Z"
                            fill="#F8B000"
                          >
                            <animate
                              attributeName="d"
                              values="M40.6808 160.09C40.1808 158.87 39.5808 157.5 40.0108 156.18C39.9408 156.39 40.0608 156.08 40.1008 156.03C40.1308 155.98 40.2608 155.8 40.1508 155.94C40.2308 155.84 40.3208 155.74 40.4208 155.65C40.4608 155.61 40.7008 155.4 40.6008 155.48C40.8008 155.33 41.0108 155.19 41.2308 155.07C41.3408 155.01 41.4608 154.95 41.5708 154.9C41.7508 154.82 41.6408 154.86 41.8308 154.79C42.0708 154.71 42.3108 154.63 42.5608 154.58C42.6808 154.55 42.8008 154.53 42.9308 154.51C42.7608 154.54 43.0908 154.5 43.1608 154.5C43.2708 154.5 43.3908 154.5 43.5008 154.5C43.5908 154.5 43.8308 154.55 43.6308 154.5C43.9808 154.58 44.0008 154.58 44.2508 154.72C44.2708 154.73 44.4408 154.86 44.3508 154.79C44.2708 154.73 44.4008 154.84 44.4008 154.84C44.4908 154.92 44.5708 155.01 44.6508 155.1C44.7608 155.23 44.5808 154.99 44.6708 155.14C44.7008 155.18 44.7308 155.23 44.7608 155.27C44.8408 155.39 44.9108 155.52 44.9708 155.65C45.1108 155.92 45.1108 155.94 45.2208 156.23C45.3308 156.52 45.4308 156.83 45.5308 157.12C45.9808 158.51 45.8708 159.99 45.2908 161.33C45.0708 161.85 45.1308 162.46 45.6708 162.77C46.1108 163.03 46.8808 162.92 47.1108 162.39C47.8308 160.72 48.1508 158.89 47.7108 157.09C47.5308 156.34 47.2408 155.59 46.9308 154.89C46.6708 154.3 46.3108 153.72 45.8208 153.29C44.6808 152.31 43.1608 152.24 41.7608 152.62C40.4408 152.98 39.1108 153.73 38.3408 154.89C37.1908 156.64 37.9408 158.9 38.6608 160.65C38.8808 161.18 39.3608 161.55 39.9508 161.38C40.4508 161.24 40.9008 160.62 40.6808 160.09Z;M44.0607 159.967C43.6046 158.73 43.0539 157.34 43.5308 156.036C43.4533 156.243 43.5843 155.938 43.6261 155.889C43.6579 155.84 43.7942 155.665 43.6793 155.801C43.7628 155.704 43.8563 155.607 43.9595 155.521C44.0009 155.482 44.2482 155.281 44.1454 155.358C44.3506 155.215 44.5655 155.082 44.7897 154.97C44.9017 154.914 45.0238 154.859 45.1355 154.813C45.3183 154.739 45.2069 154.775 45.3993 154.712C45.642 154.641 45.8847 154.569 46.1363 154.528C46.2573 154.502 46.3779 154.487 46.5086 154.471C46.3376 154.495 46.6688 154.467 46.7388 154.47C46.8487 154.474 46.9686 154.478 47.0786 154.482C47.1685 154.485 47.4066 154.544 47.2085 154.486C47.5554 154.579 47.5754 154.58 47.8202 154.728C47.8399 154.739 48.0051 154.875 47.9177 154.802C47.8399 154.739 47.9659 154.854 47.9659 154.854C48.0529 154.937 48.1297 155.03 48.2064 155.122C48.3117 155.256 48.1404 155.01 48.225 155.163C48.2535 155.204 48.2817 155.255 48.3103 155.296C48.3859 155.419 48.4512 155.552 48.5066 155.684C48.6368 155.958 48.6361 155.978 48.7357 156.272C48.8352 156.566 48.9241 156.879 49.0137 157.173C49.4137 158.578 49.2509 160.053 48.6234 161.371C48.385 161.883 48.4232 162.495 48.9518 162.824C49.3822 163.1 50.1556 163.017 50.4044 162.496C51.1836 160.853 51.5688 159.035 51.1934 157.221C51.0403 156.465 50.7772 155.705 50.4925 154.994C50.2537 154.395 49.9146 153.803 49.4403 153.355C48.3361 152.335 46.8195 152.211 45.4068 152.541C44.0748 152.853 42.7189 153.555 41.9079 154.687C40.6962 156.395 41.3649 158.68 42.022 160.455C42.2229 160.992 42.6894 161.379 43.2851 161.231C43.7897 161.109 44.2616 160.505 44.0607 159.967Z;M40.6808 160.09C40.1808 158.87 39.5808 157.5 40.0108 156.18C39.9408 156.39 40.0608 156.08 40.1008 156.03C40.1308 155.98 40.2608 155.8 40.1508 155.94C40.2308 155.84 40.3208 155.74 40.4208 155.65C40.4608 155.61 40.7008 155.4 40.6008 155.48C40.8008 155.33 41.0108 155.19 41.2308 155.07C41.3408 155.01 41.4608 154.95 41.5708 154.9C41.7508 154.82 41.6408 154.86 41.8308 154.79C42.0708 154.71 42.3108 154.63 42.5608 154.58C42.6808 154.55 42.8008 154.53 42.9308 154.51C42.7608 154.54 43.0908 154.5 43.1608 154.5C43.2708 154.5 43.3908 154.5 43.5008 154.5C43.5908 154.5 43.8308 154.55 43.6308 154.5C43.9808 154.58 44.0008 154.58 44.2508 154.72C44.2708 154.73 44.4408 154.86 44.3508 154.79C44.2708 154.73 44.4008 154.84 44.4008 154.84C44.4908 154.92 44.5708 155.01 44.6508 155.1C44.7608 155.23 44.5808 154.99 44.6708 155.14C44.7008 155.18 44.7308 155.23 44.7608 155.27C44.8408 155.39 44.9108 155.52 44.9708 155.65C45.1108 155.92 45.1108 155.94 45.2208 156.23C45.3308 156.52 45.4308 156.83 45.5308 157.12C45.9808 158.51 45.8708 159.99 45.2908 161.33C45.0708 161.85 45.1308 162.46 45.6708 162.77C46.1108 163.03 46.8808 162.92 47.1108 162.39C47.8308 160.72 48.1508 158.89 47.7108 157.09C47.5308 156.34 47.2408 155.59 46.9308 154.89C46.6708 154.3 46.3108 153.72 45.8208 153.29C44.6808 152.31 43.1608 152.24 41.7608 152.62C40.4408 152.98 39.1108 153.73 38.3408 154.89C37.1908 156.64 37.9408 158.9 38.6608 160.65C38.8808 161.18 39.3608 161.55 39.9508 161.38C40.4508 161.24 40.9008 160.62 40.6808 160.09Z"
                              begin="0s"
                              dur="1.6s"
                              repeatCount="indefinite"
                              fill="freeze"
                              calcMode="linear"
                              keyTimes="0;0.5;1"
                            />
                          </path>
                        </g>
                      </g>
                      <g id="Group_7" style="mix-blend-mode: multiply" opacity="0.48">
                        <path
                          id="Vector_7"
                          d="M71.7308 210.69C62.4008 218.91 49.5108 220.66 38.2608 215.58C27.4008 210.67 20.6108 199.92 20.6808 188.02C20.7008 184.47 21.2908 181.03 22.3408 177.76C16.2008 183.94 12.6208 192.6 13.1808 201.98C14.2208 219.45 29.2308 232.76 46.7008 231.72C61.5208 230.83 73.3408 219.9 75.9508 205.94C74.7808 207.64 73.3908 209.24 71.7408 210.69L71.7308 210.69Z"
                          fill="#2EBF8F"
                        >
                          <animate
                            attributeName="d"
                            values="M71.7308 210.69C62.4008 218.91 49.5108 220.66 38.2608 215.58C27.4008 210.67 20.6108 199.92 20.6808 188.02C20.7008 184.47 21.2908 181.03 22.3408 177.76C16.2008 183.94 12.6208 192.6 13.1808 201.98C14.2208 219.45 29.2308 232.76 46.7008 231.72C61.5208 230.83 73.3408 219.9 75.9508 205.94C74.7808 207.64 73.3908 209.24 71.7408 210.69L71.7308 210.69Z;M73.2834 211.644C63.6657 219.526 50.7214 220.814 39.6601 215.335C28.9824 210.041 22.5808 199.055 23.0759 187.165C23.2227 183.618 23.9352 180.201 25.1013 176.971C18.7445 182.928 14.8574 191.454 15.0819 200.848C15.4972 218.344 30.0221 232.182 47.5181 231.767C62.3605 231.407 74.5634 220.906 77.6704 207.048C76.4404 208.705 74.9942 210.254 73.2934 211.645L73.2834 211.644Z;M71.7308 210.69C62.4008 218.91 49.5108 220.66 38.2608 215.58C27.4008 210.67 20.6108 199.92 20.6808 188.02C20.7008 184.47 21.2908 181.03 22.3408 177.76C16.2008 183.94 12.6208 192.6 13.1808 201.98C14.2208 219.45 29.2308 232.76 46.7008 231.72C61.5208 230.83 73.3408 219.9 75.9508 205.94C74.7808 207.64 73.3908 209.24 71.7408 210.69L71.7308 210.69Z"
                            begin="0s"
                            dur="1.6s"
                            repeatCount="indefinite"
                            fill="freeze"
                            calcMode="linear"
                            keyTimes="0;0.5;1"
                          />
                        </path>
                      </g>
                    </g>
                    <path
                      id="Vector_8"
                      d="M37.9809 189.81C36.2909 190.88 36.3609 194.05 36.5609 200.36C36.7909 207.74 36.9109 211.43 38.9709 212.42C41.3409 213.56 44.7509 210.77 49.7809 206.67C53.2609 203.83 55.0909 202.3 55.0109 200.19C54.9309 197.95 52.7409 196.45 49.1809 194.08C44.7609 191.13 40.4609 188.26 37.9909 189.82L37.9809 189.81Z"
                      fill="#FFE4C7"
                    >
                      <animate
                        attributeName="d"
                        values="M37.9809 189.81C36.2909 190.88 36.3609 194.05 36.5609 200.36C36.7909 207.74 36.9109 211.43 38.9709 212.42C41.3409 213.56 44.7509 210.77 49.7809 206.67C53.2609 203.83 55.0909 202.3 55.0109 200.19C54.9309 197.95 52.7409 196.45 49.1809 194.08C44.7609 191.13 40.4609 188.26 37.9909 189.82L37.9809 189.81Z;M40.3007 189.572C38.5736 190.581 38.5303 193.751 38.5048 200.065C38.471 207.448 38.4591 211.14 40.4824 212.203C42.8102 213.427 46.3176 210.76 51.4909 206.843C55.0701 204.129 56.9536 202.665 56.9491 200.554C56.9491 198.312 54.8141 196.735 51.341 194.239C47.0293 191.133 42.8345 188.112 40.3104 189.582L40.3007 189.572Z;M37.9809 189.81C36.2909 190.88 36.3609 194.05 36.5609 200.36C36.7909 207.74 36.9109 211.43 38.9709 212.42C41.3409 213.56 44.7509 210.77 49.7809 206.67C53.2609 203.83 55.0909 202.3 55.0109 200.19C54.9309 197.95 52.7409 196.45 49.1809 194.08C44.7609 191.13 40.4609 188.26 37.9909 189.82L37.9809 189.81Z"
                        begin="0s"
                        dur="1.6s"
                        repeatCount="indefinite"
                        fill="freeze"
                        calcMode="linear"
                        keyTimes="0;0.5;1"
                      />
                    </path>
                  </g>
                  <g id="Group_8">
                    <g id="Group_9">
                      <g id="Group_10">
                        <g id="Group_11">
                          <path
                            id="Vector_9"
                            d="M67.7287 258.222C74.6214 258.154 80.1535 252.511 80.0849 245.618C80.0163 238.725 74.3731 233.193 67.4804 233.262C60.5877 233.33 55.0556 238.973 55.1242 245.866C55.1927 252.759 60.836 258.291 67.7287 258.222Z"
                            fill="#DE2D35"
                          >
                            <animate
                              attributeName="d"
                              values="M67.7287 258.222C74.6214 258.154 80.1535 252.511 80.0849 245.618C80.0163 238.725 74.3731 233.193 67.4804 233.262C60.5877 233.33 55.0556 238.973 55.1242 245.866C55.1927 252.759 60.836 258.291 67.7287 258.222Z;M69.7287 258.222C76.6214 258.154 82.1535 252.511 82.0849 245.618C82.0163 238.725 76.3731 233.193 69.4804 233.262C62.5877 233.33 57.0556 238.973 57.1242 245.866C57.1927 252.759 62.836 258.291 69.7287 258.222Z;M67.7287 258.222C74.6214 258.154 80.1535 252.511 80.0849 245.618C80.0163 238.725 74.3731 233.193 67.4804 233.262C60.5877 233.33 55.0556 238.973 55.1242 245.866C55.1927 252.759 60.836 258.291 67.7287 258.222Z"
                              begin="0s"
                              dur="1.6s"
                              repeatCount="indefinite"
                              fill="freeze"
                              calcMode="linear"
                              keyTimes="0;0.5;1"
                            />
                          </path>
                          <g id="Group_12">
                            <path
                              id="Vector_10"
                              d="M61.6409 236.872C62.878 236.668 64.1464 236.407 65.4045 236.616C67.9675 237.044 68.9854 238.73 70.0189 240.881C70.7706 242.437 71.6371 242.781 73.1822 242.097C74.2889 241.601 75.2807 241.1 76.4813 240.85C77.3217 240.677 78.1673 240.604 78.9973 240.641C77.3269 236.914 73.8608 234.085 69.5283 233.406C65.394 232.764 61.4216 234.231 58.6968 237.002C59.5737 237.363 60.7743 237.013 61.6409 236.872Z"
                              fill="#FFE4C7"
                            >
                              <animate
                                attributeName="d"
                                values="M61.6409 236.872C62.878 236.668 64.1464 236.407 65.4045 236.616C67.9675 237.044 68.9854 238.73 70.0189 240.881C70.7706 242.437 71.6371 242.781 73.1822 242.097C74.2889 241.601 75.2807 241.1 76.4813 240.85C77.3217 240.677 78.1673 240.604 78.9973 240.641C77.3269 236.914 73.8608 234.085 69.5283 233.406C65.394 232.764 61.4216 234.231 58.6968 237.002C59.5737 237.363 60.7743 237.013 61.6409 236.872Z;M63.6409 236.872C64.878 236.668 66.1464 236.407 67.4045 236.616C69.9675 237.044 70.9854 238.73 72.0189 240.881C72.7706 242.437 73.6371 242.781 75.1822 242.097C76.2889 241.601 77.2807 241.1 78.4813 240.85C79.3217 240.677 80.1673 240.604 80.9973 240.641C79.3269 236.914 75.8608 234.085 71.5283 233.406C67.394 232.764 63.4216 234.231 60.6968 237.002C61.5737 237.363 62.7743 237.013 63.6409 236.872Z;M61.6409 236.872C62.878 236.668 64.1464 236.407 65.4045 236.616C67.9675 237.044 68.9854 238.73 70.0189 240.881C70.7706 242.437 71.6371 242.781 73.1822 242.097C74.2889 241.601 75.2807 241.1 76.4813 240.85C77.3217 240.677 78.1673 240.604 78.9973 240.641C77.3269 236.914 73.8608 234.085 69.5283 233.406C65.394 232.764 61.4216 234.231 58.6968 237.002C59.5737 237.363 60.7743 237.013 61.6409 236.872Z"
                                begin="0s"
                                dur="1.6s"
                                repeatCount="indefinite"
                                fill="freeze"
                                calcMode="linear"
                                keyTimes="0;0.5;1"
                              />
                            </path>
                            <path
                              id="Vector_11"
                              d="M73.9286 245.85C71.3709 246.847 68.8183 245.981 67.2836 243.679C66.7198 242.833 66.5267 241.471 65.7959 240.771C65.0077 240.02 63.7862 240.301 62.8362 240.448C60.6072 240.782 58.4201 241.225 56.4887 240.056C55.8988 241.205 55.4812 242.468 55.2724 243.815C55.1419 244.655 55.1001 245.49 55.1367 246.304C55.8309 246.263 56.567 246.017 57.1307 245.876C58.5401 245.516 59.9652 245.041 61.4268 244.921C64.3656 244.676 66.2031 246.524 67.7377 248.768C68.4268 249.776 69.1315 250.83 70.4574 250.856C71.7154 250.877 72.9995 250.439 74.2262 250.214C75.9853 249.891 77.6714 249.927 79.0912 250.648C79.4932 249.713 79.7855 248.711 79.9473 247.656C80.1091 246.602 80.1352 245.563 80.0413 244.551C78.0316 243.914 75.9331 245.073 73.9391 245.85L73.9286 245.85Z"
                              fill="#FFE4C7"
                            >
                              <animate
                                attributeName="d"
                                values="M73.9286 245.85C71.3709 246.847 68.8183 245.981 67.2836 243.679C66.7198 242.833 66.5267 241.471 65.7959 240.771C65.0077 240.02 63.7862 240.301 62.8362 240.448C60.6072 240.782 58.4201 241.225 56.4887 240.056C55.8988 241.205 55.4812 242.468 55.2724 243.815C55.1419 244.655 55.1001 245.49 55.1367 246.304C55.8309 246.263 56.567 246.017 57.1307 245.876C58.5401 245.516 59.9652 245.041 61.4268 244.921C64.3656 244.676 66.2031 246.524 67.7377 248.768C68.4268 249.776 69.1315 250.83 70.4574 250.856C71.7154 250.877 72.9995 250.439 74.2262 250.214C75.9853 249.891 77.6714 249.927 79.0912 250.648C79.4932 249.713 79.7855 248.711 79.9473 247.656C80.1091 246.602 80.1352 245.563 80.0413 244.551C78.0316 243.914 75.9331 245.073 73.9391 245.85L73.9286 245.85Z;M75.9286 245.85C73.3709 246.847 70.8183 245.981 69.2836 243.679C68.7198 242.833 68.5267 241.471 67.7959 240.771C67.0077 240.02 65.7862 240.301 64.8362 240.448C62.6072 240.782 60.4201 241.225 58.4887 240.056C57.8988 241.205 57.4812 242.468 57.2724 243.815C57.1419 244.655 57.1001 245.49 57.1367 246.304C57.8309 246.263 58.567 246.017 59.1307 245.876C60.5401 245.516 61.9652 245.041 63.4268 244.921C66.3656 244.676 68.2031 246.524 69.7377 248.768C70.4268 249.776 71.1315 250.83 72.4574 250.856C73.7154 250.877 74.9995 250.439 76.2262 250.214C77.9853 249.891 79.6714 249.927 81.0912 250.648C81.4932 249.713 81.7855 248.711 81.9473 247.656C82.1091 246.602 82.1352 245.563 82.0413 244.551C80.0316 243.914 77.9331 245.073 75.9391 245.85L75.9286 245.85Z;M73.9286 245.85C71.3709 246.847 68.8183 245.981 67.2836 243.679C66.7198 242.833 66.5267 241.471 65.7959 240.771C65.0077 240.02 63.7862 240.301 62.8362 240.448C60.6072 240.782 58.4201 241.225 56.4887 240.056C55.8988 241.205 55.4812 242.468 55.2724 243.815C55.1419 244.655 55.1001 245.49 55.1367 246.304C55.8309 246.263 56.567 246.017 57.1307 245.876C58.5401 245.516 59.9652 245.041 61.4268 244.921C64.3656 244.676 66.2031 246.524 67.7377 248.768C68.4268 249.776 69.1315 250.83 70.4574 250.856C71.7154 250.877 72.9995 250.439 74.2262 250.214C75.9853 249.891 77.6714 249.927 79.0912 250.648C79.4932 249.713 79.7855 248.711 79.9473 247.656C80.1091 246.602 80.1352 245.563 80.0413 244.551C78.0316 243.914 75.9331 245.073 73.9391 245.85L73.9286 245.85Z"
                                begin="0s"
                                dur="1.6s"
                                repeatCount="indefinite"
                                fill="freeze"
                                calcMode="linear"
                                keyTimes="0;0.5;1"
                              />
                            </path>
                            <path
                              id="Vector_12"
                              d="M68.8549 256.139C69.7736 256.426 70.2434 257.178 70.2747 257.935C72.9369 257.35 75.3277 255.909 77.0816 253.863C75.4008 253.216 72.6342 254.469 71.0682 254.589C68.3381 254.792 66.3702 253.378 64.8512 251.217C64.1882 250.272 63.5462 248.862 62.2777 248.653C61.1032 248.46 59.6834 249.087 58.5715 249.379C57.6946 249.609 56.7706 249.833 55.8467 249.943C56.1703 250.846 56.6036 251.702 57.1204 252.501C61.6043 250.862 64.8146 254.865 68.8549 256.139Z"
                              fill="#FFE4C7"
                            >
                              <animate
                                attributeName="d"
                                values="M68.8549 256.139C69.7736 256.426 70.2434 257.178 70.2747 257.935C72.9369 257.35 75.3277 255.909 77.0816 253.863C75.4008 253.216 72.6342 254.469 71.0682 254.589C68.3381 254.792 66.3702 253.378 64.8512 251.217C64.1882 250.272 63.5462 248.862 62.2777 248.653C61.1032 248.46 59.6834 249.087 58.5715 249.379C57.6946 249.609 56.7706 249.833 55.8467 249.943C56.1703 250.846 56.6036 251.702 57.1204 252.501C61.6043 250.862 64.8146 254.865 68.8549 256.139Z;M70.8549 256.139C71.7736 256.426 72.2434 257.178 72.2747 257.935C74.9369 257.35 77.3277 255.909 79.0816 253.863C77.4008 253.216 74.6342 254.469 73.0682 254.589C70.3381 254.792 68.3702 253.378 66.8512 251.217C66.1882 250.272 65.5462 248.862 64.2777 248.653C63.1032 248.46 61.6834 249.087 60.5715 249.379C59.6946 249.609 58.7706 249.833 57.8467 249.943C58.1703 250.846 58.6036 251.702 59.1204 252.501C63.6043 250.862 66.8146 254.865 70.8549 256.139Z;M68.8549 256.139C69.7736 256.426 70.2434 257.178 70.2747 257.935C72.9369 257.35 75.3277 255.909 77.0816 253.863C75.4008 253.216 72.6342 254.469 71.0682 254.589C68.3381 254.792 66.3702 253.378 64.8512 251.217C64.1882 250.272 63.5462 248.862 62.2777 248.653C61.1032 248.46 59.6834 249.087 58.5715 249.379C57.6946 249.609 56.7706 249.833 55.8467 249.943C56.1703 250.846 56.6036 251.702 57.1204 252.501C61.6043 250.862 64.8146 254.865 68.8549 256.139Z"
                                begin="0s"
                                dur="1.6s"
                                repeatCount="indefinite"
                                fill="freeze"
                                calcMode="linear"
                                keyTimes="0;0.5;1"
                              />
                            </path>
                          </g>
                        </g>
                        <g id="Group_13">
                          <path
                            id="Vector_13"
                            d="M68.5031 229.457L72.1909 230.031C73.4185 230.222 74.259 231.373 74.0678 232.6L73.7233 234.813L65.5842 233.546L65.9288 231.333C66.1199 230.105 67.2704 229.265 68.4979 229.456L68.5031 229.457Z"
                            fill="#F8B000"
                            stroke="#F8B000"
                            stroke-width="0.83"
                            stroke-miterlimit="10"
                          >
                            <animate
                              attributeName="d"
                              values="M68.5031 229.457L72.1909 230.031C73.4185 230.222 74.259 231.373 74.0678 232.6L73.7233 234.813L65.5842 233.546L65.9288 231.333C66.1199 230.105 67.2704 229.265 68.4979 229.456L68.5031 229.457Z;M70.5031 229.457L74.1909 230.031C75.4185 230.222 76.259 231.373 76.0678 232.6L75.7233 234.813L67.5842 233.546L67.9288 231.333C68.1199 230.105 69.2704 229.265 70.4979 229.456L70.5031 229.457Z;M68.5031 229.457L72.1909 230.031C73.4185 230.222 74.259 231.373 74.0678 232.6L73.7233 234.813L65.5842 233.546L65.9288 231.333C66.1199 230.105 67.2704 229.265 68.4979 229.456L68.5031 229.457Z"
                              begin="0s"
                              dur="1.6s"
                              repeatCount="indefinite"
                              fill="freeze"
                              calcMode="linear"
                              keyTimes="0;0.5;1"
                            />
                          </path>
                          <path
                            id="Vector_14"
                            d="M69.5803 229.846C69.5699 229.783 69.5594 229.715 69.549 229.653C69.5438 229.606 69.5177 229.444 69.5333 229.574C69.5177 229.433 69.502 229.298 69.502 229.157C69.502 229.094 69.502 229.026 69.502 228.964C69.502 228.937 69.502 228.911 69.5072 228.88C69.5124 228.786 69.4811 228.984 69.5072 228.89C69.5281 228.833 69.5385 228.77 69.5542 228.708C69.5542 228.697 69.5855 228.614 69.5542 228.687C69.5229 228.77 69.5803 228.635 69.5907 228.619C69.6012 228.598 69.6168 228.577 69.6273 228.556C69.6586 228.488 69.5333 228.656 69.5907 228.603C69.6221 228.572 69.6534 228.541 69.6795 228.509C69.7578 228.431 69.5751 228.577 69.669 228.515C69.716 228.489 69.7578 228.457 69.8048 228.431C69.8309 228.415 69.857 228.405 69.8778 228.395C69.9666 228.348 69.8413 228.41 69.8413 228.41C69.8413 228.395 69.9457 228.374 69.9614 228.368C70.0658 228.332 70.1754 228.311 70.285 228.29C70.4468 228.259 70.191 228.29 70.3111 228.29C70.3633 228.29 70.4155 228.28 70.4625 228.28C70.5564 228.28 70.6922 228.311 70.7809 228.295C70.7652 228.295 70.6243 228.264 70.7287 228.295C70.7496 228.295 70.7652 228.306 70.7861 228.306C70.8279 228.316 70.8696 228.332 70.9114 228.342C70.974 228.342 70.9427 228.353 70.9114 228.342C70.8279 228.337 70.901 228.342 70.9375 228.358C70.9584 228.368 70.9793 228.384 70.9949 228.395C71.0993 228.457 70.9584 228.337 70.9845 228.389C70.9897 228.405 71.021 228.426 71.0315 228.436C71.1254 228.52 71.0001 228.405 71.0106 228.405C71.021 228.405 71.0837 228.525 71.0889 228.53C71.162 228.656 71.068 228.447 71.0993 228.551C71.115 228.609 71.1359 228.666 71.1515 228.723C71.1724 228.812 71.1672 228.969 71.2142 229.047C71.2142 229.047 71.1985 228.917 71.2089 228.995C71.2089 229.021 71.2142 229.042 71.2194 229.068C71.2246 229.131 71.235 229.198 71.2403 229.266C71.2559 229.428 71.2507 229.585 71.2455 229.752C71.2455 229.825 71.2455 229.736 71.2507 229.726C71.2455 229.773 71.235 229.82 71.2246 229.867C71.2089 229.945 71.1881 230.018 71.1672 230.091C71.1463 230.164 71.115 230.237 71.0889 230.31C71.0628 230.383 71.0889 230.3 71.0993 230.289C71.0784 230.331 71.0576 230.378 71.0367 230.42C70.9584 230.566 70.8749 230.707 70.7757 230.843C70.5773 231.119 70.7183 231.574 71.0106 231.73C71.3447 231.908 71.684 231.793 71.898 231.495C72.3312 230.89 72.6027 230.117 72.5453 229.371C72.4983 228.729 72.4148 228.034 71.9658 227.538C71.5482 227.084 70.8696 226.949 70.2746 227.016C69.6795 227.084 69.027 227.272 68.6459 227.758C68.0769 228.473 68.1761 229.381 68.3223 230.222C68.3797 230.556 68.8077 230.775 69.1209 230.676C69.4811 230.561 69.6377 230.237 69.5751 229.877L69.5803 229.846Z"
                            fill="#F8B000"
                          >
                            <animate
                              attributeName="d"
                              values="M69.5803 229.846C69.5699 229.783 69.5594 229.715 69.549 229.653C69.5438 229.606 69.5177 229.444 69.5333 229.574C69.5177 229.433 69.502 229.298 69.502 229.157C69.502 229.094 69.502 229.026 69.502 228.964C69.502 228.937 69.502 228.911 69.5072 228.88C69.5124 228.786 69.4811 228.984 69.5072 228.89C69.5281 228.833 69.5385 228.77 69.5542 228.708C69.5542 228.697 69.5855 228.614 69.5542 228.687C69.5229 228.77 69.5803 228.635 69.5907 228.619C69.6012 228.598 69.6168 228.577 69.6273 228.556C69.6586 228.488 69.5333 228.656 69.5907 228.603C69.6221 228.572 69.6534 228.541 69.6795 228.509C69.7578 228.431 69.5751 228.577 69.669 228.515C69.716 228.489 69.7578 228.457 69.8048 228.431C69.8309 228.415 69.857 228.405 69.8778 228.395C69.9666 228.348 69.8413 228.41 69.8413 228.41C69.8413 228.395 69.9457 228.374 69.9614 228.368C70.0658 228.332 70.1754 228.311 70.285 228.29C70.4468 228.259 70.191 228.29 70.3111 228.29C70.3633 228.29 70.4155 228.28 70.4625 228.28C70.5564 228.28 70.6922 228.311 70.7809 228.295C70.7652 228.295 70.6243 228.264 70.7287 228.295C70.7496 228.295 70.7652 228.306 70.7861 228.306C70.8279 228.316 70.8696 228.332 70.9114 228.342C70.974 228.342 70.9427 228.353 70.9114 228.342C70.8279 228.337 70.901 228.342 70.9375 228.358C70.9584 228.368 70.9793 228.384 70.9949 228.395C71.0993 228.457 70.9584 228.337 70.9845 228.389C70.9897 228.405 71.021 228.426 71.0315 228.436C71.1254 228.52 71.0001 228.405 71.0106 228.405C71.021 228.405 71.0837 228.525 71.0889 228.53C71.162 228.656 71.068 228.447 71.0993 228.551C71.115 228.609 71.1359 228.666 71.1515 228.723C71.1724 228.812 71.1672 228.969 71.2142 229.047C71.2142 229.047 71.1985 228.917 71.2089 228.995C71.2089 229.021 71.2142 229.042 71.2194 229.068C71.2246 229.131 71.235 229.198 71.2403 229.266C71.2559 229.428 71.2507 229.585 71.2455 229.752C71.2455 229.825 71.2455 229.736 71.2507 229.726C71.2455 229.773 71.235 229.82 71.2246 229.867C71.2089 229.945 71.1881 230.018 71.1672 230.091C71.1463 230.164 71.115 230.237 71.0889 230.31C71.0628 230.383 71.0889 230.3 71.0993 230.289C71.0784 230.331 71.0576 230.378 71.0367 230.42C70.9584 230.566 70.8749 230.707 70.7757 230.843C70.5773 231.119 70.7183 231.574 71.0106 231.73C71.3447 231.908 71.684 231.793 71.898 231.495C72.3312 230.89 72.6027 230.117 72.5453 229.371C72.4983 228.729 72.4148 228.034 71.9658 227.538C71.5482 227.084 70.8696 226.949 70.2746 227.016C69.6795 227.084 69.027 227.272 68.6459 227.758C68.0769 228.473 68.1761 229.381 68.3223 230.222C68.3797 230.556 68.8077 230.775 69.1209 230.676C69.4811 230.561 69.6377 230.237 69.5751 229.877L69.5803 229.846Z;M71.5803 229.846C71.5699 229.783 71.5594 229.715 71.549 229.653C71.5438 229.606 71.5177 229.444 71.5333 229.574C71.5177 229.433 71.502 229.298 71.502 229.157C71.502 229.094 71.502 229.026 71.502 228.964C71.502 228.937 71.502 228.911 71.5072 228.88C71.5124 228.786 71.4811 228.984 71.5072 228.89C71.5281 228.833 71.5385 228.77 71.5542 228.708C71.5542 228.697 71.5855 228.614 71.5542 228.687C71.5229 228.77 71.5803 228.635 71.5907 228.619C71.6012 228.598 71.6168 228.577 71.6273 228.556C71.6586 228.488 71.5333 228.656 71.5907 228.603C71.6221 228.572 71.6534 228.541 71.6795 228.509C71.7578 228.431 71.5751 228.577 71.669 228.515C71.716 228.489 71.7578 228.457 71.8048 228.431C71.8309 228.415 71.857 228.405 71.8778 228.395C71.9666 228.348 71.8413 228.41 71.8413 228.41C71.8413 228.395 71.9457 228.374 71.9614 228.368C72.0658 228.332 72.1754 228.311 72.285 228.29C72.4468 228.259 72.191 228.29 72.3111 228.29C72.3633 228.29 72.4155 228.28 72.4625 228.28C72.5564 228.28 72.6922 228.311 72.7809 228.295C72.7652 228.295 72.6243 228.264 72.7287 228.295C72.7496 228.295 72.7652 228.306 72.7861 228.306C72.8279 228.316 72.8696 228.332 72.9114 228.342C72.974 228.342 72.9427 228.353 72.9114 228.342C72.8279 228.337 72.901 228.342 72.9375 228.358C72.9584 228.368 72.9793 228.384 72.9949 228.395C73.0993 228.457 72.9584 228.337 72.9845 228.389C72.9897 228.405 73.021 228.426 73.0315 228.436C73.1254 228.52 73.0001 228.405 73.0106 228.405C73.021 228.405 73.0837 228.525 73.0889 228.53C73.162 228.656 73.068 228.447 73.0993 228.551C73.115 228.609 73.1359 228.666 73.1515 228.723C73.1724 228.812 73.1672 228.969 73.2142 229.047C73.2142 229.047 73.1985 228.917 73.2089 228.995C73.2089 229.021 73.2142 229.042 73.2194 229.068C73.2246 229.131 73.235 229.198 73.2403 229.266C73.2559 229.428 73.2507 229.585 73.2455 229.752C73.2455 229.825 73.2455 229.736 73.2507 229.726C73.2455 229.773 73.235 229.82 73.2246 229.867C73.2089 229.945 73.1881 230.018 73.1672 230.091C73.1463 230.164 73.115 230.237 73.0889 230.31C73.0628 230.383 73.0889 230.3 73.0993 230.289C73.0784 230.331 73.0576 230.378 73.0367 230.42C72.9584 230.566 72.8749 230.707 72.7757 230.843C72.5773 231.119 72.7183 231.574 73.0106 231.73C73.3447 231.908 73.684 231.793 73.898 231.495C74.3312 230.89 74.6027 230.117 74.5453 229.371C74.4983 228.729 74.4148 228.034 73.9658 227.538C73.5482 227.084 72.8696 226.949 72.2746 227.016C71.6795 227.084 71.027 227.272 70.6459 227.758C70.0769 228.473 70.1761 229.381 70.3223 230.222C70.3797 230.556 70.8077 230.775 71.1209 230.676C71.4811 230.561 71.6377 230.237 71.5751 229.877L71.5803 229.846Z;M69.5803 229.846C69.5699 229.783 69.5594 229.715 69.549 229.653C69.5438 229.606 69.5177 229.444 69.5333 229.574C69.5177 229.433 69.502 229.298 69.502 229.157C69.502 229.094 69.502 229.026 69.502 228.964C69.502 228.937 69.502 228.911 69.5072 228.88C69.5124 228.786 69.4811 228.984 69.5072 228.89C69.5281 228.833 69.5385 228.77 69.5542 228.708C69.5542 228.697 69.5855 228.614 69.5542 228.687C69.5229 228.77 69.5803 228.635 69.5907 228.619C69.6012 228.598 69.6168 228.577 69.6273 228.556C69.6586 228.488 69.5333 228.656 69.5907 228.603C69.6221 228.572 69.6534 228.541 69.6795 228.509C69.7578 228.431 69.5751 228.577 69.669 228.515C69.716 228.489 69.7578 228.457 69.8048 228.431C69.8309 228.415 69.857 228.405 69.8778 228.395C69.9666 228.348 69.8413 228.41 69.8413 228.41C69.8413 228.395 69.9457 228.374 69.9614 228.368C70.0658 228.332 70.1754 228.311 70.285 228.29C70.4468 228.259 70.191 228.29 70.3111 228.29C70.3633 228.29 70.4155 228.28 70.4625 228.28C70.5564 228.28 70.6922 228.311 70.7809 228.295C70.7652 228.295 70.6243 228.264 70.7287 228.295C70.7496 228.295 70.7652 228.306 70.7861 228.306C70.8279 228.316 70.8696 228.332 70.9114 228.342C70.974 228.342 70.9427 228.353 70.9114 228.342C70.8279 228.337 70.901 228.342 70.9375 228.358C70.9584 228.368 70.9793 228.384 70.9949 228.395C71.0993 228.457 70.9584 228.337 70.9845 228.389C70.9897 228.405 71.021 228.426 71.0315 228.436C71.1254 228.52 71.0001 228.405 71.0106 228.405C71.021 228.405 71.0837 228.525 71.0889 228.53C71.162 228.656 71.068 228.447 71.0993 228.551C71.115 228.609 71.1359 228.666 71.1515 228.723C71.1724 228.812 71.1672 228.969 71.2142 229.047C71.2142 229.047 71.1985 228.917 71.2089 228.995C71.2089 229.021 71.2142 229.042 71.2194 229.068C71.2246 229.131 71.235 229.198 71.2403 229.266C71.2559 229.428 71.2507 229.585 71.2455 229.752C71.2455 229.825 71.2455 229.736 71.2507 229.726C71.2455 229.773 71.235 229.82 71.2246 229.867C71.2089 229.945 71.1881 230.018 71.1672 230.091C71.1463 230.164 71.115 230.237 71.0889 230.31C71.0628 230.383 71.0889 230.3 71.0993 230.289C71.0784 230.331 71.0576 230.378 71.0367 230.42C70.9584 230.566 70.8749 230.707 70.7757 230.843C70.5773 231.119 70.7183 231.574 71.0106 231.73C71.3447 231.908 71.684 231.793 71.898 231.495C72.3312 230.89 72.6027 230.117 72.5453 229.371C72.4983 228.729 72.4148 228.034 71.9658 227.538C71.5482 227.084 70.8696 226.949 70.2746 227.016C69.6795 227.084 69.027 227.272 68.6459 227.758C68.0769 228.473 68.1761 229.381 68.3223 230.222C68.3797 230.556 68.8077 230.775 69.1209 230.676C69.4811 230.561 69.6377 230.237 69.5751 229.877L69.5803 229.846Z"
                              begin="0s"
                              dur="1.6s"
                              repeatCount="indefinite"
                              fill="freeze"
                              calcMode="linear"
                              keyTimes="0;0.5;1"
                            />
                          </path>
                        </g>
                      </g>
                      <g id="Group_14">
                        <path
                          id="Vector_15"
                          d="M71.569 239.43C72.4042 239.43 72.4042 238.135 71.569 238.135C70.7338 238.135 70.7338 239.43 71.569 239.43Z"
                          fill="#DE2D35"
                        >
                          <animate
                            attributeName="d"
                            values="M71.569 239.43C72.4042 239.43 72.4042 238.135 71.569 238.135C70.7338 238.135 70.7338 239.43 71.569 239.43Z;M73.569 239.43C74.4042 239.43 74.4042 238.135 73.569 238.135C72.7338 238.135 72.7338 239.43 73.569 239.43Z;M71.569 239.43C72.4042 239.43 72.4042 238.135 71.569 238.135C70.7338 238.135 70.7338 239.43 71.569 239.43Z"
                            begin="0s"
                            dur="1.6s"
                            repeatCount="indefinite"
                            fill="freeze"
                            calcMode="linear"
                            keyTimes="0;0.5;1"
                          />
                        </path>
                        <path
                          id="Vector_16"
                          d="M63.2746 242.927C64.1098 242.927 64.1098 241.633 63.2746 241.633C62.4394 241.633 62.4394 242.927 63.2746 242.927Z"
                          fill="#DE2D35"
                        >
                          <animate
                            attributeName="d"
                            values="M63.2746 242.927C64.1098 242.927 64.1098 241.633 63.2746 241.633C62.4394 241.633 62.4394 242.927 63.2746 242.927Z;M65.2746 242.927C66.1098 242.927 66.1098 241.633 65.2746 241.633C64.4394 241.633 64.4394 242.927 65.2746 242.927Z;M63.2746 242.927C64.1098 242.927 64.1098 241.633 63.2746 241.633C62.4394 241.633 62.4394 242.927 63.2746 242.927Z"
                            begin="0s"
                            dur="1.6s"
                            repeatCount="indefinite"
                            fill="freeze"
                            calcMode="linear"
                            keyTimes="0;0.5;1"
                          />
                        </path>
                        <path
                          id="Vector_17"
                          d="M75.0925 248.22C75.9277 248.22 75.9277 246.926 75.0925 246.926C74.2573 246.926 74.2573 248.22 75.0925 248.22Z"
                          fill="#DE2D35"
                        >
                          <animate
                            attributeName="d"
                            values="M75.0925 248.22C75.9277 248.22 75.9277 246.926 75.0925 246.926C74.2573 246.926 74.2573 248.22 75.0925 248.22Z;M77.0925 248.22C77.9277 248.22 77.9277 246.926 77.0925 246.926C76.2573 246.926 76.2573 248.22 77.0925 248.22Z;M75.0925 248.22C75.9277 248.22 75.9277 246.926 75.0925 246.926C74.2573 246.926 74.2573 248.22 75.0925 248.22Z"
                            begin="0s"
                            dur="1.6s"
                            repeatCount="indefinite"
                            fill="freeze"
                            calcMode="linear"
                            keyTimes="0;0.5;1"
                          />
                        </path>
                      </g>
                    </g>
                    <g id="Group_15" style="mix-blend-mode: multiply" opacity="0.48">
                      <path
                        id="Vector_18"
                        d="M77.0868 252.072C72.8064 254.458 67.6961 254.051 63.7915 251.154C60.0227 248.356 58.3053 243.647 59.3284 239.069C59.6312 237.702 60.148 236.428 60.8266 235.259C57.9451 237.122 55.8415 240.16 55.2725 243.814C54.2128 250.626 58.8743 257.01 65.6864 258.07C71.4649 258.968 76.9302 255.752 79.107 250.595C78.5119 251.148 77.8437 251.65 77.0868 252.072Z"
                        fill="#DE2D35"
                        fill-opacity="0.6"
                      >
                        <animate
                          attributeName="d"
                          values="M77.0868 252.072C72.8064 254.458 67.6961 254.051 63.7915 251.154C60.0227 248.356 58.3053 243.647 59.3284 239.069C59.6312 237.702 60.148 236.428 60.8266 235.259C57.9451 237.122 55.8415 240.16 55.2725 243.814C54.2128 250.626 58.8743 257.01 65.6864 258.07C71.4649 258.968 76.9302 255.752 79.107 250.595C78.5119 251.148 77.8437 251.65 77.0868 252.072Z;M79.0868 252.072C74.8064 254.458 69.6961 254.051 65.7915 251.154C62.0227 248.356 60.3053 243.647 61.3284 239.069C61.6312 237.702 62.148 236.428 62.8266 235.259C59.9451 237.122 57.8415 240.16 57.2725 243.814C56.2128 250.626 60.8743 257.01 67.6864 258.07C73.4649 258.968 78.9302 255.752 81.107 250.595C80.5119 251.148 79.8437 251.65 79.0868 252.072Z;M77.0868 252.072C72.8064 254.458 67.6961 254.051 63.7915 251.154C60.0227 248.356 58.3053 243.647 59.3284 239.069C59.6312 237.702 60.148 236.428 60.8266 235.259C57.9451 237.122 55.8415 240.16 55.2725 243.814C54.2128 250.626 58.8743 257.01 65.6864 258.07C71.4649 258.968 76.9302 255.752 79.107 250.595C78.5119 251.148 77.8437 251.65 77.0868 252.072Z"
                          begin="0s"
                          dur="1.6s"
                          repeatCount="indefinite"
                          fill="freeze"
                          calcMode="linear"
                          keyTimes="0;0.5;1"
                        />
                      </path>
                    </g>
                  </g>
                </g>
              </g>
            </g>
          </svg>
          <svg
            slot="pause"
            xmlns="http://www.w3.org/2000/svg"
            width="90"
            height="259"
            viewBox="0 0 90 259"
            fill="none"
            style="&#10;"
          >
            <g id="Group">
              <g id="Capa 2">
                <g id="Capa 1">
                  <path
                    id="wire"
                    fill-rule="evenodd"
                    clip-rule="evenodd"
                    d="M78.5023 11.8951C79.7101 7.83089 80.5625 3.84468 81.1439 0L83.1657 0C82.5708 4.0221 81.6867 8.20063 80.4195 12.4645C76.7802 24.7187 71.5704 33.0015 66.0397 40.2502C64.2498 42.596 62.4438 44.8141 60.6532 47.0133C60.1079 47.683 59.5641 48.351 59.0226 49.0203C48.4244 86.5587 52.7705 112.03 58.6414 128.301L58.6414 128.301C60.5983 133.728 63.0063 138.918 65.4168 143.979C65.7175 144.611 66.0184 145.24 66.3184 145.868L66.321 145.874C68.4186 150.263 70.4771 154.571 72.1638 158.817C76.025 168.536 78.0243 178.134 74.1119 188.125C72.6871 191.771 70.4087 194.687 68.2691 197.426C67.7208 198.128 67.1817 198.818 66.6683 199.506C64.1212 202.918 62.0735 206.406 61.9605 211.383L60.9607 211.36L61.9604 211.383C61.7792 219.328 66.2795 225.964 70.0544 230.293L68.5471 231.607C64.6819 227.175 59.7622 220.052 59.961 211.337C60.088 205.744 62.4252 201.847 65.0656 198.309C65.6324 197.55 66.2074 196.813 66.7774 196.082L66.7779 196.081C68.8938 193.368 70.9416 190.743 72.2493 187.396L72.2496 187.395C75.8871 178.106 74.0964 169.099 70.3051 159.555C68.6454 155.378 66.6188 151.136 64.5181 146.74L64.518 146.74C64.217 146.109 63.9144 145.476 63.6112 144.839C61.1989 139.774 58.7532 134.507 56.7601 128.979C50.9905 112.989 46.737 88.4842 55.8815 52.9813C53.7837 55.702 51.7497 58.5377 49.835 61.6799C39.7154 78.2966 31.585 105.885 43.3415 153.249L41.4004 153.731C29.5368 105.935 37.6864 77.783 48.1268 60.6397C51.5386 55.0405 55.3869 50.3122 59.2052 45.6208C60.9753 43.446 62.7389 41.2791 64.4496 39.037C69.8814 31.9181 74.9516 23.8509 78.5023 11.8951Z"
                    fill="white"
                  >
                    <animate
                      attributeName="d"
                      values="M78.5023 11.8951C79.7101 7.83089 80.5625 3.84468 81.1439 0L83.1657 0C82.5708 4.0221 81.6867 8.20063 80.4195 12.4645C76.7802 24.7187 71.5704 33.0015 66.0397 40.2502C64.2498 42.596 62.4438 44.8141 60.6532 47.0133C60.1079 47.683 59.5641 48.351 59.0226 49.0203C48.4244 86.5587 52.7705 112.03 58.6414 128.301L58.6414 128.301C60.5983 133.728 63.0063 138.918 65.4168 143.979C65.7175 144.611 66.0184 145.24 66.3184 145.868L66.321 145.874C68.4186 150.263 70.4771 154.571 72.1638 158.817C76.025 168.536 78.0243 178.134 74.1119 188.125C72.6871 191.771 70.4087 194.687 68.2691 197.426C67.7208 198.128 67.1817 198.818 66.6683 199.506C64.1212 202.918 62.0735 206.406 61.9605 211.383L60.9607 211.36L61.9604 211.383C61.7792 219.328 66.2795 225.964 70.0544 230.293L68.5471 231.607C64.6819 227.175 59.7622 220.052 59.961 211.337C60.088 205.744 62.4252 201.847 65.0656 198.309C65.6324 197.55 66.2074 196.813 66.7774 196.082L66.7779 196.081C68.8938 193.368 70.9416 190.743 72.2493 187.396L72.2496 187.395C75.8871 178.106 74.0964 169.099 70.3051 159.555C68.6454 155.378 66.6188 151.136 64.5181 146.74L64.518 146.74C64.217 146.109 63.9144 145.476 63.6112 144.839C61.1989 139.774 58.7532 134.507 56.7601 128.979C50.9905 112.989 46.737 88.4842 55.8815 52.9813C53.7837 55.702 51.7497 58.5377 49.835 61.6799C39.7154 78.2966 31.585 105.885 43.3415 153.249L41.4004 153.731C29.5368 105.935 37.6864 77.783 48.1268 60.6397C51.5386 55.0405 55.3869 50.3122 59.2052 45.6208C60.9753 43.446 62.7389 41.2791 64.4496 39.037C69.8814 31.9181 74.9516 23.8509 78.5023 11.8951Z;M80.5023 11.8951C81.7101 7.83089 82.5625 3.84468 83.1439 0L85.1657 0C84.5708 4.0221 83.6867 8.20063 82.4195 12.4645C78.7802 24.7187 73.5704 33.0015 68.0397 40.2502C66.2498 42.596 64.4438 44.8141 62.6532 47.0133C62.1079 47.683 61.5641 48.351 61.0226 49.0203C50.4244 86.5587 54.7705 112.03 60.6414 128.301L60.6414 128.301C62.5983 133.728 65.0063 138.918 67.4168 143.979C67.7175 144.611 68.0184 145.24 68.3184 145.868L68.321 145.874C70.4186 150.263 72.4771 154.571 74.1638 158.817C78.025 168.536 80.0243 178.134 76.1119 188.125C74.6871 191.771 72.4087 194.687 70.2691 197.426C69.7208 198.128 69.1817 198.818 68.6683 199.506C66.1212 202.918 64.0735 206.406 63.9605 211.383L62.9607 211.36L63.9604 211.383C63.7792 219.328 68.2795 225.964 72.0544 230.293L70.5471 231.607C66.6819 227.175 61.7622 220.052 61.961 211.337C62.088 205.744 64.4252 201.847 67.0656 198.309C67.6324 197.55 68.2074 196.813 68.7774 196.082L68.7779 196.081C70.8938 193.368 72.9416 190.743 74.2493 187.396L74.2496 187.395C77.8871 178.106 76.0964 169.099 72.3051 159.555C70.6454 155.378 68.6188 151.136 66.5181 146.74L66.518 146.74C66.217 146.109 65.9144 145.476 65.6112 144.839C63.1989 139.774 60.7532 134.507 58.7601 128.979C52.9905 112.989 48.737 88.4842 57.8815 52.9813C55.7837 55.702 53.7497 58.5377 51.835 61.6799C41.7154 78.2966 33.585 105.885 45.3415 153.249L43.4004 153.731C31.5368 105.935 39.6864 77.783 50.1268 60.6397C53.5386 55.0405 57.3869 50.3122 61.2052 45.6208C62.9753 43.446 64.7389 41.2791 66.4496 39.037C71.8814 31.9181 76.9516 23.8509 80.5023 11.8951Z;M78.5023 11.8951C79.7101 7.83089 80.5625 3.84468 81.1439 0L83.1657 0C82.5708 4.0221 81.6867 8.20063 80.4195 12.4645C76.7802 24.7187 71.5704 33.0015 66.0397 40.2502C64.2498 42.596 62.4438 44.8141 60.6532 47.0133C60.1079 47.683 59.5641 48.351 59.0226 49.0203C48.4244 86.5587 52.7705 112.03 58.6414 128.301L58.6414 128.301C60.5983 133.728 63.0063 138.918 65.4168 143.979C65.7175 144.611 66.0184 145.24 66.3184 145.868L66.321 145.874C68.4186 150.263 70.4771 154.571 72.1638 158.817C76.025 168.536 78.0243 178.134 74.1119 188.125C72.6871 191.771 70.4087 194.687 68.2691 197.426C67.7208 198.128 67.1817 198.818 66.6683 199.506C64.1212 202.918 62.0735 206.406 61.9605 211.383L60.9607 211.36L61.9604 211.383C61.7792 219.328 66.2795 225.964 70.0544 230.293L68.5471 231.607C64.6819 227.175 59.7622 220.052 59.961 211.337C60.088 205.744 62.4252 201.847 65.0656 198.309C65.6324 197.55 66.2074 196.813 66.7774 196.082L66.7779 196.081C68.8938 193.368 70.9416 190.743 72.2493 187.396L72.2496 187.395C75.8871 178.106 74.0964 169.099 70.3051 159.555C68.6454 155.378 66.6188 151.136 64.5181 146.74L64.518 146.74C64.217 146.109 63.9144 145.476 63.6112 144.839C61.1989 139.774 58.7532 134.507 56.7601 128.979C50.9905 112.989 46.737 88.4842 55.8815 52.9813C53.7837 55.702 51.7497 58.5377 49.835 61.6799C39.7154 78.2966 31.585 105.885 43.3415 153.249L41.4004 153.731C29.5368 105.935 37.6864 77.783 48.1268 60.6397C51.5386 55.0405 55.3869 50.3122 59.2052 45.6208C60.9753 43.446 62.7389 41.2791 64.4496 39.037C69.8814 31.9181 74.9516 23.8509 78.5023 11.8951Z"
                      begin="0s"
                      dur="1.6s"
                      repeatCount="indefinite"
                      fill="freeze"
                      calcMode="linear"
                      keyTimes="0;0.5;1"
                    />
                  </path>
                  <g id="Group_2">
                    <g id="Group_3">
                      <g id="Group_4">
                        <path
                          id="Vector"
                          d="M67.2034 222.486C79.5753 210.114 79.5752 190.056 67.2034 177.684C54.8316 165.312 34.773 165.312 22.4011 177.684C10.0293 190.056 10.0293 210.114 22.4011 222.486C34.7729 234.858 54.8316 234.858 67.2034 222.486Z"
                          fill="#DE2D35"
                        >
                          <animate
                            attributeName="d"
                            values="M67.2034 222.486C79.5753 210.114 79.5752 190.056 67.2034 177.684C54.8316 165.312 34.773 165.312 22.4011 177.684C10.0293 190.056 10.0293 210.114 22.4011 222.486C34.7729 234.858 54.8316 234.858 67.2034 222.486Z;M68.3362 223.272C81.1426 211.35 81.8601 191.305 69.9388 178.498C58.0175 165.692 37.9716 164.974 25.1652 176.895C12.3587 188.817 11.6412 208.863 23.5625 221.669C35.4839 234.476 55.5297 235.193 68.3362 223.272Z;M67.2034 222.486C79.5753 210.114 79.5752 190.056 67.2034 177.684C54.8316 165.312 34.773 165.312 22.4011 177.684C10.0293 190.056 10.0293 210.114 22.4011 222.486C34.7729 234.858 54.8316 234.858 67.2034 222.486Z"
                            begin="0s"
                            dur="1.6s"
                            repeatCount="indefinite"
                            fill="freeze"
                            calcMode="linear"
                            keyTimes="0;0.5;1"
                          />
                        </path>
                        <g id="Group_5">
                          <path
                            id="Vector_2"
                            d="M24.3608 175.88C16.9908 182.11 12.5508 191.61 13.1708 201.98C13.5608 208.58 15.9508 214.58 19.7108 219.45C15.7208 205.18 17.8308 189.76 24.3608 175.88Z"
                            fill="#FFE4C7"
                          >
                            <animate
                              attributeName="d"
                              values="M24.3608 175.88C16.9908 182.11 12.5508 191.61 13.1708 201.98C13.5608 208.58 15.9508 214.58 19.7108 219.45C15.7208 205.18 17.8308 189.76 24.3608 175.88Z;M27.1883 175.163C19.6001 181.125 14.8231 190.46 15.0718 200.846C15.2255 207.455 17.3993 213.537 20.9827 218.538C17.5057 204.135 20.1659 188.8 27.1883 175.163Z;M24.3608 175.88C16.9908 182.11 12.5508 191.61 13.1708 201.98C13.5608 208.58 15.9508 214.58 19.7108 219.45C15.7208 205.18 17.8308 189.76 24.3608 175.88Z"
                              begin="0s"
                              dur="1.6s"
                              repeatCount="indefinite"
                              fill="freeze"
                              calcMode="linear"
                              keyTimes="0;0.5;1"
                            />
                          </path>
                          <path
                            id="Vector_3"
                            d="M51.5907 231.01C52.1507 230.09 52.6707 229.17 53.1507 228.24C62.7307 209.72 57.5107 188.17 51.9507 173.78C51.2207 172.56 50.4907 171.34 49.7707 170.11C46.5807 170.24 43.4007 170.38 40.2107 170.51C37.5607 173.88 29.4107 185.13 29.3507 201.64C29.2907 216.91 36.2007 227.61 38.7707 231.23C40.2907 231.59 42.2307 231.9 44.4707 231.92C47.3707 231.95 49.8107 231.49 51.5807 231.01L51.5907 231.01Z"
                            fill="#DE2D35"
                          >
                            <animate
                              attributeName="d"
                              values="M51.5907 231.01C52.1507 230.09 52.6707 229.17 53.1507 228.24C62.7307 209.72 57.5107 188.17 51.9507 173.78C51.2207 172.56 50.4907 171.34 49.7707 170.11C46.5807 170.24 43.4007 170.38 40.2107 170.51C37.5607 173.88 29.4107 185.13 29.3507 201.64C29.2907 216.91 36.2007 227.61 38.7707 231.23C40.2907 231.59 42.2307 231.9 44.4707 231.92C47.3707 231.95 49.8107 231.49 51.5807 231.01L51.5907 231.01Z;M52.4288 231.232C53.0213 230.332 53.5739 229.432 54.0869 228.519C64.3232 210.354 59.8774 188.631 54.8357 174.051C54.1499 172.806 53.464 171.561 52.7884 170.306C49.5958 170.321 46.4128 170.348 43.2202 170.363C40.4514 173.636 31.9042 184.588 31.2536 201.085C30.6474 216.343 37.1702 227.283 39.6091 230.993C41.1153 231.407 43.0429 231.786 45.2808 231.887C48.1778 232.02 50.6327 231.648 52.4188 231.231L52.4288 231.232Z;M51.5907 231.01C52.1507 230.09 52.6707 229.17 53.1507 228.24C62.7307 209.72 57.5107 188.17 51.9507 173.78C51.2207 172.56 50.4907 171.34 49.7707 170.11C46.5807 170.24 43.4007 170.38 40.2107 170.51C37.5607 173.88 29.4107 185.13 29.3507 201.64C29.2907 216.91 36.2007 227.61 38.7707 231.23C40.2907 231.59 42.2307 231.9 44.4707 231.92C47.3707 231.95 49.8107 231.49 51.5807 231.01L51.5907 231.01Z"
                              begin="0s"
                              dur="1.6s"
                              repeatCount="indefinite"
                              fill="freeze"
                              calcMode="linear"
                              keyTimes="0;0.5;1"
                            />
                          </path>
                          <path
                            id="Vector_4"
                            d="M65.9407 176.5C71.3607 191.37 71.5907 207.28 67.3007 222.38C73.4107 216.2 76.9807 207.55 76.4207 198.2C75.9007 189.52 71.9407 181.88 65.9407 176.5Z"
                            fill="#FFE4C7"
                          >
                            <animate
                              attributeName="d"
                              values="M65.9407 176.5C71.3607 191.37 71.5907 207.28 67.3007 222.38C73.4107 216.2 76.9807 207.55 76.4207 198.2C75.9007 189.52 71.9407 181.88 65.9407 176.5Z;M68.7195 177.27C73.6041 192.324 73.2648 208.232 68.4374 223.169C74.7646 217.211 78.6417 208.695 78.4165 199.331C78.2074 190.637 74.5232 182.861 68.7195 177.27Z;M65.9407 176.5C71.3607 191.37 71.5907 207.28 67.3007 222.38C73.4107 216.2 76.9807 207.55 76.4207 198.2C75.9007 189.52 71.9407 181.88 65.9407 176.5Z"
                              begin="0s"
                              dur="1.6s"
                              repeatCount="indefinite"
                              fill="freeze"
                              calcMode="linear"
                              keyTimes="0;0.5;1"
                            />
                          </path>
                        </g>
                        <g id="Group_6">
                          <path
                            id="Vector_5"
                            d="M38.243 159.225L47.7062 158.659C50.8605 158.471 53.5687 160.873 53.7572 164.028L54.0966 169.708L33.2239 170.955L32.8844 165.275C32.6959 162.121 35.0987 159.413 38.253 159.224L38.243 159.225Z"
                            fill="#F8B000"
                            stroke="#F8B000"
                            stroke-width="0.7"
                            stroke-miterlimit="10"
                          >
                            <animate
                              attributeName="d"
                              values="M38.243 159.225L47.7062 158.659C50.8605 158.471 53.5687 160.873 53.7572 164.028L54.0966 169.708L33.2239 170.955L32.8844 165.275C32.6959 162.121 35.0987 159.413 38.253 159.224L38.243 159.225Z;M41.6573 159.015L51.1346 158.789C54.2937 158.713 56.9142 161.211 56.9898 164.37L57.1258 170.059L36.2218 170.559L36.0857 164.87C36.0102 161.711 38.5082 159.091 41.6673 159.015L41.6573 159.015Z;M38.243 159.225L47.7062 158.659C50.8605 158.471 53.5687 160.873 53.7572 164.028L54.0966 169.708L33.2239 170.955L32.8844 165.275C32.6959 162.121 35.0987 159.413 38.253 159.224L38.243 159.225Z"
                              begin="0s"
                              dur="1.6s"
                              repeatCount="indefinite"
                              fill="freeze"
                              calcMode="linear"
                              keyTimes="0;0.5;1"
                            />
                          </path>
                          <path
                            id="Vector_6"
                            d="M40.6808 160.09C40.1808 158.87 39.5808 157.5 40.0108 156.18C39.9408 156.39 40.0608 156.08 40.1008 156.03C40.1308 155.98 40.2608 155.8 40.1508 155.94C40.2308 155.84 40.3208 155.74 40.4208 155.65C40.4608 155.61 40.7008 155.4 40.6008 155.48C40.8008 155.33 41.0108 155.19 41.2308 155.07C41.3408 155.01 41.4608 154.95 41.5708 154.9C41.7508 154.82 41.6408 154.86 41.8308 154.79C42.0708 154.71 42.3108 154.63 42.5608 154.58C42.6808 154.55 42.8008 154.53 42.9308 154.51C42.7608 154.54 43.0908 154.5 43.1608 154.5C43.2708 154.5 43.3908 154.5 43.5008 154.5C43.5908 154.5 43.8308 154.55 43.6308 154.5C43.9808 154.58 44.0008 154.58 44.2508 154.72C44.2708 154.73 44.4408 154.86 44.3508 154.79C44.2708 154.73 44.4008 154.84 44.4008 154.84C44.4908 154.92 44.5708 155.01 44.6508 155.1C44.7608 155.23 44.5808 154.99 44.6708 155.14C44.7008 155.18 44.7308 155.23 44.7608 155.27C44.8408 155.39 44.9108 155.52 44.9708 155.65C45.1108 155.92 45.1108 155.94 45.2208 156.23C45.3308 156.52 45.4308 156.83 45.5308 157.12C45.9808 158.51 45.8708 159.99 45.2908 161.33C45.0708 161.85 45.1308 162.46 45.6708 162.77C46.1108 163.03 46.8808 162.92 47.1108 162.39C47.8308 160.72 48.1508 158.89 47.7108 157.09C47.5308 156.34 47.2408 155.59 46.9308 154.89C46.6708 154.3 46.3108 153.72 45.8208 153.29C44.6808 152.31 43.1608 152.24 41.7608 152.62C40.4408 152.98 39.1108 153.73 38.3408 154.89C37.1908 156.64 37.9408 158.9 38.6608 160.65C38.8808 161.18 39.3608 161.55 39.9508 161.38C40.4508 161.24 40.9008 160.62 40.6808 160.09Z"
                            fill="#F8B000"
                          >
                            <animate
                              attributeName="d"
                              values="M40.6808 160.09C40.1808 158.87 39.5808 157.5 40.0108 156.18C39.9408 156.39 40.0608 156.08 40.1008 156.03C40.1308 155.98 40.2608 155.8 40.1508 155.94C40.2308 155.84 40.3208 155.74 40.4208 155.65C40.4608 155.61 40.7008 155.4 40.6008 155.48C40.8008 155.33 41.0108 155.19 41.2308 155.07C41.3408 155.01 41.4608 154.95 41.5708 154.9C41.7508 154.82 41.6408 154.86 41.8308 154.79C42.0708 154.71 42.3108 154.63 42.5608 154.58C42.6808 154.55 42.8008 154.53 42.9308 154.51C42.7608 154.54 43.0908 154.5 43.1608 154.5C43.2708 154.5 43.3908 154.5 43.5008 154.5C43.5908 154.5 43.8308 154.55 43.6308 154.5C43.9808 154.58 44.0008 154.58 44.2508 154.72C44.2708 154.73 44.4408 154.86 44.3508 154.79C44.2708 154.73 44.4008 154.84 44.4008 154.84C44.4908 154.92 44.5708 155.01 44.6508 155.1C44.7608 155.23 44.5808 154.99 44.6708 155.14C44.7008 155.18 44.7308 155.23 44.7608 155.27C44.8408 155.39 44.9108 155.52 44.9708 155.65C45.1108 155.92 45.1108 155.94 45.2208 156.23C45.3308 156.52 45.4308 156.83 45.5308 157.12C45.9808 158.51 45.8708 159.99 45.2908 161.33C45.0708 161.85 45.1308 162.46 45.6708 162.77C46.1108 163.03 46.8808 162.92 47.1108 162.39C47.8308 160.72 48.1508 158.89 47.7108 157.09C47.5308 156.34 47.2408 155.59 46.9308 154.89C46.6708 154.3 46.3108 153.72 45.8208 153.29C44.6808 152.31 43.1608 152.24 41.7608 152.62C40.4408 152.98 39.1108 153.73 38.3408 154.89C37.1908 156.64 37.9408 158.9 38.6608 160.65C38.8808 161.18 39.3608 161.55 39.9508 161.38C40.4508 161.24 40.9008 160.62 40.6808 160.09Z;M44.0625 159.967C43.6065 158.73 43.0559 157.339 43.5328 156.035C43.4553 156.243 43.5863 155.937 43.6281 155.889C43.6599 155.84 43.7962 155.664 43.6813 155.8C43.7648 155.703 43.8583 155.607 43.9615 155.52C44.0029 155.482 44.2503 155.28 44.1475 155.357C44.3527 155.214 44.5676 155.082 44.7917 154.97C44.9038 154.914 45.0259 154.858 45.1376 154.812C45.3203 154.738 45.209 154.774 45.4014 154.711C45.6441 154.64 45.8868 154.568 46.1384 154.527C46.2594 154.502 46.38 154.486 46.5107 154.471C46.3397 154.495 46.6709 154.466 46.7409 154.469C46.8508 154.473 46.9707 154.477 47.0807 154.481C47.1706 154.484 47.4087 154.543 47.2106 154.486C47.5575 154.578 47.5775 154.579 47.8223 154.728C47.8419 154.739 48.0072 154.874 47.9197 154.801C47.8419 154.738 47.9679 154.853 47.9679 154.853C48.055 154.936 48.1317 155.029 48.2085 155.122C48.3137 155.256 48.1424 155.009 48.227 155.163C48.2556 155.204 48.2838 155.255 48.3123 155.296C48.388 155.418 48.4533 155.551 48.5086 155.683C48.6388 155.958 48.6381 155.978 48.7377 156.272C48.8372 156.565 48.9261 156.879 49.0156 157.172C49.4156 158.577 49.2528 160.052 48.6252 161.371C48.3867 161.883 48.4249 162.494 48.9534 162.823C49.3839 163.099 50.1573 163.017 50.4061 162.495C51.1854 160.852 51.5706 159.035 51.1953 157.22C51.0423 156.464 50.7793 155.704 50.4945 154.994C50.2558 154.395 49.9168 153.802 49.4425 153.355C48.3382 152.335 46.8217 152.21 45.409 152.54C44.077 152.853 42.721 153.555 41.91 154.686C40.6981 156.394 41.3668 158.679 42.0238 160.454C42.2247 160.992 42.6911 161.378 43.2868 161.23C43.7915 161.108 44.2634 160.504 44.0625 159.967Z;M40.6808 160.09C40.1808 158.87 39.5808 157.5 40.0108 156.18C39.9408 156.39 40.0608 156.08 40.1008 156.03C40.1308 155.98 40.2608 155.8 40.1508 155.94C40.2308 155.84 40.3208 155.74 40.4208 155.65C40.4608 155.61 40.7008 155.4 40.6008 155.48C40.8008 155.33 41.0108 155.19 41.2308 155.07C41.3408 155.01 41.4608 154.95 41.5708 154.9C41.7508 154.82 41.6408 154.86 41.8308 154.79C42.0708 154.71 42.3108 154.63 42.5608 154.58C42.6808 154.55 42.8008 154.53 42.9308 154.51C42.7608 154.54 43.0908 154.5 43.1608 154.5C43.2708 154.5 43.3908 154.5 43.5008 154.5C43.5908 154.5 43.8308 154.55 43.6308 154.5C43.9808 154.58 44.0008 154.58 44.2508 154.72C44.2708 154.73 44.4408 154.86 44.3508 154.79C44.2708 154.73 44.4008 154.84 44.4008 154.84C44.4908 154.92 44.5708 155.01 44.6508 155.1C44.7608 155.23 44.5808 154.99 44.6708 155.14C44.7008 155.18 44.7308 155.23 44.7608 155.27C44.8408 155.39 44.9108 155.52 44.9708 155.65C45.1108 155.92 45.1108 155.94 45.2208 156.23C45.3308 156.52 45.4308 156.83 45.5308 157.12C45.9808 158.51 45.8708 159.99 45.2908 161.33C45.0708 161.85 45.1308 162.46 45.6708 162.77C46.1108 163.03 46.8808 162.92 47.1108 162.39C47.8308 160.72 48.1508 158.89 47.7108 157.09C47.5308 156.34 47.2408 155.59 46.9308 154.89C46.6708 154.3 46.3108 153.72 45.8208 153.29C44.6808 152.31 43.1608 152.24 41.7608 152.62C40.4408 152.98 39.1108 153.73 38.3408 154.89C37.1908 156.64 37.9408 158.9 38.6608 160.65C38.8808 161.18 39.3608 161.55 39.9508 161.38C40.4508 161.24 40.9008 160.62 40.6808 160.09Z"
                              begin="0s"
                              dur="1.6s"
                              repeatCount="indefinite"
                              fill="freeze"
                              calcMode="linear"
                              keyTimes="0;0.5;1"
                            />
                          </path>
                        </g>
                      </g>
                      <g id="Group_7" style="mix-blend-mode: multiply" opacity="0.48">
                        <path
                          id="Vector_7"
                          d="M71.7308 210.69C62.4008 218.91 49.5108 220.66 38.2608 215.58C27.4008 210.67 20.6108 199.92 20.6808 188.02C20.7008 184.47 21.2908 181.03 22.3408 177.76C16.2008 183.94 12.6208 192.6 13.1808 201.98C14.2208 219.45 29.2308 232.76 46.7008 231.72C61.5208 230.83 73.3408 219.9 75.9508 205.94C74.7808 207.64 73.3908 209.24 71.7408 210.69L71.7308 210.69Z"
                          fill="#DE2D35"
                        >
                          <animate
                            attributeName="d"
                            values="M71.7308 210.69C62.4008 218.91 49.5108 220.66 38.2608 215.58C27.4008 210.67 20.6108 199.92 20.6808 188.02C20.7008 184.47 21.2908 181.03 22.3408 177.76C16.2008 183.94 12.6208 192.6 13.1808 201.98C14.2208 219.45 29.2308 232.76 46.7008 231.72C61.5208 230.83 73.3408 219.9 75.9508 205.94C74.7808 207.64 73.3908 209.24 71.7408 210.69L71.7308 210.69Z;M73.2827 211.645C63.6646 219.526 50.7203 220.814 39.6592 215.335C28.9818 210.039 22.5807 199.053 23.0763 187.163C23.2233 183.616 23.936 180.2 25.1023 176.969C18.7451 182.926 14.8577 191.452 15.0818 200.846C15.4962 218.342 30.0204 232.181 47.5165 231.766C62.3588 231.407 74.5622 220.907 77.6699 207.049C76.4399 208.706 74.9935 210.255 73.2927 211.645L73.2827 211.645Z;M71.7308 210.69C62.4008 218.91 49.5108 220.66 38.2608 215.58C27.4008 210.67 20.6108 199.92 20.6808 188.02C20.7008 184.47 21.2908 181.03 22.3408 177.76C16.2008 183.94 12.6208 192.6 13.1808 201.98C14.2208 219.45 29.2308 232.76 46.7008 231.72C61.5208 230.83 73.3408 219.9 75.9508 205.94C74.7808 207.64 73.3908 209.24 71.7408 210.69L71.7308 210.69Z"
                            begin="0s"
                            dur="1.6s"
                            repeatCount="indefinite"
                            fill="freeze"
                            calcMode="linear"
                            keyTimes="0;0.5;1"
                          />
                        </path>
                      </g>
                    </g>
                    <g id="Group 74">
                      <rect
                        id="Rectangle 21"
                        x="35"
                        y="189.256"
                        width="6.66667"
                        height="24.4444"
                        rx="3.33333"
                        fill="#FFE4C7"
                      >
                        <animate
                          attributeName="x"
                          values="35;37.342;35"
                          begin="0s"
                          dur="1.6s"
                          repeatCount="indefinite"
                          fill="freeze"
                          calcMode="linear"
                          keyTimes="0;0.5;1"
                        />
                        <animate
                          attributeName="y"
                          values="189.256;188.911;189.256"
                          begin="0s"
                          dur="1.6s"
                          repeatCount="indefinite"
                          fill="freeze"
                          calcMode="linear"
                          keyTimes="0;0.5;1"
                        />
                        <animateTransform
                          attributeName="transform"
                          type="rotate"
                          values="0 35 189.256;2.05 37.342 188.911;0 35 189.256"
                          begin="0s"
                          dur="1.6s"
                          repeatCount="indefinite"
                          fill="freeze"
                          calcMode="linear"
                          keyTimes="0;0.5;1"
                        />
                      </rect>
                      <rect id="Rectangle 22" x="48" y="189" width="6.66667" height="24.4444" rx="3.33333" fill="#FFE4C7">
                        <animate
                          attributeName="x"
                          values="48;50.3428;48"
                          begin="0s"
                          dur="1.6s"
                          repeatCount="indefinite"
                          fill="freeze"
                          calcMode="linear"
                          keyTimes="0;0.5;1"
                        />
                        <animate
                          attributeName="y"
                          values="189;189.12;189"
                          begin="0s"
                          dur="1.6s"
                          repeatCount="indefinite"
                          fill="freeze"
                          calcMode="linear"
                          keyTimes="0;0.5;1"
                        />
                        <animateTransform
                          attributeName="transform"
                          type="rotate"
                          values="0 48 189;2.05 50.3428 189.12;0 48 189"
                          begin="0s"
                          dur="1.6s"
                          repeatCount="indefinite"
                          fill="freeze"
                          calcMode="linear"
                          keyTimes="0;0.5;1"
                        />
                      </rect>
                    </g>
                  </g>
                  <g id="Group_8">
                    <g id="Group_9">
                      <g id="Group_10">
                        <g id="Group_11">
                          <path
                            id="Vector_8"
                            d="M67.7287 258.222C74.6214 258.154 80.1535 252.511 80.0849 245.618C80.0163 238.725 74.3731 233.193 67.4804 233.262C60.5877 233.33 55.0556 238.973 55.1242 245.866C55.1927 252.759 60.836 258.291 67.7287 258.222Z"
                            fill="#2EBF8F"
                          >
                            <animate
                              attributeName="d"
                              values="M67.7287 258.222C74.6214 258.154 80.1535 252.511 80.0849 245.618C80.0163 238.725 74.3731 233.193 67.4804 233.262C60.5877 233.33 55.0556 238.973 55.1242 245.866C55.1927 252.759 60.836 258.291 67.7287 258.222Z;M69.7287 258.222C76.6214 258.154 82.1535 252.511 82.0849 245.618C82.0163 238.725 76.3731 233.193 69.4804 233.262C62.5877 233.33 57.0556 238.973 57.1242 245.866C57.1927 252.759 62.836 258.291 69.7287 258.222Z;M67.7287 258.222C74.6214 258.154 80.1535 252.511 80.0849 245.618C80.0163 238.725 74.3731 233.193 67.4804 233.262C60.5877 233.33 55.0556 238.973 55.1242 245.866C55.1927 252.759 60.836 258.291 67.7287 258.222Z"
                              begin="0s"
                              dur="1.6s"
                              repeatCount="indefinite"
                              fill="freeze"
                              calcMode="linear"
                              keyTimes="0;0.5;1"
                            />
                          </path>
                          <g id="Group_12">
                            <path
                              id="Vector_9"
                              d="M61.6409 236.872C62.878 236.668 64.1464 236.407 65.4045 236.616C67.9675 237.044 68.9854 238.73 70.0189 240.881C70.7706 242.437 71.6371 242.781 73.1822 242.097C74.2889 241.601 75.2807 241.1 76.4813 240.85C77.3217 240.677 78.1673 240.604 78.9973 240.641C77.3269 236.914 73.8608 234.085 69.5283 233.406C65.394 232.764 61.4216 234.231 58.6968 237.002C59.5737 237.363 60.7743 237.013 61.6409 236.872Z"
                              fill="#FFE4C7"
                            >
                              <animate
                                attributeName="d"
                                values="M61.6409 236.872C62.878 236.668 64.1464 236.407 65.4045 236.616C67.9675 237.044 68.9854 238.73 70.0189 240.881C70.7706 242.437 71.6371 242.781 73.1822 242.097C74.2889 241.601 75.2807 241.1 76.4813 240.85C77.3217 240.677 78.1673 240.604 78.9973 240.641C77.3269 236.914 73.8608 234.085 69.5283 233.406C65.394 232.764 61.4216 234.231 58.6968 237.002C59.5737 237.363 60.7743 237.013 61.6409 236.872Z;M63.6409 236.872C64.878 236.668 66.1464 236.407 67.4045 236.616C69.9675 237.044 70.9854 238.73 72.0189 240.881C72.7706 242.437 73.6371 242.781 75.1822 242.097C76.2889 241.601 77.2807 241.1 78.4813 240.85C79.3217 240.677 80.1673 240.604 80.9973 240.641C79.3269 236.914 75.8608 234.085 71.5283 233.406C67.394 232.764 63.4216 234.231 60.6968 237.002C61.5737 237.363 62.7743 237.013 63.6409 236.872Z;M61.6409 236.872C62.878 236.668 64.1464 236.407 65.4045 236.616C67.9675 237.044 68.9854 238.73 70.0189 240.881C70.7706 242.437 71.6371 242.781 73.1822 242.097C74.2889 241.601 75.2807 241.1 76.4813 240.85C77.3217 240.677 78.1673 240.604 78.9973 240.641C77.3269 236.914 73.8608 234.085 69.5283 233.406C65.394 232.764 61.4216 234.231 58.6968 237.002C59.5737 237.363 60.7743 237.013 61.6409 236.872Z"
                                begin="0s"
                                dur="1.6s"
                                repeatCount="indefinite"
                                fill="freeze"
                                calcMode="linear"
                                keyTimes="0;0.5;1"
                              />
                            </path>
                            <path
                              id="Vector_10"
                              d="M73.9286 245.85C71.3709 246.847 68.8183 245.981 67.2836 243.679C66.7198 242.833 66.5267 241.471 65.7959 240.771C65.0077 240.02 63.7862 240.301 62.8362 240.448C60.6072 240.782 58.4201 241.225 56.4887 240.056C55.8988 241.205 55.4812 242.468 55.2724 243.815C55.1419 244.655 55.1001 245.49 55.1367 246.304C55.8309 246.263 56.567 246.017 57.1307 245.876C58.5401 245.516 59.9652 245.041 61.4268 244.921C64.3656 244.676 66.2031 246.524 67.7377 248.768C68.4268 249.776 69.1315 250.83 70.4574 250.856C71.7154 250.877 72.9995 250.439 74.2262 250.214C75.9853 249.891 77.6714 249.927 79.0912 250.648C79.4932 249.713 79.7855 248.711 79.9473 247.656C80.1091 246.602 80.1352 245.563 80.0413 244.551C78.0316 243.914 75.9331 245.073 73.9391 245.85L73.9286 245.85Z"
                              fill="#FFE4C7"
                            >
                              <animate
                                attributeName="d"
                                values="M73.9286 245.85C71.3709 246.847 68.8183 245.981 67.2836 243.679C66.7198 242.833 66.5267 241.471 65.7959 240.771C65.0077 240.02 63.7862 240.301 62.8362 240.448C60.6072 240.782 58.4201 241.225 56.4887 240.056C55.8988 241.205 55.4812 242.468 55.2724 243.815C55.1419 244.655 55.1001 245.49 55.1367 246.304C55.8309 246.263 56.567 246.017 57.1307 245.876C58.5401 245.516 59.9652 245.041 61.4268 244.921C64.3656 244.676 66.2031 246.524 67.7377 248.768C68.4268 249.776 69.1315 250.83 70.4574 250.856C71.7154 250.877 72.9995 250.439 74.2262 250.214C75.9853 249.891 77.6714 249.927 79.0912 250.648C79.4932 249.713 79.7855 248.711 79.9473 247.656C80.1091 246.602 80.1352 245.563 80.0413 244.551C78.0316 243.914 75.9331 245.073 73.9391 245.85L73.9286 245.85Z;M75.9286 245.85C73.3709 246.847 70.8183 245.981 69.2836 243.679C68.7198 242.833 68.5267 241.471 67.7959 240.771C67.0077 240.02 65.7862 240.301 64.8362 240.448C62.6072 240.782 60.4201 241.225 58.4887 240.056C57.8988 241.205 57.4812 242.468 57.2724 243.815C57.1419 244.655 57.1001 245.49 57.1367 246.304C57.8309 246.263 58.567 246.017 59.1307 245.876C60.5401 245.516 61.9652 245.041 63.4268 244.921C66.3656 244.676 68.2031 246.524 69.7377 248.768C70.4268 249.776 71.1315 250.83 72.4574 250.856C73.7154 250.877 74.9995 250.439 76.2262 250.214C77.9853 249.891 79.6714 249.927 81.0912 250.648C81.4932 249.713 81.7855 248.711 81.9473 247.656C82.1091 246.602 82.1352 245.563 82.0413 244.551C80.0316 243.914 77.9331 245.073 75.9391 245.85L75.9286 245.85Z;M73.9286 245.85C71.3709 246.847 68.8183 245.981 67.2836 243.679C66.7198 242.833 66.5267 241.471 65.7959 240.771C65.0077 240.02 63.7862 240.301 62.8362 240.448C60.6072 240.782 58.4201 241.225 56.4887 240.056C55.8988 241.205 55.4812 242.468 55.2724 243.815C55.1419 244.655 55.1001 245.49 55.1367 246.304C55.8309 246.263 56.567 246.017 57.1307 245.876C58.5401 245.516 59.9652 245.041 61.4268 244.921C64.3656 244.676 66.2031 246.524 67.7377 248.768C68.4268 249.776 69.1315 250.83 70.4574 250.856C71.7154 250.877 72.9995 250.439 74.2262 250.214C75.9853 249.891 77.6714 249.927 79.0912 250.648C79.4932 249.713 79.7855 248.711 79.9473 247.656C80.1091 246.602 80.1352 245.563 80.0413 244.551C78.0316 243.914 75.9331 245.073 73.9391 245.85L73.9286 245.85Z"
                                begin="0s"
                                dur="1.6s"
                                repeatCount="indefinite"
                                fill="freeze"
                                calcMode="linear"
                                keyTimes="0;0.5;1"
                              />
                            </path>
                            <path
                              id="Vector_11"
                              d="M68.8549 256.139C69.7736 256.426 70.2434 257.178 70.2747 257.935C72.9369 257.35 75.3277 255.909 77.0816 253.863C75.4008 253.216 72.6342 254.469 71.0682 254.589C68.3381 254.792 66.3702 253.378 64.8512 251.217C64.1882 250.272 63.5462 248.862 62.2777 248.653C61.1032 248.46 59.6834 249.087 58.5715 249.379C57.6946 249.609 56.7706 249.833 55.8467 249.943C56.1703 250.846 56.6036 251.702 57.1204 252.501C61.6043 250.862 64.8146 254.865 68.8549 256.139Z"
                              fill="#FFE4C7"
                            >
                              <animate
                                attributeName="d"
                                values="M68.8549 256.139C69.7736 256.426 70.2434 257.178 70.2747 257.935C72.9369 257.35 75.3277 255.909 77.0816 253.863C75.4008 253.216 72.6342 254.469 71.0682 254.589C68.3381 254.792 66.3702 253.378 64.8512 251.217C64.1882 250.272 63.5462 248.862 62.2777 248.653C61.1032 248.46 59.6834 249.087 58.5715 249.379C57.6946 249.609 56.7706 249.833 55.8467 249.943C56.1703 250.846 56.6036 251.702 57.1204 252.501C61.6043 250.862 64.8146 254.865 68.8549 256.139Z;M70.8549 256.139C71.7736 256.426 72.2434 257.178 72.2747 257.935C74.9369 257.35 77.3277 255.909 79.0816 253.863C77.4008 253.216 74.6342 254.469 73.0682 254.589C70.3381 254.792 68.3702 253.378 66.8512 251.217C66.1882 250.272 65.5462 248.862 64.2777 248.653C63.1032 248.46 61.6834 249.087 60.5715 249.379C59.6946 249.609 58.7706 249.833 57.8467 249.943C58.1703 250.846 58.6036 251.702 59.1204 252.501C63.6043 250.862 66.8146 254.865 70.8549 256.139Z;M68.8549 256.139C69.7736 256.426 70.2434 257.178 70.2747 257.935C72.9369 257.35 75.3277 255.909 77.0816 253.863C75.4008 253.216 72.6342 254.469 71.0682 254.589C68.3381 254.792 66.3702 253.378 64.8512 251.217C64.1882 250.272 63.5462 248.862 62.2777 248.653C61.1032 248.46 59.6834 249.087 58.5715 249.379C57.6946 249.609 56.7706 249.833 55.8467 249.943C56.1703 250.846 56.6036 251.702 57.1204 252.501C61.6043 250.862 64.8146 254.865 68.8549 256.139Z"
                                begin="0s"
                                dur="1.6s"
                                repeatCount="indefinite"
                                fill="freeze"
                                calcMode="linear"
                                keyTimes="0;0.5;1"
                              />
                            </path>
                          </g>
                        </g>
                        <g id="Group_13">
                          <path
                            id="Vector_12"
                            d="M68.5031 229.457L72.1909 230.031C73.4185 230.222 74.259 231.373 74.0678 232.6L73.7233 234.813L65.5842 233.546L65.9288 231.333C66.1199 230.105 67.2704 229.265 68.4979 229.456L68.5031 229.457Z"
                            fill="#F8B000"
                            stroke="#F8B000"
                            stroke-width="0.83"
                            stroke-miterlimit="10"
                          >
                            <animate
                              attributeName="d"
                              values="M68.5031 229.457L72.1909 230.031C73.4185 230.222 74.259 231.373 74.0678 232.6L73.7233 234.813L65.5842 233.546L65.9288 231.333C66.1199 230.105 67.2704 229.265 68.4979 229.456L68.5031 229.457Z;M70.5031 229.457L74.1909 230.031C75.4185 230.222 76.259 231.373 76.0678 232.6L75.7233 234.813L67.5842 233.546L67.9288 231.333C68.1199 230.105 69.2704 229.265 70.4979 229.456L70.5031 229.457Z;M68.5031 229.457L72.1909 230.031C73.4185 230.222 74.259 231.373 74.0678 232.6L73.7233 234.813L65.5842 233.546L65.9288 231.333C66.1199 230.105 67.2704 229.265 68.4979 229.456L68.5031 229.457Z"
                              begin="0s"
                              dur="1.6s"
                              repeatCount="indefinite"
                              fill="freeze"
                              calcMode="linear"
                              keyTimes="0;0.5;1"
                            />
                          </path>
                          <path
                            id="Vector_13"
                            d="M69.5803 229.846C69.5699 229.783 69.5594 229.715 69.549 229.653C69.5438 229.606 69.5177 229.444 69.5333 229.574C69.5177 229.433 69.502 229.298 69.502 229.157C69.502 229.094 69.502 229.026 69.502 228.964C69.502 228.937 69.502 228.911 69.5072 228.88C69.5124 228.786 69.4811 228.984 69.5072 228.89C69.5281 228.833 69.5385 228.77 69.5542 228.708C69.5542 228.697 69.5855 228.614 69.5542 228.687C69.5229 228.77 69.5803 228.635 69.5907 228.619C69.6012 228.598 69.6168 228.577 69.6273 228.556C69.6586 228.488 69.5333 228.656 69.5907 228.603C69.6221 228.572 69.6534 228.541 69.6795 228.509C69.7578 228.431 69.5751 228.577 69.669 228.515C69.716 228.489 69.7578 228.457 69.8048 228.431C69.8309 228.415 69.857 228.405 69.8778 228.395C69.9666 228.348 69.8413 228.41 69.8413 228.41C69.8413 228.395 69.9457 228.374 69.9614 228.368C70.0658 228.332 70.1754 228.311 70.285 228.29C70.4468 228.259 70.191 228.29 70.3111 228.29C70.3633 228.29 70.4155 228.28 70.4625 228.28C70.5564 228.28 70.6922 228.311 70.7809 228.295C70.7652 228.295 70.6243 228.264 70.7287 228.295C70.7496 228.295 70.7652 228.306 70.7861 228.306C70.8279 228.316 70.8696 228.332 70.9114 228.342C70.974 228.342 70.9427 228.353 70.9114 228.342C70.8279 228.337 70.901 228.342 70.9375 228.358C70.9584 228.368 70.9793 228.384 70.9949 228.395C71.0993 228.457 70.9584 228.337 70.9845 228.389C70.9897 228.405 71.021 228.426 71.0315 228.436C71.1254 228.52 71.0001 228.405 71.0106 228.405C71.021 228.405 71.0837 228.525 71.0889 228.53C71.162 228.656 71.068 228.447 71.0993 228.551C71.115 228.609 71.1359 228.666 71.1515 228.723C71.1724 228.812 71.1672 228.969 71.2142 229.047C71.2142 229.047 71.1985 228.917 71.2089 228.995C71.2089 229.021 71.2142 229.042 71.2194 229.068C71.2246 229.131 71.235 229.198 71.2403 229.266C71.2559 229.428 71.2507 229.585 71.2455 229.752C71.2455 229.825 71.2455 229.736 71.2507 229.726C71.2455 229.773 71.235 229.82 71.2246 229.867C71.2089 229.945 71.1881 230.018 71.1672 230.091C71.1463 230.164 71.115 230.237 71.0889 230.31C71.0628 230.383 71.0889 230.3 71.0993 230.289C71.0784 230.331 71.0576 230.378 71.0367 230.42C70.9584 230.566 70.8749 230.707 70.7757 230.843C70.5773 231.119 70.7183 231.574 71.0106 231.73C71.3447 231.908 71.684 231.793 71.898 231.495C72.3312 230.89 72.6027 230.117 72.5453 229.371C72.4983 228.729 72.4148 228.034 71.9658 227.538C71.5482 227.084 70.8696 226.949 70.2746 227.016C69.6795 227.084 69.027 227.272 68.6459 227.758C68.0769 228.473 68.1761 229.381 68.3223 230.222C68.3797 230.556 68.8077 230.775 69.1209 230.676C69.4811 230.561 69.6377 230.237 69.5751 229.877L69.5803 229.846Z"
                            fill="#F8B000"
                          >
                            <animate
                              attributeName="d"
                              values="M69.5803 229.846C69.5699 229.783 69.5594 229.715 69.549 229.653C69.5438 229.606 69.5177 229.444 69.5333 229.574C69.5177 229.433 69.502 229.298 69.502 229.157C69.502 229.094 69.502 229.026 69.502 228.964C69.502 228.937 69.502 228.911 69.5072 228.88C69.5124 228.786 69.4811 228.984 69.5072 228.89C69.5281 228.833 69.5385 228.77 69.5542 228.708C69.5542 228.697 69.5855 228.614 69.5542 228.687C69.5229 228.77 69.5803 228.635 69.5907 228.619C69.6012 228.598 69.6168 228.577 69.6273 228.556C69.6586 228.488 69.5333 228.656 69.5907 228.603C69.6221 228.572 69.6534 228.541 69.6795 228.509C69.7578 228.431 69.5751 228.577 69.669 228.515C69.716 228.489 69.7578 228.457 69.8048 228.431C69.8309 228.415 69.857 228.405 69.8778 228.395C69.9666 228.348 69.8413 228.41 69.8413 228.41C69.8413 228.395 69.9457 228.374 69.9614 228.368C70.0658 228.332 70.1754 228.311 70.285 228.29C70.4468 228.259 70.191 228.29 70.3111 228.29C70.3633 228.29 70.4155 228.28 70.4625 228.28C70.5564 228.28 70.6922 228.311 70.7809 228.295C70.7652 228.295 70.6243 228.264 70.7287 228.295C70.7496 228.295 70.7652 228.306 70.7861 228.306C70.8279 228.316 70.8696 228.332 70.9114 228.342C70.974 228.342 70.9427 228.353 70.9114 228.342C70.8279 228.337 70.901 228.342 70.9375 228.358C70.9584 228.368 70.9793 228.384 70.9949 228.395C71.0993 228.457 70.9584 228.337 70.9845 228.389C70.9897 228.405 71.021 228.426 71.0315 228.436C71.1254 228.52 71.0001 228.405 71.0106 228.405C71.021 228.405 71.0837 228.525 71.0889 228.53C71.162 228.656 71.068 228.447 71.0993 228.551C71.115 228.609 71.1359 228.666 71.1515 228.723C71.1724 228.812 71.1672 228.969 71.2142 229.047C71.2142 229.047 71.1985 228.917 71.2089 228.995C71.2089 229.021 71.2142 229.042 71.2194 229.068C71.2246 229.131 71.235 229.198 71.2403 229.266C71.2559 229.428 71.2507 229.585 71.2455 229.752C71.2455 229.825 71.2455 229.736 71.2507 229.726C71.2455 229.773 71.235 229.82 71.2246 229.867C71.2089 229.945 71.1881 230.018 71.1672 230.091C71.1463 230.164 71.115 230.237 71.0889 230.31C71.0628 230.383 71.0889 230.3 71.0993 230.289C71.0784 230.331 71.0576 230.378 71.0367 230.42C70.9584 230.566 70.8749 230.707 70.7757 230.843C70.5773 231.119 70.7183 231.574 71.0106 231.73C71.3447 231.908 71.684 231.793 71.898 231.495C72.3312 230.89 72.6027 230.117 72.5453 229.371C72.4983 228.729 72.4148 228.034 71.9658 227.538C71.5482 227.084 70.8696 226.949 70.2746 227.016C69.6795 227.084 69.027 227.272 68.6459 227.758C68.0769 228.473 68.1761 229.381 68.3223 230.222C68.3797 230.556 68.8077 230.775 69.1209 230.676C69.4811 230.561 69.6377 230.237 69.5751 229.877L69.5803 229.846Z;M71.5803 229.846C71.5699 229.783 71.5594 229.715 71.549 229.653C71.5438 229.606 71.5177 229.444 71.5333 229.574C71.5177 229.433 71.502 229.298 71.502 229.157C71.502 229.094 71.502 229.026 71.502 228.964C71.502 228.937 71.502 228.911 71.5072 228.88C71.5124 228.786 71.4811 228.984 71.5072 228.89C71.5281 228.833 71.5385 228.77 71.5542 228.708C71.5542 228.697 71.5855 228.614 71.5542 228.687C71.5229 228.77 71.5803 228.635 71.5907 228.619C71.6012 228.598 71.6168 228.577 71.6273 228.556C71.6586 228.488 71.5333 228.656 71.5907 228.603C71.6221 228.572 71.6534 228.541 71.6795 228.509C71.7578 228.431 71.5751 228.577 71.669 228.515C71.716 228.489 71.7578 228.457 71.8048 228.431C71.8309 228.415 71.857 228.405 71.8778 228.395C71.9666 228.348 71.8413 228.41 71.8413 228.41C71.8413 228.395 71.9457 228.374 71.9614 228.368C72.0658 228.332 72.1754 228.311 72.285 228.29C72.4468 228.259 72.191 228.29 72.3111 228.29C72.3633 228.29 72.4155 228.28 72.4625 228.28C72.5564 228.28 72.6922 228.311 72.7809 228.295C72.7652 228.295 72.6243 228.264 72.7287 228.295C72.7496 228.295 72.7652 228.306 72.7861 228.306C72.8279 228.316 72.8696 228.332 72.9114 228.342C72.974 228.342 72.9427 228.353 72.9114 228.342C72.8279 228.337 72.901 228.342 72.9375 228.358C72.9584 228.368 72.9793 228.384 72.9949 228.395C73.0993 228.457 72.9584 228.337 72.9845 228.389C72.9897 228.405 73.021 228.426 73.0315 228.436C73.1254 228.52 73.0001 228.405 73.0106 228.405C73.021 228.405 73.0837 228.525 73.0889 228.53C73.162 228.656 73.068 228.447 73.0993 228.551C73.115 228.609 73.1359 228.666 73.1515 228.723C73.1724 228.812 73.1672 228.969 73.2142 229.047C73.2142 229.047 73.1985 228.917 73.2089 228.995C73.2089 229.021 73.2142 229.042 73.2194 229.068C73.2246 229.131 73.235 229.198 73.2403 229.266C73.2559 229.428 73.2507 229.585 73.2455 229.752C73.2455 229.825 73.2455 229.736 73.2507 229.726C73.2455 229.773 73.235 229.82 73.2246 229.867C73.2089 229.945 73.1881 230.018 73.1672 230.091C73.1463 230.164 73.115 230.237 73.0889 230.31C73.0628 230.383 73.0889 230.3 73.0993 230.289C73.0784 230.331 73.0576 230.378 73.0367 230.42C72.9584 230.566 72.8749 230.707 72.7757 230.843C72.5773 231.119 72.7183 231.574 73.0106 231.73C73.3447 231.908 73.684 231.793 73.898 231.495C74.3312 230.89 74.6027 230.117 74.5453 229.371C74.4983 228.729 74.4148 228.034 73.9658 227.538C73.5482 227.084 72.8696 226.949 72.2746 227.016C71.6795 227.084 71.027 227.272 70.6459 227.758C70.0769 228.473 70.1761 229.381 70.3223 230.222C70.3797 230.556 70.8077 230.775 71.1209 230.676C71.4811 230.561 71.6377 230.237 71.5751 229.877L71.5803 229.846Z;M69.5803 229.846C69.5699 229.783 69.5594 229.715 69.549 229.653C69.5438 229.606 69.5177 229.444 69.5333 229.574C69.5177 229.433 69.502 229.298 69.502 229.157C69.502 229.094 69.502 229.026 69.502 228.964C69.502 228.937 69.502 228.911 69.5072 228.88C69.5124 228.786 69.4811 228.984 69.5072 228.89C69.5281 228.833 69.5385 228.77 69.5542 228.708C69.5542 228.697 69.5855 228.614 69.5542 228.687C69.5229 228.77 69.5803 228.635 69.5907 228.619C69.6012 228.598 69.6168 228.577 69.6273 228.556C69.6586 228.488 69.5333 228.656 69.5907 228.603C69.6221 228.572 69.6534 228.541 69.6795 228.509C69.7578 228.431 69.5751 228.577 69.669 228.515C69.716 228.489 69.7578 228.457 69.8048 228.431C69.8309 228.415 69.857 228.405 69.8778 228.395C69.9666 228.348 69.8413 228.41 69.8413 228.41C69.8413 228.395 69.9457 228.374 69.9614 228.368C70.0658 228.332 70.1754 228.311 70.285 228.29C70.4468 228.259 70.191 228.29 70.3111 228.29C70.3633 228.29 70.4155 228.28 70.4625 228.28C70.5564 228.28 70.6922 228.311 70.7809 228.295C70.7652 228.295 70.6243 228.264 70.7287 228.295C70.7496 228.295 70.7652 228.306 70.7861 228.306C70.8279 228.316 70.8696 228.332 70.9114 228.342C70.974 228.342 70.9427 228.353 70.9114 228.342C70.8279 228.337 70.901 228.342 70.9375 228.358C70.9584 228.368 70.9793 228.384 70.9949 228.395C71.0993 228.457 70.9584 228.337 70.9845 228.389C70.9897 228.405 71.021 228.426 71.0315 228.436C71.1254 228.52 71.0001 228.405 71.0106 228.405C71.021 228.405 71.0837 228.525 71.0889 228.53C71.162 228.656 71.068 228.447 71.0993 228.551C71.115 228.609 71.1359 228.666 71.1515 228.723C71.1724 228.812 71.1672 228.969 71.2142 229.047C71.2142 229.047 71.1985 228.917 71.2089 228.995C71.2089 229.021 71.2142 229.042 71.2194 229.068C71.2246 229.131 71.235 229.198 71.2403 229.266C71.2559 229.428 71.2507 229.585 71.2455 229.752C71.2455 229.825 71.2455 229.736 71.2507 229.726C71.2455 229.773 71.235 229.82 71.2246 229.867C71.2089 229.945 71.1881 230.018 71.1672 230.091C71.1463 230.164 71.115 230.237 71.0889 230.31C71.0628 230.383 71.0889 230.3 71.0993 230.289C71.0784 230.331 71.0576 230.378 71.0367 230.42C70.9584 230.566 70.8749 230.707 70.7757 230.843C70.5773 231.119 70.7183 231.574 71.0106 231.73C71.3447 231.908 71.684 231.793 71.898 231.495C72.3312 230.89 72.6027 230.117 72.5453 229.371C72.4983 228.729 72.4148 228.034 71.9658 227.538C71.5482 227.084 70.8696 226.949 70.2746 227.016C69.6795 227.084 69.027 227.272 68.6459 227.758C68.0769 228.473 68.1761 229.381 68.3223 230.222C68.3797 230.556 68.8077 230.775 69.1209 230.676C69.4811 230.561 69.6377 230.237 69.5751 229.877L69.5803 229.846Z"
                              begin="0s"
                              dur="1.6s"
                              repeatCount="indefinite"
                              fill="freeze"
                              calcMode="linear"
                              keyTimes="0;0.5;1"
                            />
                          </path>
                        </g>
                      </g>
                      <g id="Group_14">
                        <path
                          id="Vector_14"
                          d="M71.569 239.43C72.4042 239.43 72.4042 238.135 71.569 238.135C70.7338 238.135 70.7338 239.43 71.569 239.43Z"
                          fill="#2EBF8F"
                        >
                          <animate
                            attributeName="d"
                            values="M71.569 239.43C72.4042 239.43 72.4042 238.135 71.569 238.135C70.7338 238.135 70.7338 239.43 71.569 239.43Z;M73.569 239.43C74.4042 239.43 74.4042 238.135 73.569 238.135C72.7338 238.135 72.7338 239.43 73.569 239.43Z;M71.569 239.43C72.4042 239.43 72.4042 238.135 71.569 238.135C70.7338 238.135 70.7338 239.43 71.569 239.43Z"
                            begin="0s"
                            dur="1.6s"
                            repeatCount="indefinite"
                            fill="freeze"
                            calcMode="linear"
                            keyTimes="0;0.5;1"
                          />
                        </path>
                        <path
                          id="Vector_15"
                          d="M63.2746 242.927C64.1098 242.927 64.1098 241.633 63.2746 241.633C62.4394 241.633 62.4394 242.927 63.2746 242.927Z"
                          fill="#2EBF8F"
                        >
                          <animate
                            attributeName="d"
                            values="M63.2746 242.927C64.1098 242.927 64.1098 241.633 63.2746 241.633C62.4394 241.633 62.4394 242.927 63.2746 242.927Z;M65.2746 242.927C66.1098 242.927 66.1098 241.633 65.2746 241.633C64.4394 241.633 64.4394 242.927 65.2746 242.927Z;M63.2746 242.927C64.1098 242.927 64.1098 241.633 63.2746 241.633C62.4394 241.633 62.4394 242.927 63.2746 242.927Z"
                            begin="0s"
                            dur="1.6s"
                            repeatCount="indefinite"
                            fill="freeze"
                            calcMode="linear"
                            keyTimes="0;0.5;1"
                          />
                        </path>
                        <path
                          id="Vector_16"
                          d="M75.0925 248.22C75.9277 248.22 75.9277 246.926 75.0925 246.926C74.2573 246.926 74.2573 248.22 75.0925 248.22Z"
                          fill="#2EBF8F"
                        >
                          <animate
                            attributeName="d"
                            values="M75.0925 248.22C75.9277 248.22 75.9277 246.926 75.0925 246.926C74.2573 246.926 74.2573 248.22 75.0925 248.22Z;M77.0925 248.22C77.9277 248.22 77.9277 246.926 77.0925 246.926C76.2573 246.926 76.2573 248.22 77.0925 248.22Z;M75.0925 248.22C75.9277 248.22 75.9277 246.926 75.0925 246.926C74.2573 246.926 74.2573 248.22 75.0925 248.22Z"
                            begin="0s"
                            dur="1.6s"
                            repeatCount="indefinite"
                            fill="freeze"
                            calcMode="linear"
                            keyTimes="0;0.5;1"
                          />
                        </path>
                      </g>
                    </g>
                    <g id="Group_15" style="mix-blend-mode: multiply" opacity="0.48">
                      <path
                        id="Vector_17"
                        d="M77.0868 252.072C72.8064 254.458 67.6961 254.051 63.7915 251.154C60.0227 248.356 58.3053 243.647 59.3284 239.069C59.6312 237.702 60.148 236.428 60.8266 235.259C57.9451 237.122 55.8415 240.16 55.2725 243.814C54.2128 250.626 58.8743 257.01 65.6864 258.07C71.4649 258.968 76.9302 255.752 79.107 250.595C78.5119 251.148 77.8437 251.65 77.0868 252.072Z"
                        fill="#2EBF8F"
                      >
                        <animate
                          attributeName="d"
                          values="M77.0868 252.072C72.8064 254.458 67.6961 254.051 63.7915 251.154C60.0227 248.356 58.3053 243.647 59.3284 239.069C59.6312 237.702 60.148 236.428 60.8266 235.259C57.9451 237.122 55.8415 240.16 55.2725 243.814C54.2128 250.626 58.8743 257.01 65.6864 258.07C71.4649 258.968 76.9302 255.752 79.107 250.595C78.5119 251.148 77.8437 251.65 77.0868 252.072Z;M79.0868 252.072C74.8064 254.458 69.6961 254.051 65.7915 251.154C62.0227 248.356 60.3053 243.647 61.3284 239.069C61.6312 237.702 62.148 236.428 62.8266 235.259C59.9451 237.122 57.8415 240.16 57.2725 243.814C56.2128 250.626 60.8743 257.01 67.6864 258.07C73.4649 258.968 78.9302 255.752 81.107 250.595C80.5119 251.148 79.8437 251.65 79.0868 252.072Z;M77.0868 252.072C72.8064 254.458 67.6961 254.051 63.7915 251.154C60.0227 248.356 58.3053 243.647 59.3284 239.069C59.6312 237.702 60.148 236.428 60.8266 235.259C57.9451 237.122 55.8415 240.16 55.2725 243.814C54.2128 250.626 58.8743 257.01 65.6864 258.07C71.4649 258.968 76.9302 255.752 79.107 250.595C78.5119 251.148 77.8437 251.65 77.0868 252.072Z"
                          begin="0s"
                          dur="1.6s"
                          repeatCount="indefinite"
                          fill="freeze"
                          calcMode="linear"
                          keyTimes="0;0.5;1"
                        />
                      </path>
                    </g>
                  </g>
                </g>
              </g>
            </g>
          </svg>
        </media-play-button>
      </div>
      <media-control-bar>
        <media-time-range>
          <media-preview-thumbnail slot="preview"></media-preview-thumbnail>
          <media-preview-time-display slot="preview"></media-preview-time-display>
        </media-time-range>
        <div class="media-volume-wrapper">
          <media-mute-button class="icon-button">
            <svg slot="off" viewBox="0 0 23 18" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path
                d="M14.5 1.71821C13.75 0.575091 12.95 -0.509788 11.787 0.257212L5.788 4.21321C5.74701 4.24011 5.69903 4.25437 5.65 4.25421H2.75C2.02065 4.25421 1.32118 4.54394 0.805456 5.05967C0.289731 5.57539 0 6.27487 0 7.00421V10.7182C0 11.4476 0.289731 12.147 0.805456 12.6628C1.32118 13.1785 2.02065 13.4682 2.75 13.4682H5.65C5.69879 13.4685 5.74641 13.4831 5.787 13.5102L11.787 17.4652C12.95 18.2322 13.75 17.1472 14.5 16.0042C15.25 14.8612 15.8222 11.3848 15.75 8.36121C15.687 5.72219 15.25 2.86133 14.5 1.71821Z"
                fill="#F8B000"
              />
              <mask
                id="mask0_32_117"
                style="mask-type: alpha"
                maskUnits="userSpaceOnUse"
                x="0"
                y="0"
                width="16"
                height="18"
              >
                <path
                  d="M14.5 1.71821C13.75 0.575091 12.95 -0.509788 11.787 0.257212L5.788 4.21321C5.74701 4.24011 5.69903 4.25437 5.65 4.25421H2.75C2.02065 4.25421 1.32118 4.54394 0.805456 5.05967C0.289731 5.57539 0 6.27487 0 7.00421V10.7182C0 11.4476 0.289731 12.147 0.805456 12.6628C1.32118 13.1785 2.02065 13.4682 2.75 13.4682H5.65C5.69879 13.4685 5.74641 13.4831 5.787 13.5102L11.787 17.4652C12.95 18.2322 13.75 17.1472 14.5 16.0042C15.25 14.8612 15.8222 11.3848 15.75 8.36121C15.687 5.72219 15.25 2.86133 14.5 1.71821Z"
                  fill="#E64622"
                />
              </mask>
              <g mask="url(#mask0_32_117)">
                <rect x="6.75" y="1.98242" width="3" height="3" transform="rotate(-45 6.75 1.98242)" fill="#E72D33" />
                <rect x="6.75" y="6.60352" width="3" height="3" transform="rotate(-45 6.75 6.60352)" fill="#E72D33" />
                <rect x="6.75" y="11.2246" width="3" height="3" transform="rotate(-45 6.75 11.2246)" fill="#E72D33" />
                <rect x="6.75" y="15.8457" width="3" height="3" transform="rotate(-45 6.75 15.8457)" fill="#E72D33" />
              </g>
              <path
                d="M3.75 6.86133L4.13197 8.19974L5.48205 7.86133L4.51393 8.86133L5.48205 9.86133L4.13197 9.52291L3.75 10.8613L3.36803 9.52291L2.01795 9.86133L2.98607 8.86133L2.01795 7.86133L3.36803 8.19974L3.75 6.86133Z"
                fill="#E72D33"
              />
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M18.7071 6.29289C18.3166 5.90237 17.6834 5.90237 17.2929 6.29289C16.9024 6.68342 16.9024 7.31658 17.2929 7.70711L18.5858 9L17.2929 10.2929C16.9024 10.6834 16.9024 11.3166 17.2929 11.7071C17.6834 12.0976 18.3166 12.0976 18.7071 11.7071L20 10.4142L21.2929 11.7071C21.6834 12.0976 22.3166 12.0976 22.7071 11.7071C23.0976 11.3166 23.0976 10.6834 22.7071 10.2929L21.4142 9L22.7071 7.70711C23.0976 7.31658 23.0976 6.68342 22.7071 6.29289C22.3166 5.90237 21.6834 5.90237 21.2929 6.29289L20 7.58579L18.7071 6.29289Z"
                fill="#F8B000"
              />
            </svg>
            <svg slot="low" viewBox="0 0 23 18" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M17.6117 5.41744C17.9334 5.203 18.368 5.28992 18.5824 5.61159C19.1762 6.50218 19.45 7.64604 19.45 8.74988C19.45 9.85372 19.1762 10.9976 18.5824 11.8882C18.368 12.2098 17.9334 12.2968 17.6117 12.0823C17.29 11.8679 17.2031 11.4333 17.4176 11.1116C17.8238 10.5022 18.05 9.64604 18.05 8.74988C18.05 7.85372 17.8238 6.99758 17.4176 6.38817C17.2031 6.0665 17.29 5.63189 17.6117 5.41744Z"
                fill="#F8B000"
              />
              <path
                d="M14.5 1.71821C13.75 0.575091 12.95 -0.509788 11.787 0.257212L5.788 4.21321C5.74701 4.24011 5.69903 4.25437 5.65 4.25421H2.75C2.02065 4.25421 1.32118 4.54394 0.805456 5.05967C0.289731 5.57539 0 6.27487 0 7.00421V10.7182C0 11.4476 0.289731 12.147 0.805456 12.6628C1.32118 13.1785 2.02065 13.4682 2.75 13.4682H5.65C5.69879 13.4685 5.74641 13.4831 5.787 13.5102L11.787 17.4652C12.95 18.2322 13.75 17.1472 14.5 16.0042C15.25 14.8612 15.8222 11.3848 15.75 8.36121C15.687 5.72219 15.25 2.86133 14.5 1.71821Z"
                fill="#F8B000"
              />
              <mask
                id="mask0_33_150"
                style="mask-type: alpha"
                maskUnits="userSpaceOnUse"
                x="0"
                y="0"
                width="16"
                height="18"
              >
                <path
                  d="M14.5 1.71821C13.75 0.575091 12.95 -0.509788 11.787 0.257212L5.788 4.21321C5.74701 4.24011 5.69903 4.25437 5.65 4.25421H2.75C2.02065 4.25421 1.32118 4.54394 0.805456 5.05967C0.289731 5.57539 0 6.27487 0 7.00421V10.7182C0 11.4476 0.289731 12.147 0.805456 12.6628C1.32118 13.1785 2.02065 13.4682 2.75 13.4682H5.65C5.69879 13.4685 5.74641 13.4831 5.787 13.5102L11.787 17.4652C12.95 18.2322 13.75 17.1472 14.5 16.0042C15.25 14.8612 15.8222 11.3848 15.75 8.36121C15.687 5.72219 15.25 2.86133 14.5 1.71821Z"
                  fill="#E64622"
                />
              </mask>
              <g mask="url(#mask0_33_150)">
                <rect x="6.75" y="1.98242" width="3" height="3" transform="rotate(-45 6.75 1.98242)" fill="#E72D33" />
                <rect x="6.75" y="6.60352" width="3" height="3" transform="rotate(-45 6.75 6.60352)" fill="#E72D33" />
                <rect x="6.75" y="11.2246" width="3" height="3" transform="rotate(-45 6.75 11.2246)" fill="#E72D33" />
                <rect x="6.75" y="15.8457" width="3" height="3" transform="rotate(-45 6.75 15.8457)" fill="#E72D33" />
              </g>
              <path
                d="M3.75 6.86133L4.13197 8.19974L5.48205 7.86133L4.51393 8.86133L5.48205 9.86133L4.13197 9.52291L3.75 10.8613L3.36803 9.52291L2.01795 9.86133L2.98607 8.86133L2.01795 7.86133L3.36803 8.19974L3.75 6.86133Z"
                fill="#E72D33"
              />
            </svg>

            <svg
              slot="medium"
              viewBox="0 0 23 18"
              preserveAspectRatio="xMidYMid meet"
              fill="none"
              xmlns="http://www.w3.org/2000/svg"
            >
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M17.6117 5.41744C17.9334 5.203 18.368 5.28992 18.5824 5.61159C19.1762 6.50218 19.45 7.64604 19.45 8.74988C19.45 9.85372 19.1762 10.9976 18.5824 11.8882C18.368 12.2098 17.9334 12.2968 17.6117 12.0823C17.29 11.8679 17.2031 11.4333 17.4176 11.1116C17.8238 10.5022 18.05 9.64604 18.05 8.74988C18.05 7.85372 17.8238 6.99758 17.4176 6.38817C17.2031 6.0665 17.29 5.63189 17.6117 5.41744Z"
                fill="#F8B000"
              />
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M20.2198 3.83116C20.3605 3.69071 20.5511 3.61182 20.7498 3.61182C20.9486 3.61182 21.1392 3.69071 21.2798 3.83116L21.2818 3.83316L21.2848 3.83516L21.2918 3.84216L21.3118 3.86216L21.3738 3.93116C21.4238 3.98816 21.4938 4.06916 21.5748 4.17216C22.4988 5.37313 22.9998 6.84588 22.9998 8.36116C22.9998 9.87643 22.4988 11.3492 21.5748 12.5502C21.4911 12.657 21.403 12.7605 21.3108 12.8602L21.2908 12.8802L21.2848 12.8872L21.2818 12.8892L21.2808 12.8902L20.7708 12.3822L21.2808 12.8922C21.1401 13.0329 20.9493 13.1119 20.7503 13.1119C20.5514 13.1119 20.3605 13.0329 20.2198 12.8922C20.0791 12.7515 20.0001 12.5606 20.0001 12.3617C20.0001 12.1627 20.0791 11.9719 20.2198 11.8312L20.2188 11.8322L20.2168 11.8332L20.2218 11.8282L20.2548 11.7922C20.2868 11.7575 20.3332 11.7018 20.3938 11.6252C21.0265 10.7993 21.4056 9.80744 21.4851 8.77015C21.5647 7.73287 21.3412 6.69482 20.8418 5.78216C20.7115 5.54196 20.5616 5.31286 20.3938 5.09716C20.3395 5.02698 20.2822 4.95925 20.2218 4.89416L20.2168 4.88916C20.0774 4.74822 19.9994 4.5578 20 4.35954C20.0006 4.16128 20.0796 3.9713 20.2198 3.83116Z"
                fill="#F8B000"
              />
              <path
                d="M14.5 1.71821C13.75 0.575091 12.95 -0.509788 11.787 0.257212L5.788 4.21321C5.74701 4.24011 5.69903 4.25437 5.65 4.25421H2.75C2.02065 4.25421 1.32118 4.54394 0.805456 5.05967C0.289731 5.57539 0 6.27487 0 7.00421V10.7182C0 11.4476 0.289731 12.147 0.805456 12.6628C1.32118 13.1785 2.02065 13.4682 2.75 13.4682H5.65C5.69879 13.4685 5.74641 13.4831 5.787 13.5102L11.787 17.4652C12.95 18.2322 13.75 17.1472 14.5 16.0042C15.25 14.8612 15.8222 11.3848 15.75 8.36121C15.687 5.72219 15.25 2.86133 14.5 1.71821Z"
                fill="#F8B000"
              />
              <mask
                id="mask0_33_176"
                style="mask-type: alpha"
                maskUnits="userSpaceOnUse"
                x="0"
                y="0"
                width="16"
                height="18"
              >
                <path
                  d="M14.5 1.71821C13.75 0.575091 12.95 -0.509788 11.787 0.257212L5.788 4.21321C5.74701 4.24011 5.69903 4.25437 5.65 4.25421H2.75C2.02065 4.25421 1.32118 4.54394 0.805456 5.05967C0.289731 5.57539 0 6.27487 0 7.00421V10.7182C0 11.4476 0.289731 12.147 0.805456 12.6628C1.32118 13.1785 2.02065 13.4682 2.75 13.4682H5.65C5.69879 13.4685 5.74641 13.4831 5.787 13.5102L11.787 17.4652C12.95 18.2322 13.75 17.1472 14.5 16.0042C15.25 14.8612 15.8222 11.3848 15.75 8.36121C15.687 5.72219 15.25 2.86133 14.5 1.71821Z"
                  fill="#E64622"
                />
              </mask>
              <g mask="url(#mask0_33_176)">
                <rect x="6.75" y="1.98242" width="3" height="3" transform="rotate(-45 6.75 1.98242)" fill="#E72D33" />
                <rect x="6.75" y="6.60352" width="3" height="3" transform="rotate(-45 6.75 6.60352)" fill="#E72D33" />
                <rect x="6.75" y="11.2246" width="3" height="3" transform="rotate(-45 6.75 11.2246)" fill="#E72D33" />
                <rect x="6.75" y="15.8457" width="3" height="3" transform="rotate(-45 6.75 15.8457)" fill="#E72D33" />
              </g>
              <path
                d="M3.75 6.86133L4.13197 8.19974L5.48205 7.86133L4.51393 8.86133L5.48205 9.86133L4.13197 9.52291L3.75 10.8613L3.36803 9.52291L2.01795 9.86133L2.98607 8.86133L2.01795 7.86133L3.36803 8.19974L3.75 6.86133Z"
                fill="#E72D33"
              />
            </svg>
            <svg slot="high" viewBox="0 0 23 18" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M17.6117 5.41744C17.9334 5.203 18.368 5.28992 18.5824 5.61159C19.1762 6.50218 19.45 7.64604 19.45 8.74988C19.45 9.85372 19.1762 10.9976 18.5824 11.8882C18.368 12.2098 17.9334 12.2968 17.6117 12.0823C17.29 11.8679 17.2031 11.4333 17.4176 11.1116C17.8238 10.5022 18.05 9.64604 18.05 8.74988C18.05 7.85372 17.8238 6.99758 17.4176 6.38817C17.2031 6.0665 17.29 5.63189 17.6117 5.41744Z"
                fill="#F8B000"
              />
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M20.2198 3.83116C20.3605 3.69071 20.5511 3.61182 20.7498 3.61182C20.9486 3.61182 21.1392 3.69071 21.2798 3.83116L21.2818 3.83316L21.2848 3.83516L21.2918 3.84216L21.3118 3.86216L21.3738 3.93116C21.4238 3.98816 21.4938 4.06916 21.5748 4.17216C22.4988 5.37313 22.9998 6.84588 22.9998 8.36116C22.9998 9.87643 22.4988 11.3492 21.5748 12.5502C21.4911 12.657 21.403 12.7605 21.3108 12.8602L21.2908 12.8802L21.2848 12.8872L21.2818 12.8892L21.2808 12.8902L20.7708 12.3822L21.2808 12.8922C21.1401 13.0329 20.9493 13.1119 20.7503 13.1119C20.5514 13.1119 20.3605 13.0329 20.2198 12.8922C20.0791 12.7515 20.0001 12.5606 20.0001 12.3617C20.0001 12.1627 20.0791 11.9719 20.2198 11.8312L20.2188 11.8322L20.2168 11.8332L20.2218 11.8282L20.2548 11.7922C20.2868 11.7575 20.3332 11.7018 20.3938 11.6252C21.0265 10.7993 21.4056 9.80744 21.4851 8.77015C21.5647 7.73287 21.3412 6.69482 20.8418 5.78216C20.7115 5.54196 20.5616 5.31286 20.3938 5.09716C20.3395 5.02698 20.2822 4.95925 20.2218 4.89416L20.2168 4.88916C20.0774 4.74822 19.9994 4.5578 20 4.35954C20.0006 4.16128 20.0796 3.9713 20.2198 3.83116Z"
                fill="#F8B000"
              />
              <path
                d="M14.5 1.71821C13.75 0.575091 12.95 -0.509788 11.787 0.257212L5.788 4.21321C5.74701 4.24011 5.69903 4.25437 5.65 4.25421H2.75C2.02065 4.25421 1.32118 4.54394 0.805456 5.05967C0.289731 5.57539 0 6.27487 0 7.00421V10.7182C0 11.4476 0.289731 12.147 0.805456 12.6628C1.32118 13.1785 2.02065 13.4682 2.75 13.4682H5.65C5.69879 13.4685 5.74641 13.4831 5.787 13.5102L11.787 17.4652C12.95 18.2322 13.75 17.1472 14.5 16.0042C15.25 14.8612 15.8222 11.3848 15.75 8.36121C15.687 5.72219 15.25 2.86133 14.5 1.71821Z"
                fill="#F8B000"
              />
              <mask
                id="mask0_33_176c"
                style="mask-type: alpha"
                maskUnits="userSpaceOnUse"
                x="0"
                y="0"
                width="16"
                height="18"
              >
                <path
                  d="M14.5 1.71821C13.75 0.575091 12.95 -0.509788 11.787 0.257212L5.788 4.21321C5.74701 4.24011 5.69903 4.25437 5.65 4.25421H2.75C2.02065 4.25421 1.32118 4.54394 0.805456 5.05967C0.289731 5.57539 0 6.27487 0 7.00421V10.7182C0 11.4476 0.289731 12.147 0.805456 12.6628C1.32118 13.1785 2.02065 13.4682 2.75 13.4682H5.65C5.69879 13.4685 5.74641 13.4831 5.787 13.5102L11.787 17.4652C12.95 18.2322 13.75 17.1472 14.5 16.0042C15.25 14.8612 15.8222 11.3848 15.75 8.36121C15.687 5.72219 15.25 2.86133 14.5 1.71821Z"
                  fill="#E64622"
                />
              </mask>
              <g mask="url(#mask0_33_176c)">
                <rect x="6.75" y="1.98242" width="3" height="3" transform="rotate(-45 6.75 1.98242)" fill="#E72D33" />
                <rect x="6.75" y="6.60352" width="3" height="3" transform="rotate(-45 6.75 6.60352)" fill="#E72D33" />
                <rect x="6.75" y="11.2246" width="3" height="3" transform="rotate(-45 6.75 11.2246)" fill="#E72D33" />
                <rect x="6.75" y="15.8457" width="3" height="3" transform="rotate(-45 6.75 15.8457)" fill="#E72D33" />
              </g>
              <path
                d="M3.75 6.86133L4.13197 8.19974L5.48205 7.86133L4.51393 8.86133L5.48205 9.86133L4.13197 9.52291L3.75 10.8613L3.36803 9.52291L2.01795 9.86133L2.98607 8.86133L2.01795 7.86133L3.36803 8.19974L3.75 6.86133Z"
                fill="#E72D33"
              />
            </svg>
          </media-mute-button>
          <div class="media-volume-range-wrapper">
            <media-volume-range></media-volume-range>
          </div>
        </div>
        <media-cast-button class="icon-button">
          <svg slot="enter" width="21" height="20" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path
              fill-rule="evenodd"
              clip-rule="evenodd"
              d="M0 11.7013C0 11.2029 0.404067 10.7988 0.902508 10.7988C3.05675 10.7988 5.12276 11.6546 6.64603 13.1779C8.16931 14.7012 9.02508 16.7672 9.02508 18.9214C9.02508 19.4198 8.62101 19.8239 8.12257 19.8239C7.62413 19.8239 7.22006 19.4198 7.22006 18.9214C7.22006 17.2459 6.55447 15.639 5.36969 14.4542C4.18492 13.2694 2.57803 12.6038 0.902508 12.6038C0.404067 12.6038 0 12.1998 0 11.7013ZM0 15.3114C0 14.8129 0.404067 14.4089 0.902508 14.4089C2.09931 14.4089 3.24709 14.8843 4.09336 15.7306C4.93962 16.5768 5.41505 17.7246 5.41505 18.9214C5.41505 19.4198 5.01098 19.8239 4.51254 19.8239C4.0141 19.8239 3.61003 19.4198 3.61003 18.9214C3.61003 18.2033 3.32478 17.5147 2.81702 17.0069C2.30926 16.4991 1.62059 16.2139 0.902508 16.2139C0.404067 16.2139 0 15.8098 0 15.3114ZM0 18.9214C0 18.423 0.404067 18.0189 0.902508 18.0189H0.911533C1.40997 18.0189 1.81404 18.423 1.81404 18.9214C1.81404 19.4198 1.40997 19.8239 0.911533 19.8239H0.902508C0.404067 19.8239 0 19.4198 0 18.9214Z"
              fill="#F8B000"
            />
            <path
              fill-rule="evenodd"
              clip-rule="evenodd"
              d="M2.70752 5.38363C2.46816 5.38363 2.23861 5.47871 2.06935 5.64797C1.9001 5.81722 1.80502 6.04678 1.80502 6.28614V8.54241C1.80502 9.04085 1.40095 9.44491 0.902508 9.44491C0.404067 9.44491 0 9.04085 0 8.54241V6.28614C0 5.56806 0.285256 4.87939 0.793015 4.37163C1.30077 3.86387 1.98944 3.57861 2.70752 3.57861H15.3426C16.0607 3.57861 16.7494 3.86387 17.2571 4.37163C17.7649 4.87939 18.0502 5.56806 18.0502 6.28614V17.1162C18.0502 17.8343 17.7649 18.523 17.2571 19.0307C16.7494 19.5385 16.0607 19.8238 15.3426 19.8238H11.7326C11.2342 19.8238 10.8301 19.4197 10.8301 18.9212C10.8301 18.4228 11.2342 18.0187 11.7326 18.0187H15.3426C15.582 18.0187 15.8115 17.9237 15.9808 17.7544C16.1501 17.5851 16.2451 17.3556 16.2451 17.1162V6.28614C16.2451 6.04678 16.1501 5.81722 15.9808 5.64797C15.8115 5.47871 15.582 5.38363 15.3426 5.38363H2.70752Z"
              fill="#F8B000"
            />
            <g class="ornament">
              <path
                d="M14.7027 8.14523C14.3999 8.68205 13.7193 8.8718 13.1825 8.56906C12.6457 8.26632 12.456 7.58573 12.7587 7.04892L12.8539 6.88019C13.1566 6.34337 13.8372 6.15362 14.374 6.45636C14.9108 6.75909 15.1006 7.43969 14.7978 7.9765L14.7027 8.14523Z"
                fill="#E72D33"
              />
              <path
                d="M9.13434 7.47241C8.91344 8.56228 11.5007 7.98191 12.1601 7.58021C12.4023 7.43264 12.5637 7.20765 12.5066 6.84742C12.4796 6.67756 11.9826 6.39726 11.1842 5.94699C10.3858 5.49672 9.62208 5.06602 9.13434 7.47241Z"
                fill="#E72D33"
              />
              <path
                d="M8.73703 2.82816C8.34107 3.36358 11.7567 6.49318 12.4707 6.47466C13.1847 6.45613 13.0932 5.93476 13.1006 5.74009C13.1081 5.54541 12.3677 1.59508 11.7215 1.35393C11.0752 1.11278 10.674 2.42702 10.4047 2.60322C9.69609 3.06676 9.3982 1.93412 8.73703 2.82816Z"
                fill="#E72D33"
              />
              <path
                d="M16.1802 11.5325C15.3618 12.2855 14.5198 9.77111 14.5224 8.99903C14.5233 8.71539 14.6324 8.4609 14.9702 8.32338C15.1295 8.25854 15.6265 8.53884 16.4249 8.98912C17.2233 9.43939 17.9871 9.87008 16.1802 11.5325Z"
                fill="#E72D33"
              />
              <path
                d="M20.3596 9.46932C20.1063 10.0852 15.6609 8.78152 15.3074 8.16092C14.9538 7.54033 15.4473 7.34892 15.6101 7.24181C15.7728 7.1347 19.5364 5.72441 20.0771 6.15265C20.6178 6.58089 19.7007 7.60422 19.6893 7.92588C19.6592 8.77207 20.7826 8.44095 20.3596 9.46932Z"
                fill="#E72D33"
              />
            </g>
          </svg>
        </media-cast-button>
        <media-airplay-button class="icon-button">
          <svg slot="icon" viewBox="0 0 22 20" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path
              fill-rule="evenodd"
              clip-rule="evenodd"
              d="M2.45453 6.57942C2.23753 6.57942 2.02943 6.6626 1.87599 6.81065C1.72255 6.95871 1.63635 7.15951 1.63635 7.36889V15.2636C1.63635 15.473 1.72255 15.6738 1.87599 15.8218C2.02943 15.9699 2.23754 16.053 2.45453 16.053H3.27271C3.72457 16.053 4.09088 16.4065 4.09088 16.8425C4.09088 17.2785 3.72457 17.632 3.27271 17.632H2.45453C1.80355 17.632 1.17923 17.3825 0.718915 16.9383C0.258601 16.4941 0 15.8917 0 15.2636V7.36889C0 6.74075 0.258601 6.13834 0.718915 5.69418C1.17923 5.25002 1.80355 5.00049 2.45453 5.00049H15.5453C16.1963 5.00049 16.8206 5.25002 17.281 5.69418C17.7413 6.13834 17.9999 6.74075 17.9999 7.36889V15.2636C17.9999 15.8917 17.7413 16.4941 17.281 16.9383C16.8207 17.3825 16.1963 17.632 15.5453 17.632H14.7272C14.2753 17.632 13.909 17.2785 13.909 16.8425C13.909 16.4065 14.2753 16.053 14.7272 16.053H15.5453C15.7623 16.053 15.9704 15.9699 16.1239 15.8218C16.2773 15.6738 16.3635 15.473 16.3635 15.2636V7.36889C16.3635 7.15951 16.2773 6.95871 16.1239 6.81065C15.9704 6.6626 15.7623 6.57942 15.5453 6.57942H2.45453ZM8.99994 13.6846C9.24276 13.6846 9.47303 13.7887 9.62848 13.9687L13.7194 18.7055C13.9226 18.9408 13.9664 19.2684 13.8318 19.5458C13.6971 19.8232 13.4083 20.0004 13.0908 20.0004H4.90906C4.59159 20.0004 4.30278 19.8232 4.16813 19.5458C4.03347 19.2684 4.07728 18.9408 4.28052 18.7055L8.3714 13.9687C8.52685 13.7887 8.75712 13.6846 8.99994 13.6846ZM6.6559 18.4215H11.344L8.99994 15.7073L6.6559 18.4215Z"
              fill="#F8B000"
            />
            <g class="ornament">
              <path
                d="M15.0427 8.91031C14.5817 9.4732 13.7516 9.55574 13.1887 9.09467C12.6258 8.63359 12.5433 7.8035 13.0043 7.24061L13.1493 7.06368C13.6103 6.50079 14.4404 6.41825 15.0033 6.87932C15.5662 7.34039 15.6487 8.17048 15.1877 8.73338L15.0427 8.91031Z"
                fill="#E72D33"
              />
              <path
                d="M8.703 6.99743C8.22484 8.22018 11.3518 8.07038 12.2003 7.73703C12.5119 7.61456 12.7453 7.38564 12.752 6.95508C12.7552 6.75205 12.234 6.32515 11.3968 5.63938C10.5596 4.95361 9.75876 4.29766 8.703 6.99743Z"
                fill="#E72D33"
              />
              <path
                d="M9.18367 1.51522C8.61445 2.05757 11.9518 6.39086 12.786 6.51425C13.6202 6.63765 13.6195 6.01267 13.6677 5.78777C13.7159 5.56286 13.6567 0.818075 12.954 0.40642C12.2513 -0.00523493 11.5179 1.44186 11.1689 1.59212C10.2507 1.98741 10.1341 0.609609 9.18367 1.51522Z"
                fill="#E72D33"
              />
              <path
                d="M16.0736 13.1499C14.9689 13.8595 14.5 10.7642 14.6597 9.86673C14.7184 9.53703 14.8969 9.26318 15.3177 9.17182C15.5162 9.12873 16.0373 9.55564 16.8745 10.2414C17.7117 10.9272 18.5126 11.5831 16.0736 13.1499Z"
                fill="#E72D33"
              />
              <path
                d="M21.3534 11.5987C20.9337 12.2635 16.0281 9.84488 15.7429 9.05131C15.4576 8.25774 16.0705 8.13531 16.2815 8.04377C16.4925 7.95223 21.156 7.07596 21.698 7.68379C22.24 8.29163 20.9656 9.29566 20.8871 9.66745C20.6803 10.6455 22.0541 10.4885 21.3534 11.5987Z"
                fill="#E72D33"
              />
            </g>
          </svg>
        </media-airplay-button>
        <media-fullscreen-button class="icon-button">
          <svg
            slot="enter"
            preserveAspectRatio="xMidYMid meet"
            viewBox="0 0 24 18"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
          >
            <path
              fill-rule="evenodd"
              clip-rule="evenodd"
              d="M2.07622 5.19169H4.21092C4.60391 5.19169 4.92249 4.87311 4.92249 4.48012C4.92249 4.08714 4.60391 3.76855 4.21092 3.76855H1.72043C1.43735 3.76855 1.16586 3.88101 0.965697 4.08118C0.76553 4.28134 0.653076 4.55283 0.653076 4.83591V7.3264C0.653076 7.71939 0.971657 8.03797 1.36465 8.03797C1.75763 8.03797 2.07622 7.71939 2.07622 7.3264V5.19169ZM16.3076 4.48012C16.3076 4.08714 16.6262 3.76855 17.0192 3.76855H19.5097C19.7928 3.76855 20.0642 3.88101 20.2644 4.08118C20.4646 4.28134 20.577 4.55283 20.577 4.83591V7.3264C20.577 7.71939 20.2584 8.03797 19.8655 8.03797C19.4725 8.03797 19.1539 7.71939 19.1539 7.3264V5.19169H17.0192C16.6262 5.19169 16.3076 4.87311 16.3076 4.48012ZM1.36465 13.7305C1.75763 13.7305 2.07622 14.0491 2.07622 14.4421V16.5768H4.21092C4.60391 16.5768 4.92249 16.8954 4.92249 17.2884C4.92249 17.6814 4.60391 17.9999 4.21092 17.9999H1.72043C1.43735 17.9999 1.16587 17.8875 0.965697 17.6873C0.765529 17.4872 0.653076 17.2157 0.653076 16.9326V14.4421C0.653076 14.0491 0.971657 13.7305 1.36465 13.7305ZM19.8655 13.7305C20.2584 13.7305 20.577 14.0491 20.577 14.4421V16.9326C20.577 17.2157 20.4646 17.4872 20.2644 17.6873C20.0642 17.8875 19.7927 17.9999 19.5097 17.9999H17.0192C16.6262 17.9999 16.3076 17.6814 16.3076 17.2884C16.3076 16.8954 16.6262 16.5768 17.0192 16.5768H19.1539V14.4421C19.1539 14.0491 19.4725 13.7305 19.8655 13.7305Z"
              fill="#F8B000"
            />
            <g class="ornament">
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M16.9493 0.454102C16.9493 0.454102 16.7169 0.996495 15.7587 1.4497C14.8005 1.90291 14.2537 1.70678 14.2537 1.70678C14.2537 1.70678 14.7158 2.59238 14.6521 3.56069C14.5883 4.52901 14.1108 4.96761 14.1108 4.96761C14.1108 4.96761 14.5781 5.06187 15.4235 5.97615C16.2688 6.89043 16.5693 7.44305 16.5693 7.44305C16.5693 7.44305 16.7132 6.87136 17.4059 6.33029C18.0986 5.78921 18.6067 5.85163 18.6067 5.85163C18.6067 5.85163 18.1178 5.18376 18.1815 4.21544C18.2453 3.24712 18.7317 2.73595 18.7317 2.73595C18.7317 2.73595 17.9919 2.46086 17.5871 1.85857C17.1822 1.25628 16.9493 0.454102 16.9493 0.454102ZM16.5698 7.62643C16.5698 7.62643 17.067 7.94423 17.3578 8.96351C17.6486 9.98279 17.3658 10.4903 17.3658 10.4903C17.3658 10.4903 18.315 10.1788 19.2599 10.3997C20.2049 10.6206 20.5597 11.1633 20.5597 11.1633C20.5597 11.1633 20.7289 10.7176 21.7689 10.0328C22.8088 9.34792 23.4031 9.14166 23.4031 9.14166C23.4031 9.14166 22.8625 8.90639 22.4417 8.13468C22.0209 7.36297 22.1654 6.87195 22.1654 6.87195C22.1654 6.87195 21.4267 7.24531 20.4818 7.02443C19.5368 6.80355 19.1119 6.24023 19.1119 6.24023C19.1119 6.24023 18.7198 6.92518 18.0595 7.22634C17.3992 7.5275 16.5698 7.62643 16.5698 7.62643Z"
                fill="#19BC8A"
              />
              <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M16.6497 7.65115C16.1972 7.1963 16.199 6.4607 16.6539 6.00813C17.1087 5.55557 17.8443 5.55742 18.2969 6.01227C18.7495 6.46712 18.7476 7.20272 18.2928 7.65529C17.8379 8.10785 17.1023 8.106 16.6497 7.65115ZM15.4451 9.82401C14.9926 9.36916 14.9944 8.63356 15.4493 8.18099C15.9041 7.72843 16.6397 7.73028 17.0923 8.18513C17.5449 8.63998 17.543 9.37559 17.0882 9.82815C16.6333 10.2807 15.8977 10.2789 15.4451 9.82401ZM14.1224 6.1351C13.6675 6.58766 13.6657 7.32326 14.1182 7.77811C14.5708 8.23296 15.3064 8.23482 15.7613 7.78225C16.2161 7.32969 16.218 6.59408 15.7654 6.13923C15.3128 5.68438 14.5772 5.68253 14.1224 6.1351Z"
                fill="#E72D33"
              />
            </g>
          </svg>

          <svg
            slot="exit"
            preserveAspectRatio="xMidYMid meet"
            viewBox="0 0 23 18"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
          >
            <path
              d="M0.711534 6.16083L2.84626 6.16083L2.84626 4.02611C2.84626 3.63312 3.16484 3.31453 3.55783 3.31453C3.95083 3.31453 4.26941 3.63312 4.26941 4.02611L4.26941 6.51662C4.26941 6.7997 4.15695 7.07119 3.95679 7.27136C3.75662 7.47153 3.48513 7.58398 3.20205 7.58398L0.711534 7.58398C0.318542 7.58398 -4.17495e-05 7.2654 -4.17152e-05 6.87241C-4.16808e-05 6.47942 0.318542 6.16083 0.711534 6.16083Z"
              fill="#F8B000"
            />
            <path
              d="M2.84638 16.886L2.84638 14.7513L0.711656 14.7513C0.318664 14.7513 8.05726e-05 14.4327 8.05679e-05 14.0397C8.05632e-05 13.6467 0.318664 13.3281 0.711656 13.3281L3.20217 13.3281C3.48525 13.3281 3.75674 13.4406 3.95691 13.6407C4.15708 13.8409 4.26953 14.1124 4.26953 14.3955L4.26953 16.886C4.26953 17.279 3.95095 17.5976 3.55796 17.5976C3.16496 17.5976 2.84638 17.279 2.84638 16.886Z"
              fill="#F8B000"
            />
            <path
              d="M19.3067 14.7513L17.1719 14.7513L17.1719 16.886C17.1719 17.279 16.8533 17.5976 16.4604 17.5976C16.0674 17.5976 15.7488 17.279 15.7488 16.886L15.7488 14.3955C15.7488 14.1124 15.8612 13.8409 16.0614 13.6407C16.2616 13.4406 16.5331 13.3281 16.8161 13.3281L19.3067 13.3281C19.6996 13.3281 20.0182 13.6467 20.0182 14.0397C20.0182 14.4327 19.6996 14.7513 19.3067 14.7513Z"
              fill="#F8B000"
            />
            <path
              d="M17.0032 4.08568L17.0032 6.2204L19.138 6.2204C19.5309 6.2204 19.8495 6.53899 19.8495 6.93198C19.8495 7.32497 19.5309 7.64355 19.138 7.64355L16.6474 7.64355C16.3644 7.64355 16.0929 7.5311 15.8927 7.33093C15.6925 7.13076 15.5801 6.85927 15.5801 6.57619L15.5801 4.08568C15.5801 3.69269 15.8987 3.3741 16.2917 3.3741C16.6846 3.3741 17.0032 3.69269 17.0032 4.08568Z"
              fill="#F8B000"
            />
            <g class="ornament">
              <path
                d="M16.7046 8.50954C16.4138 7.49025 15.9166 7.17245 15.9166 7.17245C15.9166 7.17245 16.746 7.07351 17.4063 6.77235C18.0666 6.47119 18.4587 5.78624 18.4587 5.78624C18.4587 5.78624 18.8837 6.34956 19.8286 6.57044C20.7736 6.79132 21.5123 6.41796 21.5123 6.41796C21.5123 6.41796 21.3678 6.90898 21.7886 7.6807C22.2094 8.45241 22.7499 8.68769 22.7499 8.68769C22.7499 8.68769 22.1557 8.89395 21.1157 9.57883C20.0758 10.2637 19.9065 10.7094 19.9065 10.7094C19.9065 10.7094 19.5517 10.1667 18.6068 9.94579C17.6618 9.72491 16.7127 10.0363 16.7127 10.0363C16.7127 10.0363 16.9954 9.52882 16.7046 8.50954Z"
                fill="#19BC8A"
              />
              <path
                d="M15.1056 0.995608C16.0638 0.542398 16.2962 0 16.2962 0C16.2962 0 16.5292 0.802185 16.934 1.40448C17.3389 2.00677 18.0786 2.28186 18.0786 2.28186C18.0786 2.28186 17.5922 2.79304 17.5284 3.76137C17.4647 4.72969 17.9536 5.39757 17.9536 5.39757C17.9536 5.39757 17.4456 5.33515 16.7529 5.87623C16.0601 6.41731 15.9162 6.989 15.9162 6.989C15.9162 6.989 15.6158 6.43637 14.7704 5.52209C13.925 4.60781 13.4577 4.51355 13.4577 4.51355C13.4577 4.51355 13.9352 4.07494 13.999 3.10662C14.0627 2.13829 13.6006 1.25269 13.6006 1.25269C13.6006 1.25269 14.1474 1.44882 15.1056 0.995608Z"
                fill="#19BC8A"
              />
              <path
                d="M15.9965 7.19726C15.5439 6.74241 15.5457 6.0068 16.0006 5.55423C16.4555 5.10166 17.1911 5.10352 17.6436 5.55837C18.0962 6.01322 18.0943 6.74884 17.6395 7.2014C17.1846 7.65397 16.449 7.65212 15.9965 7.19726Z"
                fill="#E72D33"
              />
              <path
                d="M14.7918 9.36999C14.3393 8.91514 14.3411 8.17953 14.796 7.72696C15.2508 7.27439 15.9865 7.27624 16.439 7.7311C16.8916 8.18595 16.8897 8.92156 16.4349 9.37413C15.98 9.8267 15.2444 9.82485 14.7918 9.36999Z"
                fill="#E72D33"
              />
              <path
                d="M13.465 7.3242C13.0125 6.86935 13.0143 6.13374 13.4692 5.68117C13.924 5.2286 14.6597 5.23045 15.1122 5.68531C15.5648 6.14016 15.5629 6.87577 15.1081 7.32834C14.6532 7.78091 13.9176 7.77905 13.465 7.3242Z"
                fill="#E72D33"
              />
            </g>
          </svg>
        </media-fullscreen-button>
      </media-control-bar>
    </media-controller>

  `;
}

class MediaThemeXMasElement extends MediaThemeElement {
  static template = template;
}

if (globalThis.customElements && !globalThis.customElements.get('media-theme-x-mas')) {
  globalThis.customElements.define('media-theme-x-mas', MediaThemeXMasElement);
}

export default MediaThemeXMasElement;
