/*
<media-theme-vimeonova>
  <video
    slot="media"
    src="https://stream.mux.com/fXNzVtmtWuyz00xnSrJg4OJH6PyNo6D02UzmgeKGkP5YQ/high.mp4"
  ></video>
</media-theme-vimeonova>
*/

import 'media-chrome';
import { globalThis } from 'media-chrome/dist/utils/server-safe-globals.js';
import { MediaThemeElement } from 'media-chrome/dist/media-theme-element.js';
import 'media-chrome/dist/menu/index.js';

const template = globalThis.document?.createElement?.('template');
if (template) {
  template.innerHTML = /*html*/`
    <style>
      :host {
        --vimeonova-black: 23 35 34;
        --vimeonova-primary-color: var(--media-primary-color, rgb(253 244 255));
        --vimeonova-secondary-color: var(--media-secondary-color, rgb(--vimeonova-black / 0.75));
        --vimeonova-accent-color: var(--media-accent-color, rgb(0 186 115));
        --vimeonova-control-bar-height: 32px;
        --vimeonova-control-bar-border-radius: 0.125em;
        --vimeonova-play-button-border-radius: 0.25em;

        --media-control-background: var(--vimeonova-secondary-color);
        --media-control-hover-background: var(--vimeonova-secondary-color);
        --media-icon-color: var(--vimeonova-primary-color);
        --media-menu-border-radius: 0.25em;
        --media-tooltip-display: none;

        color: var(--vimeonova-primary-color);
      }

      @supports (color: color-mix(in srgb, red, blue)) {
        :host {
          --vimeonova-secondary-color: color-mix(
            in srgb,
            var(--media-secondary-color, rgb(23 35 34)) 75%,
            transparent
          );
        }
      }

      media-controller {
        display: block;
        container: media-theme-vimeonova / inline-size;
      }

      .hidden {
        display: none;
      }

      .header {
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        row-gap: 1px;
        margin: 0.625em;
      }

      .title,
      .byline {
        display: inline-block;
        background: var(--vimeonova-secondary-color);
        margin: 0;
        padding: 0.18em 0.24em;
        line-height: 1;
        font-size: 0.8em;
        font-weight: normal;
      }

      .title {
        color: var(--vimeonova-accent-color);
        font-size: 1.3em;
        font-weight: bold;
      }

      .byline {
        color: var(--vimeonova-accent-color);
      }

      .control-bar-container {
        position: relative;
        overflow: visible;
        display: flex;
        align-items: end;
        padding: 0.35em;
        width: 100%;
        box-sizing: border-box;
      }

      @container (inline-size >=384px) {
        .control-bar-container {
          column-gap: 0.625em;
          padding: 0.625em;
        }
      }

      .control-bar-right {
        flex-grow: 1;
      }

      media-control-bar {
        background: var(--media-control-background);
        height: var(--vimeonova-control-bar-height);
        border-bottom-left-radius: var(--vimeonova-control-bar-border-radius);
        border-bottom-right-radius: var(--vimeonova-control-bar-border-radius);
        width: 100%;
      }

      media-control-bar [role='button'],
      media-control-bar [role='switch'] {
        --media-control-background: transparent;
        --media-control-hover-background: transparent;
        --media-button-icon-active-transform: scale(1.2);
        --media-button-icon-transition: transform 0.2s ease;
        color: var(--vimeonova-primary-color);
        padding: 0.3125em 0.35em;
      }

      media-control-bar svg {
        fill: none;
      }

      media-control-bar svg:active {
        transform: scale(1.2);
      }

      media-play-button {
        --media-control-background: var(--vimeonova-secondary-color);
        --media-control-hover-background: var(--vimeonova-accent-color);
        --media-button-icon-height: 100%;
        display: none;
        border-radius: var(--vimeonova-play-button-border-radius);
        color: var(--vimeonova-primary-color);
        width: 65px;
        height: 40px;
        padding: 0.3125em 0.625em;
      }

      [slot='centered-chrome'] media-play-button {
        display: block;
        position: relative;
        top: -30%;
      }

      media-play-button:active {
        --media-control-hover-background: var(--vimeonova-accent-color);
      }

      @supports (color: color-mix(in srgb, red, blue)) {
        media-play-button:active {
          --media-control-hover-background: color-mix(
            in srgb,
            var(--vimeonova-accent-color) 80%,
            transparent
          );
        }
      }

      media-time-range {
        --media-range-padding: 0;
        --media-control-background: transparent;
        --media-control-hover-background: transparent;
        --media-time-range-buffered-color: dimgray;
        --media-range-track-background: rgb(var(--vimeonova-black) / 0.5);
        --media-range-track-border-radius: 0;
        --media-range-bar-color: var(--vimeonova-accent-color);
        --media-range-thumb-background: none;
        --media-range-thumb-width: 0px;
        --media-range-thumb-height: 0px;
        --media-range-track-height: 10px;
        --media-preview-thumbnail-border-radius: 2px;
        --media-preview-thumbnail-border: 4px solid var(--vimeonova-secondary-color);
        --media-box-margin: 0;
        --media-preview-time-background: rgb(var(--vimeonova-black) / 1);
        padding-inline: 10px;
      }

      media-time-range.small {
        --media-box-padding-left: 2px;
        --media-box-padding-right: 2px;
        --media-range-track-height: 5px;
        --media-range-track-border-radius: var(--vimeonova-control-bar-border-radius)
          var(--vimeonova-control-bar-border-radius) 0 0;
        height: 5px;
        width: 100%;
        padding: 0;
      }

      @keyframes buffer {
        100% {
          --media-range-track-background: rgb(var(--vimeonova-black) / 0.5)
            url('data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" width="100%"><style>@keyframes buffer { 100% { transform: translateX(-10px); }}%3C/style><defs><pattern id="buffer-pattern" patternUnits="userSpaceOnUse" x="0" y="0" width="10" height="10" viewBox="0 0 10 10"><line x1="5" y1="-1" x2="-5" y2="10" stroke-width="2" stroke="dimgray" stroke-linecap="butt" /><line x1="10" y1="-1" x2="0" y2="10" stroke-width="2" stroke="dimgray" stroke-linecap="butt" /><line x1="15" y1="-1" x2="5" y2="10" stroke-width="2" stroke="dimgray" stroke-linecap="butt" /></pattern></defs><rect width="110%" height="100%" fill="url(%23buffer-pattern)" style="animation: buffer 250ms linear infinite;" /></svg>');
        }
      }

      [medialoading]:not([mediapaused]) media-time-range {
        animation: 1000000s 0.5s buffer reverse;
      }

      media-time-range.large {
        display: none;
        height: var(--vimeonova-control-bar-height);
        flex-grow: 10000;
      }

      media-time-range > * {
        position: relative;
        bottom: -11px;
      }

      media-time-range.small > * {
        bottom: 3px;
      }

      @container (inline-size >=384px) {
        [slot='centered-chrome'] media-play-button {
          display: none;
        }

        .control-bar-container media-play-button {
          display: block;
        }

        media-time-range.small {
          border-top-left-radius: var(--vimeonova-control-bar-border-radius);
          border-top-right-radius: var(--vimeonova-control-bar-border-radius);
        }
      }

      @container (inline-size >=484px) {
        media-control-bar {
          border-radius: var(--vimeonova-control-bar-border-radius);
        }

        media-time-range.small {
          display: none;
        }

        media-time-range.large {
          display: block;
        }
      }

      media-preview-time-display,
      media-time-display {
        --media-preview-time-background: var(--vimeonova-primary-color);
        padding: 2px 4px;
        border-radius: 0;
        line-height: normal;
        color: rgb(var(--vimeonova-black) / 1);
        font-family: Verdana, sans-serif;
        font-size: 10px;
        box-shadow: rgb(0 0 0 / 0.7) 1px 1px 0px 0px;
        text-shadow: none;
      }

      media-preview-thumbnail {
        max-width: 213px;
        max-height: 200px;
      }

      media-preview-time-display {
        margin-top: 5px;
        min-width: auto;
        --media-preview-time-background: rgb(var(--vimeonova-black) / 1);
        color: var(--vimeonova-primary-color);
      }

      [part='arrow'] {
        --media-box-arrow-background: rgb(var(--vimeonova-black) / 1);
        --media-box-arrow-height: 4px;
        --media-box-arrow-width: 4px;
        --media-box-arrow-offset: 0px;
        left: 1px;
      }

      [part='arrow'][slot='current']::before {
        --media-box-arrow-background: var(--vimeonova-primary-color);
      }

      [part='arrow']::before {
        content: '';
        border-color: transparent;
        border-top-color: var(--media-box-arrow-background, var(--_control-background));
        border-width: var(
          --media-box-arrow-border-width,
          var(--media-box-arrow-height, 5px) var(--media-box-arrow-width, 6px) 0
        );
        border-style: solid;
        position: absolute;
        bottom: 0.5px;
        margin-left: calc((var(--media-box-arrow-width) + 1px) * -1);
      }

      media-volume-range {
        --media-range-track-background-color: rgb(var(--vimeonova-black) / 0.8);
        --media-range-track-border-radius: 1px;
        --media-range-bar-color: var(--vimeonova-accent-color);
        --media-range-thumb-background: none;
        --media-range-thumb-width: 0px;
        --media-range-thumb-height: 0px;
        --media-range-track-height: 6px;
        height: var(--vimeonova-control-bar-height);
        background: var(--vimeonova-secondary-color);
        border-radius: var(--media-menu-border-radius);
      }

      .media-volume-wrapper {
        position: relative;
      }

      .media-volume-range-wrapper {
        width: 122px;
        height: 34px;
        overflow: hidden;
        opacity: 0;
        transform: rotate(-90deg);
        position: absolute;
        top: -80px;
        left: -52px;
        border-left: 16px solid transparent;
        visibility: hidden;
      }

      @container (inline-size >=484px) {
        .media-volume-range-wrapper {
          top: -77px;
        }
      }

      media-mute-button:hover + .media-volume-range-wrapper,
      media-mute-button:focus + .media-volume-range-wrapper,
      media-mute-button:focus-within + .media-volume-range-wrapper,
      .media-volume-range-wrapper:hover,
      .media-volume-range-wrapper:focus,
      .media-volume-range-wrapper:focus-within {
        opacity: 1;
        visibility: visible;
      }

      [role='menu'] {
        position: absolute;
        margin-bottom: 10px;
      }

      @container (inline-size >=484px) {
        [role='menu'] {
          margin-bottom: 7px;
        }
      }

      .spacer {
        flex-grow: 1;
        height: 100%;
      }
    </style>

    <media-controller
      defaultsubtitles="{{defaultsubtitles}}"
      defaultduration="{{defaultduration}}"
      gesturesdisabled="{{disabled}}"
      hotkeys="{{hotkeys}}"
      nohotkeys="{{nohotkeys}}"
      defaultstreamtype="on-demand"
    >
      <slot name="media" slot="media"></slot>
      <slot name="poster" slot="poster"></slot>
      <media-error-dialog slot="dialog"></media-error-dialog>

      <div slot="top-chrome" class="header">
        <template if="mediatitle">
          <h1 class="title">{{mediatitle}}</h1>
        </template>
        <template if="mediabyline">
          <h2 class="byline">{{mediabyline}}</h2>
        </template>
      </div>

      <div slot="centered-chrome">
        <media-play-button>
          <svg
            slot="play"
            aria-hidden="true"
            viewBox="0 0 24 24"
            stroke-width="1"
            stroke="currentColor"
            fill="currentColor"
            stroke-linecap="round"
            stroke-linejoin="round"
          >
            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
            <path d="M7 4v16l13 -8z"></path>
          </svg>
          <svg
            slot="pause"
            aria-hidden="true"
            viewBox="0 0 24 24"
            stroke-width="1"
            stroke="currentColor"
            fill="currentColor"
            stroke-linecap="round"
            stroke-linejoin="round"
          >
            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
            <rect x="6" y="5" width="4" height="14" rx="0"></rect>
            <rect x="14" y="5" width="4" height="14" rx="0"></rect>
          </svg>
        </media-play-button>
      </div>

      <div class="control-bar-container" id="vimeonova-bounds">
        <media-play-button>
          <svg
            slot="play"
            aria-hidden="true"
            viewBox="0 0 24 24"
            stroke-width="1"
            stroke="currentColor"
            fill="currentColor"
            stroke-linecap="round"
            stroke-linejoin="round"
          >
            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
            <path d="M7 4v16l13 -8z"></path>
          </svg>
          <svg
            slot="pause"
            aria-hidden="true"
            viewBox="0 0 24 24"
            stroke-width="1"
            stroke="currentColor"
            fill="currentColor"
            stroke-linecap="round"
            stroke-linejoin="round"
          >
            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
            <rect x="6" y="5" width="4" height="14" rx="0"></rect>
            <rect x="14" y="5" width="4" height="14" rx="0"></rect>
          </svg>
        </media-play-button>

        <div class="control-bar-right">
          <media-time-range class="small">
            <media-preview-time-display slot="preview"></media-preview-time-display>
            <div part="arrow" slot="preview"></div>
            <media-time-display slot="current"></media-time-display>
            <div part="arrow" slot="current"></div>
          </media-time-range>
          <media-control-bar>
            <media-time-range class="large" bounds="vimeonova-bounds">
              <media-preview-thumbnail slot="preview"></media-preview-thumbnail>
              <media-preview-time-display slot="preview"></media-preview-time-display>
              <div part="arrow" slot="preview"></div>
              <media-time-display slot="current"></media-time-display>
              <div part="arrow" slot="current"></div>
            </media-time-range>
            <div class="spacer"></div>
            <media-captions-menu-button>
              <svg slot="on" aria-hidden="true" fill="none" viewBox="0 0 24 24">
                <path
                  fill="currentColor"
                  fill-rule="evenodd"
                  d="M2 8a4 4 0 0 1 4-4h12a4 4 0 0 1 4 4v7a4 4 0 0 1-4 4h-.532l-2.2 2.64a1 1 0 0 1-1.536 0l-2.2-2.64H5.999A4 4 0 0 1 2 15V8Zm13.57.183a3.333 3.333 0 0 1 2.338.826.82.82 0 0 1-1.083 1.232 1.693 1.693 0 0 0-2.336.097 1.674 1.674 0 0 0 0 2.324 1.692 1.692 0 0 0 2.336.097.82.82 0 0 1 1.083 1.232 3.333 3.333 0 0 1-4.6-.191 3.314 3.314 0 0 1 0-4.6m2.261-1.017c-.856.035-1.666.4-2.261 1.017Zm-6.7-.005a3.338 3.338 0 0 1 2.342.828.825.825 0 0 1-1.089 1.239 1.688 1.688 0 0 0-2.33.097 1.669 1.669 0 0 0 0 2.316 1.688 1.688 0 0 0 2.33.097.825.825 0 1 1 1.09 1.24 3.338 3.338 0 0 1-4.608-.192 3.319 3.319 0 0 1 0-4.606m2.265-1.02a3.347 3.347 0 0 0-2.265 1.02Z"
                  clip-rule="evenodd"
                />
              </svg>
              <svg slot="off" aria-hidden="true" fill="none" viewBox="0 0 24 24">
                <path
                  stroke="currentColor"
                  stroke-linecap="round"
                  stroke-linejoin="round"
                  stroke-width="1.6"
                  d="M17.367 9.625a2.513 2.513 0 0 0-3.469.144 2.494 2.494 0 0 0 0 3.461 2.513 2.513 0 0 0 3.469.145m-6.7-3.75a2.513 2.513 0 0 0-3.469.144 2.494 2.494 0 0 0 0 3.461 2.512 2.512 0 0 0 3.469.145"
                />
                <path
                  fill="currentColor"
                  d="M17 18v-1h-.468l-.3.36L17 18Zm-5 0 .768-.64-.3-.36H12v1Zm2.5 3-.768.64a1 1 0 0 0 1.536 0L14.5 21ZM6 6h12V4H6v2Zm14 2v7h2V8h-2ZM4 15V8H2v7h2Zm14 2h-1v2h1v-2Zm-6 0H6v2h6v-2Zm4.232.36-2.5 3 1.536 1.28 2.5-3-1.536-1.28Zm-.964 3-2.5-3-1.536 1.28 2.5 3 1.536-1.28ZM2 15a4 4 0 0 0 4 4v-2a2 2 0 0 1-2-2H2Zm18 0a2 2 0 0 1-2 2v2a4 4 0 0 0 4-4h-2Zm-2-9a2 2 0 0 1 2 2h2a4 4 0 0 0-4-4v2ZM6 4a4 4 0 0 0-4 4h2a2 2 0 0 1 2-2V4Z"
                />
              </svg>
            </media-captions-menu-button>
            <media-playback-rate-menu-button></media-playback-rate-menu-button>
            <div class="media-volume-wrapper">
              <media-mute-button>
                <svg
                  slot="high"
                  aria-hidden="true"
                  viewBox="0 0 24 25"
                  stroke-width="1.8"
                  stroke="currentColor"
                  fill="none"
                  stroke-linecap="round"
                  stroke-linejoin="round"
                >
                  <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                  <path d="M15 8a5 5 0 0 1 0 8"></path>
                  <path d="M17.7 5a9 9 0 0 1 0 14"></path>
                  <path
                    d="M6 15h-2a1 1 0 0 1 -1 -1v-4a1 1 0 0 1 1 -1h2l3.5 -4.5a0.8 .8 0 0 1 1.5 .5v14a0.8 .8 0 0 1 -1.5 .5l-3.5 -4.5"
                    fill="currentColor"
                  ></path>
                </svg>
                <svg
                  slot="medium"
                  aria-hidden="true"
                  viewBox="0 0 24 25"
                  stroke-width="1.8"
                  stroke="currentColor"
                  fill="none"
                  stroke-linecap="round"
                  stroke-linejoin="round"
                >
                  <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                  <path d="M15 8a5 5 0 0 1 0 8"></path>
                  <path d="M17.7 5a9 9 0 0 1 0 14"></path>
                  <path
                    d="M6 15h-2a1 1 0 0 1 -1 -1v-4a1 1 0 0 1 1 -1h2l3.5 -4.5a0.8 .8 0 0 1 1.5 .5v14a0.8 .8 0 0 1 -1.5 .5l-3.5 -4.5"
                    fill="currentColor"
                  ></path>
                </svg>
                <svg
                  slot="low"
                  aria-hidden="true"
                  viewBox="0 0 24 25"
                  stroke-width="1.8"
                  stroke="currentColor"
                  fill="none"
                  stroke-linecap="round"
                  stroke-linejoin="round"
                >
                  <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                  <path d="M15 8a5 5 0 0 1 0 8"></path>
                  <path
                    d="M6 15h-2a1 1 0 0 1 -1 -1v-4a1 1 0 0 1 1 -1h2l3.5 -4.5a0.8 .8 0 0 1 1.5 .5v14a0.8 .8 0 0 1 -1.5 .5l-3.5 -4.5"
                    fill="currentColor"
                  ></path>
                </svg>
                <svg
                  slot="off"
                  aria-hidden="true"
                  viewBox="0 0 24 25"
                  stroke-width="1.8"
                  stroke="currentColor"
                  fill="none"
                  stroke-linecap="round"
                  stroke-linejoin="round"
                >
                  <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                  <path
                    d="M6 15h-2a1 1 0 0 1 -1 -1v-4a1 1 0 0 1 1 -1h2l3.5 -4.5a0.8 .8 0 0 1 1.5 .5v14a0.8 .8 0 0 1 -1.5 .5l-3.5 -4.5"
                  ></path>
                  <path d="M16 10l4 4m0 -4l-4 4"></path>
                </svg>
              </media-mute-button>
              <div class="media-volume-range-wrapper">
                <media-volume-range></media-volume-range>
              </div>
            </div>
            <media-rendition-menu-button>
              <svg slot="icon" class="media-hd-icon" aria-hidden="true" viewBox="0 0 28 24">
                <path
                  fill="currentColor"
                  d="M19.866 18.971h-5.458L16.728 5h5.239c1.437 0 2.638.289 3.602.866.964.578 1.648 1.403 2.053 2.477.405 1.073.485 2.351.239 3.834-.237 1.428-.716 2.649-1.44 3.663a7.076 7.076 0 0 1-2.756 2.326c-1.114.537-2.38.805-3.8.805Zm-1.133-3.22h1.378c.691 0 1.308-.12 1.849-.361.546-.246 1-.655 1.364-1.228.369-.578.635-1.367.798-2.367.155-.946.15-1.676-.013-2.19-.164-.519-.476-.878-.935-1.078-.46-.205-1.053-.307-1.78-.307h-1.406l-1.255 7.531ZM0 18.971 2.32 5h3.792l-.9 5.458h5.02L11.134 5h3.794l-2.32 13.971H8.814l.9-5.457h-5.02l-.901 5.457H0Z"
                />
              </svg>
              <svg slot="icon" class="media-sd-icon hidden" aria-hidden="true" viewBox="0 0 28 24">
                <path
                  fill="currentColor"
                  d="M19.857 18.967H14.41L16.725 5.02h5.23c1.434 0 2.633.288 3.595.864.962.577 1.646 1.401 2.05 2.472.404 1.072.483 2.347.238 3.827-.236 1.426-.715 2.645-1.437 3.657a7.062 7.062 0 0 1-2.75 2.322c-1.113.536-2.377.804-3.794.804Zm-1.13-3.214h1.375c.69 0 1.306-.12 1.846-.361.545-.246.999-.654 1.362-1.226.367-.577.633-1.364.797-2.363.154-.944.15-1.673-.014-2.186-.164-.517-.474-.876-.933-1.076-.459-.204-1.051-.306-1.777-.306H19.98l-1.253 7.518Zm-8.496-6.374c.041-.45-.068-.801-.327-1.056-.258-.258-.694-.388-1.307-.388-.39 0-.717.046-.98.136-.26.091-.461.216-.607.375-.14.159-.229.343-.265.551a.792.792 0 0 0 .007.45.85.85 0 0 0 .279.36c.14.11.324.207.551.294.232.086.507.163.824.231l1.09.245c.744.164 1.369.38 1.872.647.509.263.909.577 1.199.94.29.363.481.77.572 1.219.095.45.098.94.007 1.47-.155.918-.51 1.694-1.07 2.33-.558.635-1.286 1.119-2.185 1.45-.899.331-1.939.497-3.119.497-1.207 0-2.233-.18-3.078-.538-.84-.363-1.448-.917-1.825-1.662-.372-.748-.463-1.704-.272-2.866h3.595c-.054.426-.009.785.136 1.076.146.29.38.51.702.66.322.15.724.225 1.205.225.409 0 .758-.05 1.049-.15.29-.1.52-.238.688-.415.168-.177.27-.38.306-.606a.741.741 0 0 0-.109-.559c-.109-.163-.306-.31-.592-.442s-.68-.252-1.178-.361l-1.335-.3c-1.185-.272-2.08-.722-2.683-1.348-.604-.627-.817-1.485-.64-2.574.145-.89.51-1.666 1.096-2.329.59-.667 1.34-1.185 2.247-1.553.913-.372 1.923-.558 3.03-.558 1.126 0 2.068.188 2.826.565.763.377 1.31.906 1.642 1.587.336.68.426 1.48.272 2.397h-3.623Z"
                />
              </svg>
              <svg slot="icon" class="media-4k-icon hidden" aria-hidden="true" viewBox="0 0 28 24">
                <path
                  fill="currentColor"
                  d="M13.163 18.887 15.47 5h3.77l-.922 5.615h.19L23.606 5H28l-5.696 6.184 3.499 7.703H21.3l-2.224-5.207-1.546 1.654-.596 3.553h-3.77ZM0 16.717l.488-2.929L7.54 5h2.658l-.65 3.906h-1.52L4.232 13.68l-.027.108h8.246l-.489 2.93H0Zm6.401 2.17.516-3.065.298-1.274L8.788 5h3.526L10.01 18.887H6.4Z"
                />
              </svg>
            </media-rendition-menu-button>
            <media-pip-button>
              <svg
                slot="enter"
                aria-hidden="true"
                viewBox="0 0 24 24"
                stroke-width="2"
                stroke="currentColor"
                fill="none"
                stroke-linecap="round"
                stroke-linejoin="round"
              >
                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                <path d="M11 19h-6a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v4"></path>
                <rect x="14" y="14" width="7" height="5" rx="1" fill="currentColor"></rect>
                <line x1="7" y1="9" x2="11" y2="13"></line>
                <path d="M8 13h3v-3"></path>
              </svg>
              <svg
                slot="exit"
                aria-hidden="true"
                viewBox="0 0 24 24"
                stroke-width="2"
                stroke="currentColor"
                fill="none"
                stroke-linecap="round"
                stroke-linejoin="round"
              >
                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                <path d="M11 19h-6a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v4"></path>
                <rect x="14" y="14" width="7" height="5" rx="1" fill="currentColor"></rect>
                <line x1="7" y1="9" x2="11" y2="13"></line>
                <path d="M7 12v-3h3"></path>
              </svg>
            </media-pip-button>
            <media-airplay-button></media-airplay-button>
            <media-cast-button>
              <svg
                slot="enter"
                viewBox="0 0 24 24"
                stroke-width="2"
                stroke="currentColor"
                fill="none"
                stroke-linecap="round"
                stroke-linejoin="round"
              >
                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                <line x1="3" y1="19" x2="3.01" y2="19"></line>
                <path d="M7 19a4 4 0 0 0 -4 -4"></path>
                <path d="M11 19a8 8 0 0 0 -8 -8"></path>
                <path d="M15 19h3a3 3 0 0 0 3 -3v-8a3 3 0 0 0 -3 -3h-12a3 3 0 0 0 -2.8 2"></path>
              </svg>
              <svg
                slot="exit"
                viewBox="0 0 24 24"
                stroke-width="2"
                stroke="currentColor"
                fill="none"
                stroke-linecap="round"
                stroke-linejoin="round"
              >
                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                <path d="M3 19h.01"></path>
                <path d="M7 19a4 4 0 0 0 -4 -4"></path>
                <path d="M11 19a8 8 0 0 0 -8 -8"></path>
                <path
                  d="M15 19h3a3 3 0 0 0 .875 -.13m1.997 -2.002a3 3 0 0 0 .128 -.868v-8a3 3 0 0 0 -3 -3h-9m-3.865 .136a3 3 0 0 0 -1.935 1.864"
                ></path>
                <path d="M3 3l18 18"></path>
              </svg>
            </media-cast-button>
            <media-fullscreen-button>
              <svg slot="enter" aria-hidden="true" fill="none" viewBox="0 0 24 24">
                <path
                  stroke="currentColor"
                  stroke-linecap="round"
                  stroke-linejoin="round"
                  stroke-width="2"
                  d="M15 5h4v4M15 9l4-4M9 19H5v-4M5 19l4-4M15 19h4v-4M15 15l4 4M9 5H5v4M5 5l4 4"
                />
              </svg>
              <svg slot="exit" aria-hidden="true" fill="none" viewBox="0 0 24 24">
                <path
                  stroke="currentColor"
                  stroke-linecap="round"
                  stroke-linejoin="round"
                  stroke-width="2"
                  d="M5 9h4V5M4.5 4.5 9 9M5 15h4v4M4.5 19.5 9 15M19 9h-4V5M15 9l4.5-4.5M19 15h-4v4M15 15l4.5 4.5"
                />
              </svg>
            </media-fullscreen-button>
          </media-control-bar>
        </div>
      </div>

      <media-captions-menu anchor="auto" hidden></media-captions-menu>
      <media-playback-rate-menu anchor="auto" hidden></media-playback-rate-menu>
      <media-rendition-menu anchor="auto" hidden></media-rendition-menu>
    </media-controller>

  `;
}

class MediaThemeVimeonovaElement extends MediaThemeElement {
  static template = template;
}

if (globalThis.customElements && !globalThis.customElements.get('media-theme-vimeonova')) {
  globalThis.customElements.define('media-theme-vimeonova', MediaThemeVimeonovaElement);
}

export default MediaThemeVimeonovaElement;
