import { addTranslation } from '../utils/i18n.js';
import type { TranslateDictionary } from './en.js';

export const ZhTw: TranslateDictionary = {
  'Start airplay': '開始 AirPlay 投放',
  'Stop airplay': '停止 AirPlay 投放',
  Audio: '音訊',
  Captions: '字幕',
  'Enable captions': '開啟字幕',
  'Disable captions': '關閉字幕',
  'Start casting': '開始投放',
  'Stop casting': '停止投放',
  'Enter fullscreen mode': '全螢幕',
  'Exit fullscreen mode': '離開全螢幕',
  Mute: '靜音',
  Unmute: '取消靜音',
  'Enter picture in picture mode': '開啟子母畫面',
  'Exit picture in picture mode': '關閉子母畫面',
  Play: '播放',
  Pause: '暫停',
  'Playback rate': '播放速度',
  'Playback rate {playbackRate}': '播放速度：{playbackRate}',
  Quality: '畫質',
  'Seek backward': '倒轉',
  'Seek forward': '快轉',

  Settings: '設定',
  Auto: '自動',
  'audio player': '音訊播放器',
  'video player': '影片播放器',
  volume: '音量',
  seek: '快轉/倒轉',
  'closed captions': '隱藏式輔助字幕',
  'current playback rate': '目前播放速度',
  'playback time': '播放時間',
  'media loading': '載入中⋯',
  settings: '設定',
  'audio tracks': '音軌',
  quality: '畫質',
  play: '播放',
  pause: '暫停',
  mute: '靜音',
  unmute: '取消靜音',
  live: '直播',
  Off: '關閉',
  'start airplay': '開始 AirPlay 投放',
  'stop airplay': '停止 AirPlay 投放',
  'start casting': '開始投放',
  'stop casting': '停止投放',
  'enter fullscreen mode': '全螢幕',
  'exit fullscreen mode': '離開全螢幕',
  'enter picture in picture mode': '開啟子母畫面',
  'exit picture in picture mode': '關閉子母畫面',
  'seek to live': '跳到直播',
  'playing live': '正在直播',
  'seek back {seekOffset} seconds': '倒轉 {seekOffset} 秒',
  'seek forward {seekOffset} seconds': '快轉 {seekOffset} 秒',
  'Network Error': '網路錯誤',
  'Decode Error': '解碼錯誤',
  'Source Not Supported': '不支援的媒體來源',
  'Encryption Error': '加密錯誤',
  'A network error caused the media download to fail.':
    '網路錯誤導致媒體下載失敗。',
  'A media error caused playback to be aborted. The media could be corrupt or your browser does not support this format.':
    '媒體錯誤導致播放中止，可能是檔案損毀，或瀏覽器不支援這個格式。',
  'An unsupported error occurred. The server or network failed, or your browser does not support this format.':
    '發生不支援的錯誤。伺服器或網路可能有問題，或瀏覽器不支援這個格式。',
  'The media is encrypted and there are no keys to decrypt it.':
    '媒體已加密，但找不到解密金鑰。',
};

addTranslation('zh-TW', ZhTw);
