import { addTranslation } from '../utils/i18n.js';
import type { TranslateDictionary } from './en.js';

export const ZhCn: TranslateDictionary = {
  'Start airplay': '开始 AirPlay',
  'Stop airplay': '停止 AirPlay',
  Audio: '音频',
  Captions: '字幕',
  'Enable captions': '开启字幕',
  'Disable captions': '关闭字幕',
  'Start casting': '开始投屏',
  'Stop casting': '停止投屏',
  'Enter fullscreen mode': '进入全屏',
  'Exit fullscreen mode': '退出全屏',
  Mute: '静音',
  Unmute: '恢复音量',
  'Enter picture in picture mode': '开启画中画',
  'Exit picture in picture mode': '关闭画中画',
  Play: '播放',
  Pause: '暂停',
  'Playback rate': '播放速度',
  'Playback rate {playbackRate}': '播放速度：{playbackRate}',
  Quality: '清晰度',
  'Seek backward': '快退',
  'Seek forward': '快进',

  Settings: '设置',
  Auto: '自动',
  'audio player': '音频播放器',
  'video player': '视频播放器',
  volume: '音量',
  seek: '跳转',
  'closed captions': '隐藏式辅助字幕',
  'current playback rate': '当前播放速度',
  'playback time': '播放时间',
  'media loading': '媒体加载中...',
  settings: '设置',
  'audio tracks': '音轨',
  quality: '清晰度',
  play: '播放',
  pause: '暂停',
  mute: '静音',
  unmute: '恢复音量',
  live: '直播',
  Off: '关闭',
  'start airplay': '开始 AirPlay',
  'stop airplay': '停止 AirPlay',
  'start casting': '开始投屏',
  'stop casting': '停止投屏',
  'enter fullscreen mode': '进入全屏',
  'exit fullscreen mode': '退出全屏',
  'enter picture in picture mode': '开启画中画',
  'exit picture in picture mode': '关闭画中画',
  'seek to live': '跳转至直播进度',
  'playing live': '正在直播中',
  'seek back {seekOffset} seconds': '快退 {seekOffset} 秒',
  'seek forward {seekOffset} seconds': '快进 {seekOffset} 秒',
  'Network Error': '网络错误',
  'Decode Error': '解码失败',
  'Source Not Supported': '不支持的媒体来源',
  'Encryption Error': '加密错误',
  'A network error caused the media download to fail.':
    '媒体下载失败，请检查网络连接。',
  'A media error caused playback to be aborted. The media could be corrupt or your browser does not support this format.':
    '媒体错误导致播放中止。可能是文件损坏，或浏览器不支持该格式。',
  'An unsupported error occurred. The server or network failed, or your browser does not support this format.':
    '发生未支持的错误，可能是服务器或网络故障，或浏览器不支持该格式。',
  'The media is encrypted and there are no keys to decrypt it.':
    '媒体已加密，缺少解密密钥。',
};
addTranslation('zh-CN', ZhCn);